/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.cas.helper.AppLogHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.BankVcAdjustValidator;

public class BankVcAdjustOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("accountbank");
        fieldKeys.add("currency");
        fieldKeys.add("bizdateend");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BankVcAdjustValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String endDate = this.getOption().getVariableValue("endDate", null);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> checkResults = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> su = new ArrayList<DynamicObject>(dataEntities.length);
        Map variables = this.getOption().getVariables();
        String bStatusIds = (String)variables.get("bStatus");
        String cStatusIds = (String)variables.get("cStatus");
        String msg = "";
        for (DynamicObject bankVc : dataEntities) {
            String bankVcId = bankVc.getString("id");
            Date bizEndDate = DateUtils.stringToDate((String)endDate, (String)"yyyy-MM-dd HH:mm:ss");
            boolean createAdjust = this.isCreateAdjustBalance(bankVc, bizEndDate);
            if (!createAdjust) continue;
            if (bStatusIds.indexOf(bankVcId) != -1) {
                msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u751f\u6210\u5931\u8d25\u3002\u5f53\u65e5\u4f59\u989d\u8c03\u8282\u8868\u5df2\u63d0\u4ea4\u81f3\u7cfb\u7edf\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"BankVcAdjustOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("accountbank").getString("number"), bankVc.getDynamicObject("currency").getString("name"));
                this.addErrorInfo(msg, bankVcId);
                continue;
            }
            if (cStatusIds.indexOf(bankVcId) != -1) {
                msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u751f\u6210\u5931\u8d25\u3002\u5f53\u65e5\u4f59\u989d\u8c03\u8282\u8868\u5df2\u5ba1\u6279\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"BankVcAdjustOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("accountbank").getString("number"), bankVc.getDynamicObject("currency").getString("name"));
                this.addErrorInfo(msg, bankVcId);
                continue;
            }
            DynamicObject checkResult = BusinessDataServiceHelper.newDynamicObject((String)"cas_checkresult");
            checkResult.set("org", bankVc.get("org"));
            checkResult.set("accountbank", bankVc.get("accountbank"));
            checkResult.set("currency", bankVc.get("currency"));
            checkResult.set("enddate", (Object)bizEndDate);
            checkResult.set("bizdateend", (Object)bizEndDate);
            checkResults.add(checkResult);
            su.add(bankVc);
        }
        e.setDataEntities(su.toArray(new DynamicObject[0]));
        try {
            List successPkIds;
            OperationResult result = OperateServiceHelper.execOperate((String)"balance", (String)"cas_checkresult", (DynamicObject[])checkResults.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (result != null && null != result.getAllErrorInfo() && result.getAllErrorInfo().size() > 0) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)result.getAllErrorInfo().get(0);
                throw new KDBizException(operateErrorInfo.getMessage());
            }
            if (result != null && result.isSuccess() && EmptyUtil.isNoEmpty((Object)(successPkIds = result.getSuccessPkIds()))) {
                ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>();
                QFilter qFilter = new QFilter("id", "in", (Object)successPkIds);
                DynamicObjectCollection balanceAdjusts = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"billno, org.name orgname, bankaccount.bankaccountnumber bankaccountnumber, currency.name currencyname, bizdate", (QFilter[])qFilter.toArray());
                for (DynamicObject balanceAdjust : balanceAdjusts) {
                    MultiLangEnumBridge opDesc = AppLogHelper.buildMultiLangBridge((String)"\u7f16\u53f7%1$s\uff08\u7ec4\u7ec7\uff1a%2$s\uff0c\u8d26\u53f7\uff1a%3$s\uff0c\u5e01\u79cd\uff1a%4$s\uff0c\u622a\u6b62\u65e5\u671f\uff1a%5$s\uff09\uff0c\u4fdd\u5b58\u6210\u529f\u3002", (String)"BankVcAdjustOp_5", (String)"fi-cas-opplugin");
                    MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868", (String)"BankVcAdjustOp_6", (String)"fi-cas-opplugin");
                    AppLogInfo appLog = AppLogHelper.createAppLog((String)"cas_bankvccheck", (long)RequestContext.get().getOrgId(), (String)"balanceadjust", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDesc, (Object[])new Object[]{balanceAdjust.getString("billno"), balanceAdjust.getString("orgname"), balanceAdjust.getString("bankaccountnumber"), balanceAdjust.getString("currencyname"), DateUtils.getMonthDay((Date)balanceAdjust.getDate("bizdate"))});
                    appLogInfos.add(appLog);
                }
                LogServiceHelper.addBatchLog(appLogInfos);
            }
        }
        catch (Exception ep) {
            throw new KDBizException(ep.getMessage());
        }
    }

    private void addErrorInfo(String msg, Object pkValue) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(msg);
        this.operationResult.setSuccess(false);
        operateErrorInfo.setLevel(ErrorLevel.FatalError);
        operateErrorInfo.setPkValue(pkValue);
        this.operationResult.addErrorInfo(operateErrorInfo);
    }

    private boolean isCreateAdjustBalance(DynamicObject bankVc, Date endDate) {
        String bankVcId = bankVc.getString("id");
        DynamicObject org = bankVc.getDynamicObject("org");
        QFilter filterRecEdc = new QFilter("org", "=", org.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filterRecEdc});
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s):\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u672a\u542f\u7528\u5bf9\u8d26\uff0c\u65e0\u9700\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVcAdjustOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("accountbank").getString("number"), bankVc.getDynamicObject("currency").getString("name"));
            this.addErrorInfo(msg, bankVcId);
            return false;
        }
        Date dateEnd = endDate;
        DynamicObject startPeriod = dynamicObject.getDynamicObject("recperiod");
        Date startPeriodBegin = startPeriod.getDate("begindate");
        if (dateEnd.compareTo(startPeriodBegin) < 0) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s):\u6240\u9009\u8d44\u91d1\u7ec4\u7ec7\u5f53\u524d\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u542f\u7528\u5bf9\u8d26\u671f\u95f4\u7b2c\u4e00\u65e5\uff0c\u65e0\u9700\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVcAdjustOp_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("accountbank").getString("number"), bankVc.getDynamicObject("currency").getString("name"));
            this.addErrorInfo(msg, bankVcId);
            return false;
        }
        return true;
    }
}

