/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.DBRouteConst;

public class CashMgtInitSetConfirmOp
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String strsql;
        super.endOperationTransaction(e);
        DynamicObject newCashMgtInitInfo = e.getDataEntities()[0];
        DynamicObjectCollection orgs = newCashMgtInitInfo.getDynamicObjectCollection("org");
        ArrayList<Long> orgPks = new ArrayList<Long>();
        for (DynamicObject org : orgs) {
            orgPks.add(org.getLong(2));
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgPks)};
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,periodtype,startperiod,standardcurrency,exratetable,startperiod", (QFilter[])filters);
        ArrayList<SqlParameter[]> deleteParams = new ArrayList<SqlParameter[]>(infos.length);
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(infos.length);
        ArrayList<SqlParameter[]> updateEntryBanks = new ArrayList<SqlParameter[]>(16);
        for (DynamicObject oldCashMgtInitInfo : infos) {
            long oldperiodid;
            long id = oldCashMgtInitInfo.getLong("id");
            long orgid = newCashMgtInitInfo.getLong("org.id");
            long periodtypeid = newCashMgtInitInfo.getDynamicObject("periodtype").getLong("id");
            long startperiodid = newCashMgtInitInfo.getDynamicObject("startperiod").getLong("id");
            long standardcurrencyid = newCashMgtInitInfo.getDynamicObject("standardcurrency").getLong("id");
            long exratetableid = newCashMgtInitInfo.getDynamicObject("exratetable").getLong("id");
            if (oldCashMgtInitInfo.getDynamicObject("startperiod") != null && startperiodid != (oldperiodid = oldCashMgtInitInfo.getDynamicObject("startperiod").getLong("id"))) {
                SqlParameter[] params = new SqlParameter[]{new SqlParameter(":forgid", -5, (Object)orgid)};
                deleteParams.add(params);
                SqlParameter[] setParams = new SqlParameter[]{new SqlParameter(":fjournaldebit", 3, (Object)new BigDecimal(0)), new SqlParameter(":fjournalcredit", 3, (Object)new BigDecimal(0)), new SqlParameter(":fjournalbalance", 3, (Object)new BigDecimal(0)), new SqlParameter(":fid", -5, (Object)id)};
                updateEntryBanks.add(setParams);
            }
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(":fperiodtypeid", -5, (Object)periodtypeid), new SqlParameter(":fstartperiodid", -5, (Object)startperiodid), new SqlParameter(":fstacurrencyid", -5, (Object)standardcurrencyid), new SqlParameter(":fexratetableid", -5, (Object)exratetableid), new SqlParameter(":fid", -5, (Object)id)};
            updateParams.add(params);
        }
        if (deleteParams.size() > 0) {
            String deljournalsql = "delete from t_cas_bankjournal where forgid = ? and fperiodid = 0 ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)deljournalsql, deleteParams);
            String delstatementsql = "delete from t_cas_bankstatement where forgid = ? and fperiodid = 0 ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)delstatementsql, deleteParams);
        }
        if (updateParams.size() > 0) {
            strsql = " update T_CAS_CashMgtInit set fperiodtypeid = ?,fstartperiodid = ? ,fstacurrencyid = ?,fexratetableid = ? where fid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)strsql, updateParams);
        }
        if (updateEntryBanks.size() > 0) {
            strsql = " update T_CAS_CashMgtInitBank set fjournaldebit = ?,fjournalcredit = ? ,fjournalbalance = ? where fid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)strsql, updateEntryBanks);
        }
    }
}

