/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.validator.BillAutoAuditValidator;
import kd.fi.cas.validator.CommonOpValidator;

public abstract class CommonOpServicePlugIn
extends AbstractOperationServicePlugIn {
    protected IOpService service;
    protected String operationCNName;
    protected AbstractValidator validator;
    protected ParamMap param = new ParamMap();
    protected List<Object> failedPks = new ArrayList<Object>();
    protected String operateKey;

    protected void initialize() {
    }

    protected abstract IOpService registerService();

    protected AbstractValidator registerValidator() {
        return null;
    }

    public CommonOpServicePlugIn() {
        this.service = this.registerService();
        this.validator = this.registerValidator();
        this.initialize();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        OperateOption option = this.getOption();
        for (DynamicObject info : e.getDataEntities()) {
            if (option != null && option.containsVariable("isPayScheBack") && "true".equals(option.getVariableValue("isPayScheBack"))) {
                this.param.put("isPayScheBack", (Object)option.getVariableValue("isPayScheBack"));
                this.param.put("payScheOPType", (Object)option.getVariableValue("payScheOPType"));
                this.param.put("payScheRelease", (Object)option.getVariableValue("payScheRelease"));
                this.param.put("delPayApplyBillIds", (Object)option.getVariableValue("delPayApplyBillIds"));
            }
            this.service.process(info);
        }
    }

    protected void handleException(Exception exc, DynamicObject info) {
        this.operationResult.setSuccess(false);
        OperateErrorInfo error = new OperateErrorInfo();
        String billNo = info.getString("billno");
        error.setMessage(billNo + "\uff1a" + exc.getMessage());
        error.setTitle(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"CommonOpServicePlugIn_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), this.operationCNName));
        error.setLevel(ErrorLevel.FatalError);
        this.operationResult.addErrorInfo(error);
        this.failedPks.add(info.getPkValue());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.operateKey = ((AbstractValidator)e.getValidators().get(0)).getOperateKey();
        if (this.operationCNName == null) {
            this.operationCNName = ((AbstractValidator)e.getValidators().get(0)).getOperationName();
        }
        this.param.put("operateKey", (Object)this.operateKey);
        this.param.getParams().putAll(this.operateOption.getVariables());
        this.service.prepare(e.getDataEntities(), this.param);
        if (this.validator == null) {
            this.validator = new CommonOpValidator(this.service);
        }
        e.addValidator(this.validator);
        if (!CasHelper.isEmpty(this.getOption().getVariables().get("gl_intellexecschema"))) {
            e.addValidator((AbstractValidator)new BillAutoAuditValidator());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        List successPkIds = this.operationResult.getSuccessPkIds();
        for (Object pk : this.failedPks) {
            successPkIds.remove(pk);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        List selectors = this.service.getSelector();
        if (selectors != null) {
            lst.addAll(selectors);
        }
    }
}

