/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.ExchangeBillBookJournalBuilder;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.writeback.PaymentSaveOrSubmitWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.validator.ExchangeBillWriteBackValidator;

public class ExchangeBillExchangeOp
extends AbstractOperationServicePlugIn {
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private List<DynamicObject> srcBillList = new ArrayList<DynamicObject>(0);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.getSelector());
    }

    private List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(22);
        list.add("billno");
        list.add("biztype");
        list.add("billstatus");
        list.add("bizdate");
        list.add("org");
        list.add("remark");
        list.add("accounttype");
        list.add("buyingcurrency");
        list.add("buyingaccount");
        list.add("buyamount");
        list.add("buyingexchangerate");
        list.add("buyinglocalamount");
        list.add("sellingcurrency");
        list.add("sellingaccount");
        list.add("sellamount");
        list.add("sellingexchangerate");
        list.add("sellinglocalamount");
        list.add("commissioncurrency");
        list.add("paycommissionaccount");
        list.add("commissionamount");
        list.add("commissionexchangerate");
        list.add("commissionlocalamount");
        list.add("exchangedate");
        list.add("buybankcheckflag");
        list.add("sellingbankcheckflag");
        list.add("feebankcheckflag");
        list.add("acttradedate");
        list.add("createtime");
        list.add("sourcebilltype");
        return list;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ExchangeBillWriteBackValidator(WriteBackOperateEnum.EXCHANGEVALIDATE));
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject exchangeBill = dataEntity.getDataEntity();
                    String billStatus = exchangeBill.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\uff0c\u65b9\u53ef\u5151\u6362\u3002", (String)"ExchangeBillExchangeOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                    if ("bd_accountbanks".equals(exchangeBill.getString("accounttype"))) {
                        DynamicObject accountBank = exchangeBill.getDynamicObject("buyingaccount");
                        if (null != accountBank && AccountBankHelper.isClosed((long)accountBank.getLong("id"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("bankaccountnumber")));
                        }
                        DynamicObject sellAccountBank = exchangeBill.getDynamicObject("sellingaccount");
                        if (null != sellAccountBank && AccountBankHelper.isClosed((long)sellAccountBank.getLong("id"))) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), sellAccountBank.getString("bankaccountnumber")));
                        }
                    }
                    ExchangeBillExchangeOp.this.journalServiceAdapter.validateBook((IBookJournalBuilder)new ExchangeBillBookJournalBuilder(), exchangeBill);
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        this.srcBillList = ((Stream)Arrays.stream(infos).parallel()).filter(d -> CasHelper.isNotEmpty((Object)d.getString("sourcebilltype"))).collect(Collectors.toList());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] exchangeBills;
        super.endOperationTransaction(e);
        for (DynamicObject exchangeBill : exchangeBills = e.getDataEntities()) {
            this.journalServiceAdapter.book(exchangeBill);
            exchangeBill.set("billstatus", (Object)"F");
        }
        SaveServiceHelper.save((DynamicObject[])exchangeBills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)info.getDataEntityType().getName(), (String)"billstatus");
            if (!"F".equals(bill.getString("billstatus"))) continue;
            VoucherCheckHepler.doVoucherCheck((DynamicObject)info);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (this.srcBillList.size() > 0) {
            ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
            for (DynamicObject bill : this.srcBillList) {
                WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                taskInfo.setBillId((Long)bill.getPkValue());
                taskInfo.setDataEntity(bill.getDataEntityType().getName());
                taskInfo.setSourceEntity(bill.getString("sourcebilltype"));
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("operate", "exchange");
                taskInfo.setParam(param);
                taskInfos.add(taskInfo);
            }
            WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.EXCHANGE, PaymentSaveOrSubmitWriteBackConsumer.class);
        }
    }
}

