/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.util.StringUtils;

public class FundFlowItemEnableOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("level");
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("property");
        e.getFieldKeys().add("direction");
        e.getFieldKeys().add("enabledate");
        e.getFieldKeys().add("disabledate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject data : e.getDataEntities()) {
            data.set("enabledate", (Object)new Date());
            data.set("disabledate", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        TXHandle h = TX.beginNew();
        try {
            DynamicObject[] datas = e.getDataEntities();
            HashSet<Long> ids = new HashSet<Long>(datas.length);
            for (DynamicObject data : datas) {
                String longnuberStr = data.get("longnumber").toString() + ".%";
                DynamicObjectCollection allSubFfiDos = QueryServiceHelper.query((String)"cas_fundflowitem", (String)"id,number,longnumber", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)longnuberStr)});
                ids.add(data.getLong("id"));
                for (DynamicObject subItem : allSubFfiDos) {
                    ids.add(subItem.getLong("id"));
                }
            }
            if (ids != null && ids.size() > 0) {
                String sql = "update T_CAS_FundFlowItem set fenable = 1 where FID in " + StringUtils.setToString(ids);
                DB.execute((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[0]);
            }
        }
        finally {
            h.end();
        }
    }
}

