/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.errorcode.BillErrorCode;
import kd.fi.cas.helper.MutexLockerHelper;
import kd.fi.cas.opplugin.CommonOpServicePlugIn;

public abstract class LockSupportiveOp
extends CommonOpServicePlugIn {
    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    protected void processWithLock(DynamicObject ... datas) {
        String entityName = datas[0].getDataEntityType().getName();
        try (MutexLockerHelper mutexLockerHelper = new MutexLockerHelper(entityName, this.operateKey);){
            DynamicObject[] billsForCheck;
            List idList = Arrays.stream(datas).map(o -> o.getPkValue() == null ? "" : o.getPkValue().toString()).collect(Collectors.toList());
            Map batchRequire = mutexLockerHelper.batchRequire(idList);
            HashSet<Object> satisfiableBillPks = new HashSet<Object>();
            for (DynamicObject bill : billsForCheck = BusinessDataServiceHelper.load((String)entityName, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)})) {
                if (!this.isStatusValid(bill.getString("billstatus"))) continue;
                satisfiableBillPks.add(bill.getPkValue());
            }
            ArrayList<DynamicObject> validDatas = new ArrayList<DynamicObject>();
            BillErrorCode billErrorCode = new BillErrorCode();
            for (DynamicObject bill : datas) {
                if (!((Boolean)batchRequire.get(bill.getPkValue().toString())).booleanValue() || !satisfiableBillPks.contains(bill.getPkValue())) {
                    this.handleException((Exception)new KDBizException(billErrorCode.BILL_MUTEX_LOCK(), new Object[0]), bill);
                    continue;
                }
                validDatas.add(bill);
            }
            this.process(validDatas);
        }
    }

    protected abstract void process(Collection<DynamicObject> var1);

    protected abstract boolean isStatusValid(String var1);
}

