/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.ebservice.PayInfoFactory;
import kd.fi.cas.business.ebservice.log.PayLogger;
import kd.fi.cas.business.ebservice.log.builder.PayTraceLogPayBillBuilder;
import kd.fi.cas.business.ebservice.log.enums.PayLogLevelEnum;
import kd.fi.cas.business.ebservice.log.enums.PayTraceLogStepEmum;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.TmcBusinessBaseHelper;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PayentBillCommitBEValidator;
import kd.fi.cas.validator.PaymentBillIsFreezeValidator;

public class PaymentBillCommitBEOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PaymentBillCommitBEOp.class);
    private static PayLogger traceLogger = PayLogger.create(PaymentBillCommitBEOp.class);
    public Map<Long, Long> billIdsToBankBills = new LinkedHashMap<Long, Long>(16);
    public List<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("actpayamt");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("payeracctbank");
        fieldKeys.add("payerbank");
        fieldKeys.add("currency");
        fieldKeys.add("payeracctbank.issetbankinterface");
        fieldKeys.add("settletype");
        fieldKeys.add("ispaythroughbe");
        fieldKeys.add("isonlyread");
        fieldKeys.add("actpayamt");
        fieldKeys.add("payeename");
        fieldKeys.add("recaccbankname");
        fieldKeys.add("usage");
        fieldKeys.add("payeebanknum");
        fieldKeys.add("recprovince");
        fieldKeys.add("reccity");
        fieldKeys.add("reccountry");
        fieldKeys.add("org");
        fieldKeys.add("payeracctbank");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("bankpayingid");
        fieldKeys.add("iscommitbe");
        fieldKeys.add("bankpaystatus");
        fieldKeys.add("commitbetime");
        fieldKeys.add("entrustorg");
        fieldKeys.add("applyorg");
        fieldKeys.add("paymentchannel");
        fieldKeys.add("payeetype");
        fieldKeys.add("payee");
        fieldKeys.add("creator");
        fieldKeys.add("auditor");
        fieldKeys.add("isdiffcur");
        fieldKeys.add("dpcurrency");
        fieldKeys.add("dpexratetable");
        fieldKeys.add("dpexratedate");
        fieldKeys.add("dpamt");
        fieldKeys.add("dplocalamt");
        fieldKeys.add("dpexchangerate");
        fieldKeys.add("agreedrate");
        fieldKeys.add("lossamt");
        fieldKeys.add("feepayer");
        fieldKeys.add("feeactbank");
        fieldKeys.add("feecurrency");
        fieldKeys.add("fee");
        fieldKeys.add("iscrosspay");
        fieldKeys.add("crosstrantype");
        fieldKeys.add("contractno");
        fieldKeys.add("recemail");
        fieldKeys.add("recbankaddress");
        fieldKeys.add("recswiftcode");
        fieldKeys.add("recroutingnum");
        fieldKeys.add("recothercode");
        fieldKeys.add("instructmsg");
        fieldKeys.add("auditparam");
        fieldKeys.add("transtype");
        fieldKeys.add("paymethod");
        fieldKeys.add("serlevel");
        fieldKeys.add("payproxybank");
        fieldKeys.add("checktype");
        fieldKeys.add("sendway");
        fieldKeys.add("checkuse");
        fieldKeys.add("paycountry");
        fieldKeys.add("openorg");
        fieldKeys.add("entry");
        fieldKeys.add("e_actamt");
        fieldKeys.add("recaddress");
        fieldKeys.add("description");
        fieldKeys.add("urgentflag");
        fieldKeys.add("isrepulsed");
        fieldKeys.add("repulsedreason");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PayentBillCommitBEValidator());
        e.addValidator((AbstractValidator)new PaymentBillIsFreezeValidator());
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.COMMITTOBEVALIDATE));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<DynamicObject> successList;
        super.beginOperationTransaction(e);
        traceLogger.logBatch(new PayTraceLogPayBillBuilder(Arrays.asList(e.getDataEntities()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), "beginCreateBankBill", null, null).build());
        List<DynamicObject> canDoBillList = this.getBillCanDoAndFillProp(e.getDataEntities());
        LinkedHashMap<Long, Long> bankBillIdsToBillIds = new LinkedHashMap<Long, Long>(16);
        List bankBills = PayInfoFactory.transPayBillToBankPayBill(canDoBillList);
        Collections.reverse(bankBills);
        bankBills.forEach(o -> bankBillIdsToBillIds.put(o.getLong("id"), o.getLong("sourcebillid")));
        this.dealLog(canDoBillList, bankBills);
        OperationResult opResult = this.saveBankBill(bankBills);
        traceLogger.logBatch(new PayTraceLogPayBillBuilder(canDoBillList, PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), "saveBankBill", SerializationUtils.toJsonString((Object)opResult), null).build());
        List successIdList = opResult.getSuccessPkIds();
        bankBillIdsToBillIds.entrySet().stream().filter(o -> successIdList.contains(o.getKey())).forEach(o -> this.billIdsToBankBills.put((Long)o.getValue(), (Long)o.getKey()));
        this.dealMsg_SaveBankBill(opResult, bankBillIdsToBillIds);
        if (canDoBillList.size() > 0 && (successList = canDoBillList.stream().filter(o -> this.billIdsToBankBills.containsKey(o.getLong("id"))).collect(Collectors.toList())).size() > 0) {
            SaveServiceHelper.save((DynamicObject[])successList.toArray(new DynamicObject[0]));
            traceLogger.logBatch(new PayTraceLogPayBillBuilder(successList, PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), "updateBizBill", null, null).build());
        }
    }

    private void dealLog(List<DynamicObject> billList, List<DynamicObject> bankBillList) {
        PayTraceLogPayBillBuilder logBuilder = new PayTraceLogPayBillBuilder(billList.size());
        HashMap id_bankBill = new HashMap(bankBillList.size());
        bankBillList.forEach(o -> id_bankBill.put(o.getLong("sourcebillid"), o));
        billList.forEach(o -> logBuilder.addLog(o, SerializationUtils.toJsonString(id_bankBill.get(o.getLong("id"))), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), "createBankBill", null));
        traceLogger.logBatch(logBuilder.build());
    }

    private void dealMsg_SaveBankBill(OperationResult opResult, Map<Long, Long> bankBillIdsToBillIds) {
        for (OperateErrorInfo errorInfo : opResult.getAllErrorInfo()) {
            OperateErrorInfo temp = new OperateErrorInfo();
            Long billPk = bankBillIdsToBillIds.get(errorInfo.getPkValue());
            temp.setPkValue((Object)billPk);
            temp.setMessage((String)this.operationResult.getBillNos().get(billPk) + "\uff1a" + errorInfo.getMessage());
            temp.setLevel(ErrorLevel.FatalError);
            this.errorInfos.add(temp);
        }
        if (this.errorInfos.size() == 0 && this.operationResult.getMessage() == null && opResult.getMessage() != null) {
            this.operationResult.setMessage(this.extractResultErrorMessage(opResult));
            if (opResult.getSuccessPkIds().size() <= 0) {
                this.operationResult.setSuccess(false);
            }
        }
    }

    private String extractResultErrorMessage(OperationResult opResult) {
        List opInfoList = opResult.getAllErrorOrValidateInfo();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo info : opInfoList) {
            stringBuilder.append(info.getMessage());
        }
        if (StringUtils.isEmpty((String)stringBuilder.toString())) {
            stringBuilder.append(opResult.getMessage());
        }
        return stringBuilder.toString();
    }

    public List<DynamicObject> getBillCanDoAndFillProp(DynamicObject[] bills) {
        List<Long> billIds = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toList());
        AtomicInteger sort = new AtomicInteger();
        sort.set(billIds.size());
        HashMap sortMap = new HashMap(16);
        billIds.forEach(e -> sortMap.put(e, sort.getAndDecrement()));
        List<Long> canDoIds = this.beforeGeneratePayBill(billIds);
        bills = BusinessDataServiceHelper.load((Object[])canDoIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        ArrayList<DynamicObject> updateBills = new ArrayList(bills.length);
        for (DynamicObject payBill : bills) {
            payBill.set("isrepulsed", (Object)false);
            payBill.set("repulsedreason", (Object)"");
            payBill.set("iscommitbe", (Object)true);
            payBill.set("billstatus", (Object)BillStatusEnum.BEING.getValue());
            payBill.set("bankpaystatus", (Object)BeBillStatusEnum.OP.getValue());
            payBill.set("commitbetime", (Object)new Date());
            payBill.set("cashier", (Object)RequestContext.get().getCurrUserId());
            updateBills.add(payBill);
        }
        updateBills = updateBills.stream().sorted(Comparator.comparing(s -> (Integer)sortMap.get(s.getLong("id")))).collect(Collectors.toList());
        return updateBills;
    }

    public OperationResult saveBankBill(List<DynamicObject> bankBills) {
        OperationResult opResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("srcEntityNumber", "cas_paybill");
        try (TXHandle handle = TX.requiresNew();){
            try {
                opResult = OperationServiceHelper.executeOperate((String)"save", (String)"bei_bankpaybill", (DynamicObject[])bankBills.toArray(new DynamicObject[0]), (OperateOption)option);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
        return opResult;
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        if (this.billIdsToBankBills.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bei_bankpaybill"), (Object[])this.billIdsToBankBills.values().toArray(new Long[0]));
            }
            catch (Exception exception) {
                logger.error("commitbe rollback:delete bankbill fail");
                logger.error((Throwable)exception);
            }
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.errorInfos.size() > 0) {
            ValidateResult vr = new ValidateResult();
            vr.setAllErrorInfo(this.errorInfos);
            if (this.operationResult.getValidateResult() != null && this.operationResult.getValidateResult().getValidateErrors() != null) {
                this.operationResult.getValidateResult().getValidateErrors().add(vr);
            }
        }
        List successPair = this.billIdsToBankBills.entrySet().stream().map(o -> {
            JSONObject result = new JSONObject();
            result.put("payBillId", o.getKey());
            result.put("bankBillId", o.getValue());
            return result;
        }).collect(Collectors.toList());
        e.getOperationResult().setSuccessPkIds(successPair);
    }

    protected List<Long> beforeGeneratePayBill(List<Long> idList) {
        String sSQL = "Update t_cas_paymentbill Set Fmodifytime = ? Where Fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and fbillstatus = ?";
        DB.executeBatch((DBRoute)new DBRoute("cas"), (String)sSQL, Collections.singletonList(new Object[]{new Date(), BillStatusEnum.AUDIT.getValue()}));
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", idList)};
        DynamicObject[] bankpay = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus", (QFilter[])filter);
        ArrayList<Long> canDoIds = new ArrayList<Long>();
        for (DynamicObject info : bankpay) {
            if (info.getString("billstatus").equals(BillStatusEnum.AUDIT.getValue())) {
                canDoIds.add(info.getLong("id"));
                continue;
            }
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001\u7684\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PaymentBillCommitBEOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            errorInfo.setPkValue((Object)info.getLong("id"));
            errorInfo.setLevel(ErrorLevel.FatalError);
            this.errorInfos.add(errorInfo);
        }
        return canDoIds;
    }
}

