/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.ReceredWayHelper;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.validator.PaymentChargeBackValidator;

public class PaymentChargeBackWriteV2Op
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PaymentChargeBackWriteV2Op.class);
    private String operate = "op_chargebackwrite";
    private List<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(5);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("org");
        fieldKeys.add("billstatus");
        fieldKeys.add("entrustorg");
        fieldKeys.add("entrustamt");
        fieldKeys.add("matchflag");
        fieldKeys.add("settletype");
        fieldKeys.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        fieldKeys.add("settletnumber");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PaymentChargeBackValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String reason = this.getOption().getVariableValue("reason", "");
        DynamicObject[] dataEntities = e.getDataEntities();
        List paymentBillIdStrList = Arrays.stream(dataEntities).map(i -> String.valueOf(i.getPkValue())).collect(Collectors.toList());
        List paymentBillIdList = Arrays.stream(dataEntities).map(i -> i.getPkValue()).collect(Collectors.toList());
        String entityName = dataEntities[0].getDynamicObjectType().getName();
        DynamicObject[] dbData = BusinessDataServiceHelper.load((Object[])paymentBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        Map dbDataMap = Arrays.stream(dbData).collect(Collectors.toMap(i -> i.getPkValue(), Function.identity(), (k1, k2) -> k1));
        ArrayList<String> requestIds = new ArrayList<String>(dataEntities.length);
        Map request = MutexServiceHelper.batchRequest(paymentBillIdStrList, (String)entityName, (String)this.operate);
        try {
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                requestIds.add(key);
            }
            for (DynamicObject dataEntity : dataEntities) {
                Object pkValue = dataEntity.getPkValue();
                if (!requestIds.contains(pkValue.toString())) continue;
                try {
                    this.chargeBackWrite((DynamicObject)dbDataMap.get(dataEntity.getPkValue()), reason);
                }
                catch (Exception currE) {
                    logger.error("\u9000\u5355\u5f02\u5e38", (Throwable)currE);
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, dataEntity.getPkValue(), (Object)dataEntity.getDynamicObjectType().getName());
                    operateErrorInfo.setMessage(dataEntity.get("billno") + ":" + currE.getLocalizedMessage());
                    this.errorInfo.add(operateErrorInfo);
                }
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)this.operate);
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        for (OperateErrorInfo operateErrorInfo : this.errorInfo) {
            e.getOperationResult().addErrorInfo(operateErrorInfo);
        }
    }

    private void chargeBackWrite(DynamicObject paymentBillData, String reason) {
        reason = StringUtils.isEmpty((CharSequence)reason) && paymentBillData.getBoolean("iscommitbe") ? paymentBillData.getString("bankreturnmsg") : reason;
        paymentBillData.set("reason", (Object)reason);
        paymentBillData.set("backuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        paymentBillData.set("backdate", (Object)new Date());
        paymentBillData.set("matchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
        String billStatus = paymentBillData.getString("billstatus");
        OperateOption create = OperateOption.create();
        create.setVariableValue("ishasright", "true");
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            OperateServiceHelper.execOperate((String)"unsubmit", (String)paymentBillData.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{paymentBillData}, (OperateOption)create);
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            OperateServiceHelper.execOperate((String)"unaudit", (String)paymentBillData.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{paymentBillData}, (OperateOption)create);
        }
        paymentBillData.set("billstatus", (Object)BillStatusEnum.CHARGEBANK.getValue());
        OperateServiceHelper.execOperate((String)"chargebacksave", (String)paymentBillData.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{paymentBillData}, (OperateOption)create);
        this.doDelOp(paymentBillData);
        ReceredWayHelper.setReceredWayByBiz((DynamicObject)paymentBillData);
    }

    private void doDelOp(DynamicObject info) {
        String sourceBillType;
        if ("cas_paybill".equals(info.getDataEntityType().getName()) && !CasHelper.isEmpty((Object)(sourceBillType = info.getString("sourcebilltype")))) {
            OperateOption option = this.getOption();
            HashMap<String, String> paramMap = new HashMap<String, String>(4);
            if (option != null && option.containsVariable("isPayScheBack") && "true".equals(option.getVariableValue("isPayScheBack"))) {
                paramMap.put("isPayScheBack", option.getVariableValue("isPayScheBack"));
                paramMap.put("payScheOPType", option.getVariableValue("payScheOPType"));
                paramMap.put("payScheRelease", option.getVariableValue("payScheRelease"));
                paramMap.put("delPayApplyBillIds", option.getVariableValue("delPayApplyBillIds"));
            }
            if ("cas_payapplybill".equals(sourceBillType) || "cas_transferapply".equals(sourceBillType) || "fr_glreim_paybill".equals(sourceBillType)) {
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)info, (String)info.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.CHARGEBACK, PaymentDisposeConsumer.class, paramMap);
            } else {
                ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
                bills.add(info);
                WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.CHARGEBACK, PaymentDisposeConsumer.class);
            }
            if ("cdm_drafttradebill".equals(sourceBillType)) {
                HashSet<Long> draftTradeBillIdSet = new HashSet<Long>();
                Long draftTradeBillId = info.getLong("sourcebillid");
                draftTradeBillIdSet.add(draftTradeBillId);
                String dealbypsd = this.getOption().getVariableValue("dealbypsd", "");
                if (null != dealbypsd && "y".equals(dealbypsd)) {
                    PayBillHepler.callCancleDraw(draftTradeBillIdSet, (boolean)true);
                } else {
                    PayBillHepler.callCancleDraw(draftTradeBillIdSet, (boolean)false);
                }
            }
            this.updateEntrustSourcePayBill(info);
        }
    }

    private void updateEntrustSourcePayBill(DynamicObject targetBill) {
        long entrustSourceId;
        DynamicObject entrustSourceBill;
        if ("cas_paybill".equals(targetBill.getDataEntityType().getName()) && "cas_paybill".equals(targetBill.getString("sourcebilltype")) && targetBill.get("applyorg") != null && (entrustSourceBill = BusinessDataServiceHelper.loadSingle((Object)(entrustSourceId = targetBill.getLong("sourcebillid")), (String)"cas_paybill", (String)"id,reason,entrustamt")) != null) {
            String reason = targetBill.getString("reason");
            String reasonFmt = ResManager.loadKDString((String)"[%1$s]\u53d1\u751f\u9000\u5355\uff1a%2$s", (String)"PaymentChargeBackWriteOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            String newReason = String.format(reasonFmt, targetBill.getString("billno"), reason);
            entrustSourceBill.set("reason", (Object)StringUtils.substring((String)newReason, (int)0, (int)255));
            entrustSourceBill.set("entrustamt", (Object)BigDecimal.ZERO);
            SaveServiceHelper.update((DynamicObject)entrustSourceBill);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            if (!"cas_payapplybill".equals(info.getString("sourcebilltype")) && !"lc_arrival".equals(info.getString("sourcebilltype")) && !PayBillHepler.isLCSettlement((DynamicObject)info)) continue;
            PayBillHepler.payApplyBillWriteBackArrival((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.CHARGEBACK, PaymentDisposeConsumer.class);
        }
    }
}

