/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.PaymentIntegrateSaveValidator;

public class PaymentIntegrateSaveOp
extends AbstractOperationServicePlugIn {
    private static final String IGNORE_AR_AP_JOURNAL = "ignoreArApJournal";

    public void onAddValidators(AddValidatorsEventArgs e) {
        PaymentIntegrateSaveValidator paymentIntegrateSaveValidator = new PaymentIntegrateSaveValidator();
        paymentIntegrateSaveValidator.setEntityKey("cas_paybill");
        e.addValidator((AbstractValidator)paymentIntegrateSaveValidator);
        super.onAddValidators(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Object[] dataEntities = e.getDataEntities();
        Map variables = this.getOption().getVariables();
        boolean ignoreArApJournal = Boolean.parseBoolean(variables.getOrDefault(IGNORE_AR_AP_JOURNAL, "false"));
        if (EmptyUtil.isNoEmpty((Object[])dataEntities) && !ignoreArApJournal) {
            List payBillIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            Map payBillMap = Collections.singletonMap("cas_paybill", payBillIds);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"CasJournalGeneratorService", (String)"generateJournal", (Object[])new Object[]{payBillMap});
        }
    }
}

