/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.List;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.PaymentBillBookJournalBuilder;
import kd.fi.cas.business.opservice.factory.PaymentBillFactory;
import kd.fi.cas.opplugin.overdraft.PaymentPayValidator;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.validator.PaymentBillIsFreezeValidator;
import kd.fi.cas.validator.freeze.PaymentBillFreezeValidator;
import kd.fi.cas.validator.paymentbill.PaymentPayScheCommonValidator;

public class PaymentPayValidateOp
extends AbstractOperationServicePlugIn {
    protected ParamMap param = new ParamMap();
    protected String operateKey;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        List selectors = PaymentBillFactory.getPayService().getSelector();
        if (selectors != null) {
            lst.addAll(selectors);
        }
        lst.add("priority");
        lst.add("sourcebilltype");
        lst.add("iswaitsche");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.operateKey = ((AbstractValidator)e.getValidators().get(0)).getOperateKey();
        this.param.put("operateKey", (Object)this.operateKey);
        this.param.getParams().putAll(this.operateOption.getVariables());
        if (!"true".equals(this.param.get("byfca"))) {
            e.addValidator((AbstractValidator)new PaymentPayValidator());
            e.addValidator((AbstractValidator)new PaymentBillIsFreezeValidator());
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        try {
                            journalServiceAdapter.validateBook((IBookJournalBuilder)new PaymentBillBookJournalBuilder(), dataEntity.getDataEntity());
                        }
                        catch (Exception e) {
                            this.addErrorMessage(dataEntity, e.getMessage());
                        }
                    }
                }
            });
        }
        e.addValidator((AbstractValidator)new PaymentPayScheCommonValidator());
        e.getValidators().add(new PaymentBillFreezeValidator());
    }
}

