/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class PaymentSubmitByRobotOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        PaymentServiceHelper.addFieldKeys((List)e.getFieldKeys());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject payBill : dataEntities) {
            ids.add(payBill.getLong("id"));
            boolean isRemove = false;
            DynamicObjectCollection collection = payBill.getDynamicObjectCollection("entry");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DynamicObject object = (DynamicObject)iterator.next();
                if (!CasHelper.isEmpty((Object)object.get("e_payableamt"))) continue;
                iterator.remove();
                isRemove = true;
            }
            if (!isRemove) continue;
            updateBills.add(payBill);
        }
        if (updateBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
        }
        this.operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"cas_paybill", (Object[])ids.toArray(new Long[0]), (OperateOption)OperateOption.create());
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        OperationResult result = this.operationResult;
        List errorInfos = result.getAllErrorOrValidateInfo();
        ArrayList<OperateErrorInfo> allErrors = new ArrayList<OperateErrorInfo>(errorInfos.size());
        for (IOperateInfo operateInfo : errorInfos) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)operateInfo;
            allErrors.add(errorInfo);
        }
        IOperationResult returnResult = e.getOperationResult();
        returnResult.getAllErrorInfo().addAll(allErrors);
        returnResult.setMessage(result.getMessage());
        returnResult.setSuccessPkIds(result.getSuccessPkIds());
        returnResult.setShowMessage(result.isShowMessage());
    }
}

