/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.business.opservice.factory.PaymentBillFactory;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.validator.CommonOpValidator;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.paymentbill.PaymentLCOpenValidator;

public class PaymentUnAuditOp
extends AbstractOperationServicePlugIn {
    private IOpService iSerivce = PaymentBillFactory.getUnAuditService();
    private ParamMap param = new ParamMap();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.addAll(this.iSerivce.getSelector());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.param.getParams().putAll(this.operateOption.getVariables());
        this.iSerivce.prepare(e.getDataEntities(), this.param);
        e.getValidators().add(new CommonOpValidator(this.iSerivce, "cas_paybill", ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u53cd\u5ba1\u6838", (String)"PaymentUnAuditOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0])));
        e.addValidator((AbstractValidator)new PaymentLCOpenValidator());
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.UNAUDITVALIDATE));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String sql;
        int[] result;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List pks = Arrays.stream(dataEntities).map(d -> d.getString("id")).collect(Collectors.toList());
        if (!(CollectionUtils.isEmpty(pks) || (result = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)(sql = "update T_CAS_PaymentBill set fbillstatus = ? where fid in (" + String.join((CharSequence)",", pks) + ") and fbillstatus = ?"), Collections.singletonList(new Object[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.AUDIT.getValue()}))).length >= 1 && result[0] == pks.size())) {
            throw new KDBizException(new PaymentErrorCode().STATUS_CANNOT_UNAUDIT(), new Object[0]);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            this.iSerivce.process(info);
        }
    }
}

