/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.param.ClaimNoticeMesParam;

public class RecChargeBackWriteOp
extends AbstractOperationServicePlugIn {
    private String operate = "op_recchargebackwrite";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String billid = this.getOption().getVariableValue("billid");
        String reasonMsg = this.getOption().getVariableValue("reason");
        String reason = reasonMsg.trim();
        if (reason.length() > 255) {
            reason = reason.substring(0, 254);
        }
        String entityName = this.getOption().getVariableValue("entityname");
        MutexServiceHelper.batchRequest(Collections.singletonList(billid), (String)entityName, (String)this.operate);
        try {
            this.chargeBackWrite(billid, reason, entityName);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        finally {
            MutexServiceHelper.batchRelease(Collections.singletonList(billid), (String)entityName, (String)this.operate);
        }
    }

    public void chargeBackWrite(String billid, String reason, String entityName) {
        OperateOption create;
        if (CasHelper.isEmpty((Object)billid)) {
            return;
        }
        DynamicObject billMent = this.sourceBillSave(billid, entityName, reason);
        String billStatus = billMent.getString("billstatus");
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            create = OperateOption.create();
            create.setVariableValue("ishasright", "true");
            OperateServiceHelper.execOperate((String)"unsubmit", (String)billMent.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billMent}, (OperateOption)create);
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            create = OperateOption.create();
            create.setVariableValue("ishasright", "true");
            OperateServiceHelper.execOperate((String)"unaudit", (String)billMent.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billMent}, (OperateOption)create);
        }
        billMent = BusinessDataServiceHelper.loadSingle((Object)billMent.getPkValue(), (String)"cas_recbill");
        this.excuteCloneSave(billMent, entityName, reason);
        OperateOption option = OperateOption.create();
        option.setVariableValue("chargereason", reason);
        OperateServiceHelper.execOperate((String)"delete", (String)billMent.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billMent}, (OperateOption)option);
    }

    public DynamicObject sourceBillSave(String billid, String entityName, String reason) {
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)entityName);
        String sourcebillid = sourceBill.getString("sourcebillid");
        DynamicObject claimCenter = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cas_claimcenterbill");
        DynamicObject confirmUser = claimCenter.getDynamicObject("confirmuser");
        if (confirmUser != null) {
            ClaimNoticeMesParam param = new ClaimNoticeMesParam();
            HashSet<Long> userIds = new HashSet<Long>();
            param.setTag(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886", (String)"ClaimNoticeEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            String userName = RequestContext.get().getUserName();
            param.setTitle(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u88ab %s \u9000\u56de\uff0c\u8bf7\u5c3d\u5feb\u67e5\u770b\u548c\u5904\u7406", (String)"ClaimNoticeEditPlugin_5_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), userName));
            param.setContent(String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\uff1a%1$s\u88ab%2$s\u9000\u56de\uff0c\u9000\u56de\u539f\u56e0\uff1a%3$s\uff0c\u8bf7\u5c3d\u5feb\u67e5\u770b\u548c\u5904\u7406\u3002", (String)"ClaimNoticeEditPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), claimCenter.getString("billno"), userName, reason));
            userIds.add((Long)confirmUser.getPkValue());
            param.setUserIds(userIds);
            param.setPkId((Long)claimCenter.getPkValue());
            param.setNoticeType("chargeback");
            RecClaimHelper.sendNoticeMessage((ClaimNoticeMesParam)param);
            userIds.clear();
        }
        return sourceBill;
    }

    public void excuteCloneSave(DynamicObject bill, String entityName, String reason) {
        DynamicObject newPayMent = (DynamicObject)OrmUtils.clone((Object)bill, (IDataEntityType)bill.getDataEntityType(), (boolean)true, (boolean)true);
        String generateNumber = CodeRuleHelper.generateNumber((String)entityName, (DynamicObject)bill, null, null);
        if (StringUtils.isEmpty((CharSequence)generateNumber)) {
            generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        }
        newPayMent.set("billstatus", (Object)BillStatusEnum.CHARGEBANK.getValue());
        newPayMent.set("billno", (Object)generateNumber);
        newPayMent.set("reason", (Object)String.valueOf(reason));
        newPayMent.set("backuser", (Object)Long.parseLong(RequestContext.get().getUserId()));
        newPayMent.set("backdate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPayMent});
    }
}

