/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.business.opservice.factory.RecBillFactory;
import kd.fi.cas.business.opservice.helper.RecBillSupDivideHelper;
import kd.fi.cas.business.opservice.helper.RecSaleServiceHelper;
import kd.fi.cas.business.opservice.helper.ReceServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.business.pojo.RecParam;
import kd.fi.cas.business.refund.RefundService;
import kd.fi.cas.business.service.oplog.OpLogFactory;
import kd.fi.cas.business.service.oplog.recoplog.IRecBillOpLog;
import kd.fi.cas.business.writeback.RecWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.recchg.RecBillRecValidator;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ReceivRecOp
extends AbstractOperationServicePlugIn {
    protected IOpService service = RecBillFactory.getRecService();
    protected ParamMap param = new ParamMap();
    private static final Log logger = LogFactory.getLog(ReceivRecOp.class);
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private Set<String> succLockSet = new HashSet<String>();
    private DraftLockServiceHelper draftLockServiceHelper;
    private List<Long> batchRecIdList = new ArrayList<Long>(16);

    public ReceivRecOp() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.addAll(this.service.getSelector());
        lst.add("settletype");
        lst.add("billno");
        lst.add("sourcebilltype");
        lst.add("txt_description");
        lst.add("txt_description_tag");
        lst.add("cas_draftinfo");
        lst.add("transamount");
        lst.add("draftbillinfo");
        lst.add("draftbilllogid");
        lst.add("actrecamt");
        lst.add("recbillcurrency");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.param.getParams().putAll(this.operateOption.getVariables());
        this.service.prepare(e.getDataEntities(), this.param);
        e.getValidators().add(new RecBillRecValidator(this.journalServiceAdapter));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Map<String, String> mapOfIdAndbillno = Arrays.stream(e.getDataEntities()).filter(Objects::nonNull).collect(Collectors.toMap(item -> "rec" + item.getString("id"), item -> item.getString("billno")));
        Set<String> idSet = mapOfIdAndbillno.keySet();
        StringJoiner errorMsg = new StringJoiner(";");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        String billType = "reclockcas_recbill";
        try {
            logger.info("billno is:" + SerializationUtils.toJsonString(mapOfIdAndbillno.values()) + " and billType is: " + billType + " and id is:" + SerializationUtils.toJsonString(idSet));
            ArrayList<String> billids = new ArrayList<String>(idSet);
            Map lockResultMap = MutexServiceHelper.batchRequest(billids, (String)"cas_recbill", (String)billType);
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                for (String requestFailId : requestFailIds) {
                    String billno = mapOfIdAndbillno.get(requestFailId);
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), billno));
                }
            } else {
                this.succLockSet.addAll(requestIds);
            }
        }
        catch (Exception e1) {
            logger.error("to get lock Exception is:", (Throwable)e1);
            errorMsg.add(ResManager.loadKDString((String)"\u5355\u636e\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_33", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (errorMsg.length() > 0) {
            logger.info("is rec eror is:" + errorMsg.toString());
            throw new KDBizException(errorMsg.toString());
        }
    }

    public void initializeOperationResult(OperationResult result) {
        super.initializeOperationResult(result);
        logger.info("initializeOperationResult");
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        logger.info("onReturnOperation");
        if (CollectionUtils.isEmpty(this.succLockSet)) {
            logger.info("rec afterExecuteOperationTransaction stringList is null");
            return;
        }
        try {
            logger.info("release reclock\uff1a" + JSON.toJSONString(this.succLockSet));
            String billType = "reclockcas_recbill";
            ArrayList<String> listRelease = new ArrayList<String>(this.succLockSet);
            Map releaseResultMap = MutexServiceHelper.batchRelease(listRelease, (String)"cas_recbill", (String)billType);
            logger.info("releaseResultMap is:", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            logger.error("rec eror is:", (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u6b3e\u5931\u8d25\u3002", (String)"ReceivErrorCode_32", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        finally {
            this.succLockSet.clear();
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Set set;
        Object batchselect;
        logger.info("rec beginOperationTransaction");
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        List pkIds = ((Stream)Arrays.stream(infos).parallel()).map(d -> d.getLong("id")).collect(Collectors.toList());
        Object draftids = this.param.get("draftids");
        Object draftBillId = this.param.get("draftbillno");
        List draftIdList = null;
        if (draftids != null) {
            draftIdList = JSON.parseArray((String)draftids.toString(), Object.class);
        }
        if (EmptyUtil.isNoEmpty((Object)(batchselect = this.param.get("batchselect")))) {
            this.batchRecIdList = JSON.parseArray((String)batchselect.toString(), Long.class);
            if (EmptyUtil.isNoEmpty(this.batchRecIdList) && EmptyUtil.isNoEmpty(pkIds) && !pkIds.containsAll(this.batchRecIdList)) {
                String batchStr = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u6279\u91cf\u9009\u7968\u6536\u6b3e\u5931\u8d25\u3002", (String)"ReceivErrorCode_37", (String)"fi-cas-business", (Object[])new Object[0]);
                ValidateResultCollection validateResults = this.getOperationResult().getValidateResult();
                String errorMsg = DraftHelper.getValidateMsg((String)batchStr, (ValidateResultCollection)validateResults);
                throw new KDBizException(errorMsg);
            }
        }
        Long[] orgIds = (Long[])Arrays.stream(infos).map(d -> d.getDynamicObject("org").getLong("id")).distinct().toArray(Long[]::new);
        HashMap<Long, Boolean> orgAndCS089Map = new HashMap<Long, Boolean>(orgIds.length);
        for (Long l : orgIds) {
            boolean result = SystemParameterHelper.getParameterBoolean((long)l, (String)"cs089");
            orgAndCS089Map.put(l, result);
        }
        Long currentUserId = CasHelper.getCurrentUser();
        Map recdateMap = SystemParameterHelper.getSystemParamsByOrgIds(Arrays.asList(orgIds), (String)"selectrecdate");
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
        for (DynamicObject info : infos) {
            Date recDate;
            String recdateStr;
            DynamicObjectCollection draftbillEntrys = info.getDynamicObjectCollection("draftbill");
            if (draftIdList != null || draftBillId == null && draftbillEntrys != null && draftbillEntrys.size() > 0) {
                this.draftBillHandle(info, draftIdList);
            }
            info.set("cashier", (Object)currentUserId);
            String orgId = info.getDynamicObject("org").getString("id");
            Object value = recdateMap.get(orgId);
            switch (recdateStr = value == null ? "sysdate" : value.toString()) {
                case "bizdate": {
                    recDate = info.getDate("bizdate");
                    break;
                }
                case "auditdate": {
                    recDate = info.getDate("auditdate");
                    break;
                }
                default: {
                    recDate = new Date();
                }
            }
            info.set("payeedate", (Object)recDate);
            if (info.getBoolean("isagent")) {
                DynamicObject[] targetRecBills = CasBotpHelper.push((DynamicObject)info, (String)"cas_recbill");
                SaveServiceHelper.save((DynamicObject[])targetRecBills);
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        CasBotpHelper.saveRelation((DynamicObject[])targetRecBills);
                    }
                    catch (Exception exception) {
                        tx.markRollback();
                        logger.info("RecBillRecImpl \u4ee3\u7406\u6536\u6b3e\u5355\u751f\u6210\u6536\u6b3e\u5355 error" + ExceptionUtils.getStackTrace((Throwable)exception));
                    }
                }
            }
            try {
                RecBillSupDivideHelper.recBillRecOpDoDivideOp((DynamicObject)info);
            }
            catch (Exception error) {
                logger.error("ReceivRecOp OrgsDivideOp error : ", (Throwable)error);
            }
            logger.info("===\u751f\u6210\u5176\u4ed6\u5e94\u4ed8\u5355===");
            long currOrgId = (Long)info.getDynamicObject("org").getPkValue();
            if (((Boolean)orgAndCS089Map.get(currOrgId)).booleanValue()) {
                this.genOhterApBills(info, currOrgId);
            }
            if (CasHelper.isEmpty((Object)info.getString("sourcebilltype"))) continue;
            WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
            taskInfo.setBillId((Long)info.getPkValue());
            taskInfo.setDataEntity(info.getDataEntityType().getName());
            taskInfo.setSourceEntity(info.getString("sourcebilltype"));
            taskInfos.add(taskInfo);
        }
        if (!this.getOption().containsVariable("isHot") && EmptyUtil.isNoEmpty(set = Arrays.stream(infos).filter(s -> {
            boolean book = CasBankJournalHelper.bookByBizBillSettleType((DynamicObject)s);
            return book && EmptyUtil.isNoEmpty((BigDecimal)s.getBigDecimal("actrecamt"));
        }).map(d -> d.getLong("id")).collect(Collectors.toSet()))) {
            this.journalServiceAdapter.bookBatch(set);
        }
        ReceServiceHelper.genPayBillBatch((DynamicObject[])infos);
        for (DynamicObject info : infos) {
            info.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.RECEIVE, RecWriteBackConsumer.class);
    }

    private void genOhterApBills(DynamicObject info, Long currOrgId) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperateOption option = OperateOption.create();
                option.setVariableValue("app", "cas");
                DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
                boolean isPush = false;
                String orgId = info.getString("org.id");
                boolean isPartReceivable = this.isSettleType(info);
                Set settleOrgs = coll.stream().filter(s -> EmptyUtil.isNoEmpty((DynamicObject)s.getDynamicObject("e_settleorg"))).map(s -> s.getDynamicObject("e_settleorg")).collect(Collectors.toSet());
                for (DynamicObject settleOrg : settleOrgs) {
                    String settleName;
                    String settleId = settleOrg.getString("id");
                    logger.info(String.format("===\u7ed3\u7b97id\uff1a%s  \u7ec4\u7ec7id:%s===", settleId, orgId));
                    if (!isPartReceivable || !StringUtils.isNotEmpty((String)orgId) || orgId.equals(settleId) || RecBillHepler.matchByName((Long)currOrgId, (String)(settleName = settleOrg.getString("name"))) == null) continue;
                    isPush = true;
                    break;
                }
                if (isPush) {
                    logger.info("===\u751f\u6210\u5176\u4ed6\u5e94\u4ed8\u5355===");
                    OperationResult opResult = OperateServiceHelper.execOperateWithoutThrow((String)"genapbill", (String)"cas_recbill", (Object[])new Long[]{info.getLong("id")}, (OperateOption)option);
                    String result = OperateServiceHelper.decodeErrorMsg((OperationResult)opResult);
                    logger.info(result);
                }
            }
            catch (Exception exception) {
                tx.markRollback();
                logger.info("RecBillRecImpl genapbill error" + ExceptionUtils.getStackTrace((Throwable)exception));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject[] reInfos = (DynamicObject[])Arrays.stream(dataEntities).filter(dy -> !CasHelper.isEmpty((Object)dy) && (!CasHelper.isEmpty((Object)dy.getString("sourcebilltype")) && "er_dailyloanbill".equals(dy.getString("sourcebilltype")) || "er_repaymentbill".equals(dy.getString("sourcebilltype")) || dy.getDynamicObjectCollection("entry").stream().anyMatch(d -> "er_repaymentbill".equals(d.getString("e_corebilltype")) && !CasHelper.isEmpty((Object)d.getString("e_sourcebillentryid"))))).toArray(DynamicObject[]::new);
        Set accBankIdSet = Arrays.stream(dataEntities).filter(o -> CasHelper.isNotEmpty((Object)o.getDynamicObject("accountbank"))).map(o -> o.getDynamicObject("accountbank").getPkValue()).collect(Collectors.toSet());
        Set ifmAccIds = PayBillCrossHelper.getIfmAccIds(accBankIdSet);
        if (reInfos.length > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("dataEntities", reInfos);
            param.put("operate", operationKey);
            param.put("billType", "cas_recbill");
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"ICasBillWriteBackService", (String)"execute", (Object[])new Object[]{param});
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        ArrayList<DynamicObject> batchCheckBills = new ArrayList<DynamicObject>();
        for (final DynamicObject info : e.getDataEntities()) {
            DynamicObject[] recDraftBills;
            DynamicObject accountBank;
            if (ReceServiceHelper.isNeedWriteBack((DynamicObject)info)) {
                RecBillOverAmountHelper.getWriteBackVad((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.RECEIVE, (boolean)false);
            }
            if (BillStatusEnum.PAY.getValue().equals(info.getString("billstatus"))) {
                batchCheckBills.add(info);
            }
            if ((accountBank = info.getDynamicObject("accountbank")) == null || !ifmAccIds.contains(accountBank.getPkValue())) {
                try (TXHandle tx = TX.required();){
                    TX.addCommitListener((CommitListener)new CommitListener(){

                        public void onCommitted() {
                            try (TXHandle tx = TX.requiresNew();){
                                RecBillHepler.genIfmRecBill((DynamicObject)info);
                            }
                        }
                    });
                }
                catch (Exception error) {
                    logger.error("ReceivRecOp Push2IfmRecOp error : ", (Throwable)error);
                }
            }
            DynamicObject settleType = info.getDynamicObject("settletype");
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            if (!typeDraft) continue;
            DynamicObjectCollection draftDataColl = info.getDynamicObjectCollection("draftbill");
            List draftNoList = draftDataColl.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            for (DynamicObject recDraftBill : recDraftBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"rectype,rulename", (QFilter[])new QFilter[]{new QFilter("id", "in", draftNoList)})) {
                recDraftBill.set("rectype", (Object)(StringUtils.isEmpty((String)recDraftBill.getString("rectype")) ? "1" : recDraftBill.getString("rectype")));
            }
            SaveServiceHelper.save((DynamicObject[])recDraftBills);
        }
        VoucherCheckHepler.batchDoVoucherCheck(batchCheckBills);
        try {
            IRecBillOpLog settleOpImp = new OpLogFactory().getRecBillOpLogImpl("recOp");
            settleOpImp.doRecOpLog((Object)dataEntities);
        }
        catch (Exception error) {
            logger.error("ReceivRecOp IRecBillOpLog error : ", (Throwable)error);
        }
        OperateServiceHelper.execOperate((String)"synctrigger", (String)"cas_recbill", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
        this.autoRenote(dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        RecSaleServiceHelper.convertSaleAndContract((DynamicObject[])e.getDataEntities(), (boolean)true);
        List recIdList = Arrays.stream(e.getDataEntities()).map(o -> o.getLong("id")).collect(Collectors.toList());
        boolean selectDraft = Boolean.parseBoolean(this.operateOption.getVariables().getOrDefault("selectdraft", "false"));
        String isfromdraftbill = (String)this.operateOption.getVariables().get("isfromdraftbill");
        boolean isFromRecCall = false;
        if (EmptyUtil.isNoEmpty((String)isfromdraftbill) && "y".equalsIgnoreCase(isfromdraftbill)) {
            isFromRecCall = true;
        }
        logger.info("begin RecBillListener : " + recIdList);
        RecParam recParams = new RecParam();
        recParams.setIds(recIdList);
        recParams.setOperate("rec");
        ECGlobalSession.begin((String)"cas_batchwriteback", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"batchwrite");
        ECGlobalSession.setAsync((boolean)true);
        List recIdStrList = recIdList.stream().map(String::valueOf).collect(Collectors.toList());
        ECGlobalSession.setBusinessInfo(recIdStrList);
        ECGlobalSession.register((String)"fi", (String)"cas", (String)"BatchWriteRecTxService", (Param)recParams, (String)"ar_finarbill", (String)"");
        if (selectDraft) {
            this.lockSelectDraftAmount(e.getDataEntities());
        }
        ArrayList<DraftLockInfo> draftLockInfoList = new ArrayList<DraftLockInfo>(10);
        HashMap recIdAndDraftIdSet = new HashMap(8);
        for (DynamicObject recBillData : e.getDataEntities()) {
            DynamicObject settleType = recBillData.getDynamicObject("settletype");
            String sourcebilltype = recBillData.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String txt_description = recBillData.getString("txt_description");
            boolean isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"ReceivRecOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]).equals(txt_description);
            if (!typeDraft && !checkDraft || isFromcdm || isAlloc) {
                logger.info("is not draftType or is from cdm" + recBillData.getString("billno"));
                continue;
            }
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            DynamicObjectCollection draftDataColl = recBillData.getDynamicObjectCollection("draftbill");
            DynamicObjectCollection draftInfoEntrys = recBillData.getDynamicObjectCollection("cas_draftinfo");
            List draftNoList = draftDataColl.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            recIdAndDraftIdSet.put(recBillData.getLong("id"), new HashSet(draftNoList));
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"amount,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftNoList)});
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdTransAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            Map draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> draftAmountLockInfos = new ArrayList<DraftAmountLockSubInfo>(10);
            String datatypeStr = recBillData.getDataEntityType().getName();
            draftLockInfo.setSourceBillType(datatypeStr);
            draftLockInfo.setBizBillNo(recBillData.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(recBillData.getLong("id")));
            draftLockInfo.setOperateType(LogOperateTypeEnum.COMPLETE.getValue());
            draftLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
            long recBillId = recBillData.getLong("id");
            for (Long lockDraftId : draftNoList) {
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(lockDraftId);
                BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                BigDecimal tansAmount = draftIdTransAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTransAmountMap.get(lockDraftId);
                draftAmountLockInfo.setDealAmount(tansAmount);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockInfo.setBillLogId(draftLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.COMPLETE.getValue());
                draftAmountLockInfos.add(draftAmountLockInfo);
            }
            draftLockInfo.getLockSubInfoList().addAll(draftAmountLockInfos);
            if (!EmptyUtil.isNoEmpty(draftAmountLockInfos) || draftAmountLockInfos.size() <= 0) continue;
            draftLockInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(draftLockInfoList)) {
            logger.info("deal billlog start");
            this.draftLockServiceHelper.releaseOrLockDraft(draftLockInfoList);
            logger.info("deal billlog end");
        }
        if (!isFromRecCall && EmptyUtil.isNoEmpty(recIdAndDraftIdSet) && recIdAndDraftIdSet.size() > 0) {
            HashSet needUpdateDraftSetAll = new HashSet(8);
            String batchStr = DBServiceHelper.genStringId();
            for (DynamicObject recBill : e.getDataEntities()) {
                Set needUpdateDySet;
                long recBillId = recBill.getLong("id");
                Set draftBillSet = (Set)recIdAndDraftIdSet.get(recBillId);
                if (!EmptyUtil.isNoEmpty((Object)draftBillSet) || draftBillSet.size() <= 0) continue;
                String billType = "cdm_receivablebill";
                String draftBatchStr = "";
                boolean isBatchSelect = this.batchRecIdList.contains(recBillId);
                if (isBatchSelect) {
                    draftBatchStr = batchStr;
                }
                if (!EmptyUtil.isNoEmpty((Object)(needUpdateDySet = DraftHelper.updateDraftCasEntry((DynamicObject)recBill, (Set)draftBillSet, (String)billType, (String)"add", (String)draftBatchStr)))) continue;
                needUpdateDraftSetAll.addAll(needUpdateDySet);
            }
            if (EmptyUtil.isNoEmpty(needUpdateDraftSetAll)) {
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])needUpdateDraftSetAll.toArray(new DynamicObject[0]));
                }
                catch (Exception error) {
                    logger.error("update bill cas entry has error", (Throwable)error);
                }
            }
        }
    }

    private void lockSelectDraftAmount(DynamicObject[] recBills) {
        logger.info("lockSelectDraftAmount is start");
        ArrayList<LockResult> resultList = new ArrayList(8);
        ArrayList<DraftLockInfo> draftLockInfoList = new ArrayList<DraftLockInfo>(10);
        for (DynamicObject recBillData : recBills) {
            DynamicObject settleType = recBillData.getDynamicObject("settletype");
            String sourcebilltype = recBillData.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String txt_description = recBillData.getString("txt_description");
            boolean isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"ReceivRecOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]).equals(txt_description);
            if (!typeDraft && !checkDraft || isFromcdm || isAlloc) {
                logger.info("is not draftType or is from cdm" + recBillData.getString("billno"));
                continue;
            }
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            DynamicObjectCollection draftInfoEntrys = recBillData.getDynamicObjectCollection("cas_draftinfo");
            List draftNoList = draftInfoEntrys.stream().map(o -> o.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toList());
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"amount,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftNoList)});
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdTranAmountAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            Map draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> draftAmountLockInfos = new ArrayList<DraftAmountLockSubInfo>(10);
            String datatypeStr = recBillData.getDataEntityType().getName();
            draftLockInfo.setSourceBillType(datatypeStr);
            draftLockInfo.setBizBillNo(recBillData.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(recBillData.getLong("id")));
            draftLockInfo.setBillTrade(LogBizTypeEnum.RECEIVEBILL.getValue());
            draftLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
            long recBillId = recBillData.getLong("id");
            for (Long lockDraftId : draftNoList) {
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(lockDraftId);
                BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                BigDecimal bigDecimal = availableAmount = draftIdTranAmountAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMap.get(lockDraftId);
                if (this.batchRecIdList.contains(recBillId)) {
                    availableAmount = recBillData.getBigDecimal("actrecamt");
                }
                draftAmountLockInfo.setDealAmount(availableAmount);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockInfo.setBillLogId(draftLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.RECEIVEBILL.getValue());
                draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockInfos.add(draftAmountLockInfo);
            }
            draftLockInfo.getLockSubInfoList().addAll(draftAmountLockInfos);
            if (!EmptyUtil.isNoEmpty(draftAmountLockInfos) || draftAmountLockInfos.size() <= 0) continue;
            draftLockInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(draftLockInfoList)) {
            logger.info("lockSelectDraftAmount billlog start");
            resultList = this.draftLockServiceHelper.releaseOrLockDraft(draftLockInfoList);
            logger.info("lockSelectDraftAmount billlog end");
            if (EmptyUtil.isNoEmpty(resultList)) {
                for (DynamicObject data : recBills) {
                    this.updateEntryLogIds(resultList, data);
                }
                SaveServiceHelper.update((DynamicObject[])recBills);
            }
        }
        logger.info("lockSelectDraftAmount is end");
    }

    private void updateEntryLogIds(List<LockResult> lockResults, DynamicObject data) {
        Map<Long, LockResult> recIdAndDyMap;
        if (!EmptyUtil.isEmpty(lockResults) && EmptyUtil.isNoEmpty(recIdAndDyMap = lockResults.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getSourceBillId())).collect(Collectors.toMap(LockResult::getSourceBillId, x -> x)))) {
            long recBillId = data.getLong("id");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
            for (DynamicObject entry : entrys) {
                Long draftBillId = entry.getDynamicObject("draftbillinfo").getLong("id");
                LockResult lockResult = recIdAndDyMap.get(recBillId);
                if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                Map billIdLogIdMap = lockResult.getBillIdLogIdMap();
                boolean success = lockResult.isSuccess();
                Long billLogId = (Long)billIdLogIdMap.get(draftBillId);
                if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                entry.set("draftbilllogid", (Object)String.valueOf(billLogId));
            }
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        this.draftLockServiceHelper.rollback();
    }

    private void draftBillHandle(DynamicObject recBillData, List<Object> draftIdList) {
        if (draftIdList != null) {
            DynamicObject[] draftData = BusinessDataServiceHelper.load((Object[])draftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"));
            DynamicObjectCollection draftDataColl = MultiBaseDataHelper.generateMultiPropValue((DynamicObject)recBillData, (String)"draftbill", (DynamicObject[])draftData);
            recBillData.set("draftbill", (Object)draftDataColl);
            List<String> draftNoList = this.getDraftNoList(draftDataColl);
            if (draftNoList == null || draftNoList.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            draftNoList.forEach(o -> sb.append((String)o).append(";"));
            recBillData.set("settletnumber", (Object)sb.substring(0, sb.length() - 1));
            if (draftData.length == 0) {
                return;
            }
            DynamicObjectCollection draftInfoEntries = recBillData.getDynamicObjectCollection("cas_draftinfo");
            Set draftIdSet = draftInfoEntries.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getPkValue()).collect(Collectors.toSet());
            for (DynamicObject draftDatum : draftData) {
                if (draftIdSet.contains(draftDatum.getPkValue())) continue;
                DynamicObject cas_draftinfo = draftInfoEntries.addNew();
                if (this.batchRecIdList.contains(recBillData.getLong("id"))) {
                    cas_draftinfo.set("transamount", (Object)recBillData.getBigDecimal("actrecamt"));
                } else {
                    cas_draftinfo.set("transamount", (Object)draftDatum.getBigDecimal("amount"));
                }
                cas_draftinfo.set("recbillcurrency", (Object)draftDatum.getDynamicObject("currency"));
                cas_draftinfo.set("draftbillinfo", (Object)draftDatum);
            }
        }
        this.updateDraftBillNoRation(recBillData);
    }

    private void updateDraftBillNoRation(DynamicObject recBillData) {
        DynamicObjectCollection draftBillColl = recBillData.getDynamicObjectCollection("draftbill");
        List draftBillNoIds = draftBillColl.stream().filter(coll -> coll.get("fbasedataid") != null).map(coll -> coll.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        String sourcebilltype = recBillData.getString("sourcebilltype");
        try (TXHandle tx = TX.requiresNew();){
            if (draftBillNoIds.size() > 0 && !"cdm_receivablebill".equals(sourcebilltype) && !"cas_claimcenterbill".equals(sourcebilltype)) {
                CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (String)"cdm_receivablebill", (Long[])new Long[0], (Long)recBillData.getLong("id"));
                CasBotpHelper.saveRelation((DBRoute)DBRouteConst.TMC, (String)recBillData.getDataEntityType().getName(), (Long)recBillData.getLong("id"), (String)"cdm_receivablebill", draftBillNoIds);
            }
        }
    }

    private List<String> getDraftNoList(DynamicObjectCollection coll) {
        List<String> draftNoList = new ArrayList<String>(coll.size());
        if (coll.size() == 0) {
            return draftNoList;
        }
        draftNoList = coll.stream().map(o -> o.getDynamicObject("fbasedataid").getString("draftbillno")).collect(Collectors.toList());
        return draftNoList;
    }

    private boolean isSettleType(DynamicObject info) {
        DynamicObject receivingtype = info.getDynamicObject("receivingtype");
        receivingtype = BusinessDataServiceHelper.loadSingleFromCache((Object)receivingtype.getPkValue(), (String)"cas_receivingbilltype", (String)"ispartreceivable");
        return receivingtype.getBoolean("ispartreceivable");
    }

    private void autoRenote(DynamicObject[] recBills) {
        OperateOption operateOption = this.getOption();
        String fromAutoRenote = operateOption.getVariableValue("AUTO_RENOTE", "false");
        logger.info("auto renote from refundService = " + fromAutoRenote);
        if (Boolean.parseBoolean(fromAutoRenote)) {
            return;
        }
        for (DynamicObject recBill : recBills) {
            QFilter collBillFilter;
            long transDetailId = recBill.getLong("refunddetailid");
            if (EmptyUtil.isEmpty((Long)transDetailId)) {
                logger.info("recBill sure rec autorenote transDetailId is empty");
                continue;
            }
            long orgId = recBill.getDynamicObject("org").getLong("id");
            boolean bankAutoRefund = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"detail_auto_refund");
            if (!bankAutoRefund) {
                logger.info("recBill sure rec autorenote bankAutoRefund is closed");
                continue;
            }
            QFilter filter = new QFilter("id", "=", (Object)transDetailId);
            DynamicObject transDetail = QueryServiceHelper.queryOne((String)"bei_transdetail_cas", (String)"id,refundsource", (QFilter[])filter.toArray());
            if (transDetail == null || EmptyUtil.isBlank((CharSequence)transDetail.getString("refundsource"))) {
                logger.info("recBill sure rec autorenote refundsource is empty");
                continue;
            }
            DynamicObjectCollection entryList = recBill.getDynamicObjectCollection("entry");
            List<DynamicObject> corePayBillEntryList = entryList.stream().filter(recEntry -> {
                String coreBillType = recEntry.getString("e_corebilltype");
                String coreBillNo = recEntry.getString("e_corebillno");
                return "cas_paybill".equals(coreBillType) && StringUtils.isNotEmpty((String)coreBillNo);
            }).collect(Collectors.toList());
            List<DynamicObject> coreAgentEntryList = entryList.stream().filter(recEntry -> {
                String coreBillType = recEntry.getString("e_corebilltype");
                String coreBillNo = recEntry.getString("e_corebillno");
                return "cas_agentpaybill".equals(coreBillType) && StringUtils.isNotEmpty((String)coreBillNo);
            }).collect(Collectors.toList());
            boolean corePayBillEmpty = CollectionUtils.isEmpty(corePayBillEntryList);
            boolean coreAgentEmpty = CollectionUtils.isEmpty(coreAgentEntryList);
            if (corePayBillEmpty && coreAgentEmpty) {
                logger.info("auto renote core billType notfund ");
                continue;
            }
            if (!this.checkCoreBillRefund(corePayBillEntryList, coreAgentEntryList)) continue;
            if (!corePayBillEmpty) {
                Set payBillNos = corePayBillEntryList.stream().map(e -> e.getString("e_corebillno")).collect(Collectors.toSet());
                collBillFilter = new QFilter("billno", "in", payBillNos);
                DynamicObjectCollection payBillList = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])collBillFilter.toArray());
                for (DynamicObject payBill : payBillList) {
                    this.doRefundOp(recBill, "cas_paybill", payBill.getLong("id"), transDetailId, null);
                }
            }
            if (coreAgentEmpty) continue;
            Map<String, List<DynamicObject>> revEntryCoreAgent = coreAgentEntryList.stream().collect(Collectors.groupingBy(e -> e.getString("e_corebillno")));
            collBillFilter = new QFilter("billno", "in", revEntryCoreAgent.keySet());
            DynamicObjectCollection agentBills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,billno", (QFilter[])collBillFilter.toArray());
            Map<String, Long> billNo2Id = agentBills.stream().collect(Collectors.toMap(a -> a.getString("billno"), a -> a.getLong("id")));
            for (Map.Entry<String, List<DynamicObject>> revEntry : revEntryCoreAgent.entrySet()) {
                Set<Long> agentEntryIds = revEntry.getValue().stream().map(re -> re.getLong("e_corebillentryid")).collect(Collectors.toSet());
                this.doRefundOp(recBill, "cas_agentpaybill", billNo2Id.get(revEntry.getKey()), transDetailId, agentEntryIds);
            }
        }
    }

    private void doRefundOp(DynamicObject recBill, String billType, long coreBillId, long transDetailId, Set<Long> agentEntryIds) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("operateKey", "renote");
        option.setVariableValue("billType", billType);
        option.setVariableValue("billId", String.valueOf(coreBillId));
        if (!CollectionUtils.isEmpty(agentEntryIds)) {
            option.setVariableValue("entryIds", JSONObject.toJSONString(agentEntryIds));
        }
        try {
            logger.info("sure rec start auto renote op ...");
            OperateServiceHelper.execOperate((String)"refund_backstage", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{recBill}, (OperateOption)option);
            logger.info("sure rec start auto renote success");
            RefundService.updateRefundDetailId((String)billType, (Long)coreBillId, (Long)transDetailId, agentEntryIds);
        }
        catch (Exception ex) {
            logger.error("recBill sure rec refund_backstage error", (Throwable)ex);
        }
    }

    private boolean checkCoreBillRefund(List<DynamicObject> corePayBillEntryList, List<DynamicObject> coreAgentEntryList) {
        QFilter collBillFilter;
        if (!CollectionUtils.isEmpty(corePayBillEntryList)) {
            Map<String, List<DynamicObject>> entrysByCoreBillNo = corePayBillEntryList.stream().collect(Collectors.groupingBy(e -> e.getString("e_corebillno")));
            collBillFilter = new QFilter("billno", "in", entrysByCoreBillNo.keySet());
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno,billstatus,isdiffcur,dpamt,totalremainrefundamt", (QFilter[])collBillFilter.toArray());
            Map<String, DynamicObject> payBillMap = payBills.stream().collect(Collectors.toMap(p -> p.getString("billno"), p -> p));
            for (Map.Entry<String, List<DynamicObject>> coreBillEntry : entrysByCoreBillNo.entrySet()) {
                DynamicObject payBill = payBillMap.get(coreBillEntry.getKey());
                if (!BillStatusEnum.PAY.getValue().equals(payBill.getString("billstatus"))) {
                    return false;
                }
                if (payBill.getBigDecimal("totalremainrefundamt").compareTo(BigDecimal.ZERO) == 0) {
                    return false;
                }
                boolean differCurrencyPay = payBill.getBoolean("isdiffcur");
                BigDecimal rceivableAmt = coreBillEntry.getValue().stream().map(c -> c.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (differCurrencyPay && rceivableAmt.compareTo(payBill.getBigDecimal("dpamt")) != 0) {
                    logger.info("auto renote paybill dpamt not equals rceivableAmt, " + coreBillEntry.getKey());
                    return false;
                }
                if (differCurrencyPay || rceivableAmt.compareTo(payBill.getBigDecimal("totalremainrefundamt")) <= 0) continue;
                return false;
            }
        }
        if (!CollectionUtils.isEmpty(coreAgentEntryList)) {
            Set entryIds = coreAgentEntryList.stream().map(a -> a.getLong("e_corebillentryid")).collect(Collectors.toSet());
            collBillFilter = new QFilter("entry.id", "in", entryIds);
            DynamicObjectCollection agentEntryList = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,isdiffcur,isencryption,entry.id,entry.e_issuccess,entry.e_refundamt,entry.e_amount,entry.e_encryptamount,entry.e_remainrefundamt", (QFilter[])collBillFilter.toArray());
            Map<Long, DynamicObject> agentEntryMap = agentEntryList.stream().collect(Collectors.toMap(a -> a.getLong("entry.id"), a -> a));
            for (DynamicObject revEntry : coreAgentEntryList) {
                String agentBillNo = revEntry.getString("e_corebillno");
                long agentEntryId = revEntry.getLong("e_corebillentryid");
                DynamicObject agentEntry = agentEntryMap.get(revEntry.getLong("e_corebillentryid"));
                if (agentEntry == null) {
                    logger.info("auto renote agentBill entry is notfound: " + agentBillNo + "," + agentEntryId);
                    return false;
                }
                if (agentEntry.getBigDecimal("entry.e_remainrefundamt").compareTo(BigDecimal.ZERO) == 0) {
                    return false;
                }
                if (agentEntry.getBoolean("isdiffcur")) {
                    return false;
                }
                if (!agentEntry.getBoolean("entry.e_issuccess")) {
                    return false;
                }
                if (agentEntry.getBigDecimal("entry.e_refundamt").compareTo(BigDecimal.ZERO) != 0) {
                    return false;
                }
                BigDecimal agentEntryAmt = agentEntry.getBigDecimal("entry.e_amount");
                if (agentEntry.getBoolean("isencryption")) {
                    agentEntryAmt = AgentPayBillHelper.decodeAmount((String)agentEntry.getString("entry.e_encryptamount"));
                }
                if (agentEntryAmt.compareTo(revEntry.getBigDecimal("e_receivableamt")) == 0) continue;
                logger.info("auto renote agentBill e_amount not equals erceivableamt: " + agentBillNo + "," + agentEntryId);
                return false;
            }
        }
        return true;
    }
}

