/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.helper.RecClaimBillHelper;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.business.writeback.RecWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.ReceivingBillModel;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.RecBillDeleteValidator;
import kd.fi.cas.validator.common.TxLockValidator;

public class ReceivingDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ReceivingDeleteOp.class);
    private DraftLockServiceHelper draftLockServiceHelper;
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private DynamicObject[] hotRecBills;

    public ReceivingDeleteOp() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("draftbill");
        lst.add("isunclaim");
        lst.add("hotaccount");
        lst.add("receivingtype");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("settletype");
        lst.add("sourcebilltype");
        lst.add("txt_description");
        lst.add("txt_description_tag");
        lst.add("billno");
        lst.add("cas_draftinfo");
        lst.add("cas_draftinfo.transamount");
        lst.add("cas_draftinfo.draftbilllogid");
        lst.add("cas_draftinfo.draftbillinfo");
        lst.add("draftbillinfo");
        lst.add("draftbilllogid");
        lst.add("transamount");
        lst.add("refunddetailid");
        lst.add("billstatus");
        lst.add("sourcetype");
        lst.add("actrecamt");
        lst.add("isvoucher");
        lst.add("org");
        lst.add("e_receivableamt");
        lst.add("e_actAmt");
        lst.add("e_sourcebillid");
        lst.add("e_sourcebillentryid");
        lst.add("matchflag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new RecBillDeleteValidator());
        e.getValidators().add(new TxLockValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.process_RecBillDeleteImpl(e);
        DynamicObject[] recBills = e.getDataEntities();
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
        for (DynamicObject recBill : recBills) {
            String sourceBillType = recBill.getString("sourcebilltype");
            if (ReceivingBillModel.NOT_WRITE_BACK_BILLS.contains(sourceBillType)) continue;
            WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
            taskInfo.setBillId((Long)recBill.getPkValue());
            taskInfo.setDataEntity(recBill.getDataEntityType().getName());
            taskInfo.setSourceEntity(recBill.getString("sourcebilltype"));
            taskInfos.add(taskInfo);
        }
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.DELETE, RecWriteBackConsumer.class);
        this.dealChangeHotRecBill(recBills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] recBills = e.getDataEntities();
        if (recBills == null || recBills.length <= 0) {
            return;
        }
        List<DynamicObject> recBillsList = Arrays.asList(recBills);
        recBillsList = new ArrayList<DynamicObject>(recBillsList);
        List collectRecBillId = Stream.of(recBills).filter(recBill -> StringUtils.isEmpty((CharSequence)recBill.getString("hotaccount")) && "cas_claimcenterbill".equals(recBill.getString("sourcebilltype"))).map(recBill -> recBill.getLong("sourcebillid")).collect(Collectors.toList());
        if (collectRecBillId != null && collectRecBillId.size() > 0) {
            DynamicObject[] claimBills;
            DynamicObject[] hotedRecbills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,draftbill,isunclaim,hotaccount,receivingtype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", collectRecBillId), new QFilter("hotaccount", "=", (Object)HotAccountEnum.HOTEDBILL.getValue())});
            List HotedBills = Stream.of(hotedRecbills).map(hotedBill -> hotedBill.getLong("id")).collect(Collectors.toList());
            DynamicObject[] HotRecBill = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billstatus,draftbill,isunclaim,hotaccount,receivingtype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", HotedBills)});
            List deleteHotBills = Stream.of(HotRecBill).map(deleteHotBill -> deleteHotBill.getLong("id")).collect(Collectors.toList());
            for (DynamicObject dyobj : hotedRecbills) {
                dyobj.set("hotaccount", (Object)" ");
            }
            SaveServiceHelper.save((DynamicObject[])hotedRecbills);
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"deletenotvalidate", (String)"cas_recbill", (Object[])deleteHotBills.toArray(), (OperateOption)OperateOption.create());
            for (DynamicObject info : claimBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno,entryentity,claimstatus,handlestatus,confirmuser,isunclaim,e_handlestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", collectRecBillId)})) {
                Object[] recBills1 = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billstatus,sourcebilltype,sourcebillid,hotaccount,isunclaim", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", info.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue())});
                boolean isAllunclaim = true;
                if (recBills1 != null) {
                    Object[] objectArray = recBills1;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object recBill2 = objectArray[i];
                        if (!recBill2.getBoolean("isunclaim") || !HotAccountEnum.HOTEDBILL.getValue().equals(recBill2.getString("hotaccount"))) {
                            isAllunclaim = false;
                            break;
                        }
                        isAllunclaim = true;
                    }
                }
                if (!isAllunclaim) continue;
                if (EmptyUtil.isEmpty((Object[])recBills1) && info.getBoolean("isunclaim")) {
                    info.set("claimstatus", (Object)ClaimStatusEnum.WAIT.getValue());
                } else {
                    info.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                }
                String oldclaimstatus = info.getString("claimstatus");
                if (ClaimStatusEnum.WAIT.getValue().equals(oldclaimstatus) || ClaimStatusEnum.PART.getValue().equals(oldclaimstatus) || ClaimStatusEnum.CLAIMED.getValue().equals(oldclaimstatus)) {
                    info.set("isunclaim", (Object)"0");
                }
                info.set("confirmuser", null);
                DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
                entrys.forEach(entry -> entry.set("e_handlestatus", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
                QFilter qFilter = new QFilter("claimno", "=", (Object)info.getString("billno"));
                Object[] colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimstatus,handlestatus", (QFilter[])new QFilter[]{qFilter});
                if (!EmptyUtil.isNoEmpty((Object[])colls)) continue;
                for (Object coll : colls) {
                    if (EmptyUtil.isEmpty((Object[])recBills1) && info.getBoolean("isunclaim")) {
                        coll.set("claimstatus", (Object)ClaimStatusEnum.WAIT.getValue());
                    } else {
                        coll.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                    }
                    coll.set("handlestatus", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])colls);
            }
            for (DynamicObject dyObj : HotRecBill) {
                recBillsList.add(dyObj);
            }
        }
        for (DynamicObject recBill3 : recBillsList) {
            if (HotAccountEnum.HOTBILL.getValue().equals(recBill3.getString("hotaccount")) && null != recBill3.getString("sourcebillid")) {
                DynamicObject[] souRecBill = BusinessDataServiceHelper.load((Object[])new Object[]{recBill3.getString("sourcebillid")}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_recbill"));
                if (!CasHelper.isEmpty((DynamicObject[])souRecBill)) {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"RecBillListener", (String)"cancelRec", (Object[])new Object[]{Collections.singletonList(souRecBill[0].getPkValue())});
                }
                RecBillOverAmountHelper.getWriteBackVad((DynamicObject)souRecBill[0], (WriteBackOperateEnum)WriteBackOperateEnum.RECEIVE, (boolean)false);
            }
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    DynamicObject settleType = recBill3.getDynamicObject("settletype");
                    boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
                    boolean isSettleTypeProm = BaseDataHelper.isSettleTypeProm((DynamicObject)settleType);
                    boolean isSettleTypeCheck = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
                    logger.info("ReceivingDeleteOp.afterExecuteOperationTransaction typeDraft = {},isSettleTypeProm = {},isSettleTypeCheck = {}", new Object[]{typeDraft, isSettleTypeProm, isSettleTypeCheck});
                    if (!typeDraft && !isSettleTypeProm && !isSettleTypeCheck) continue;
                    DynamicObjectCollection draftDataColl = recBill3.getDynamicObjectCollection("draftbill");
                    List draftNoList = draftDataColl.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    DynamicObject[] recDraftBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"rectype,rulename", (QFilter[])new QFilter[]{new QFilter("id", "in", draftNoList)});
                    logger.info("ReceivingDeleteOp.afterExecuteOperationTransaction draftDataColl.size = {},draftNoList.size = {},recDraftBills.length = {}", new Object[]{draftDataColl.size(), draftNoList.size(), recDraftBills.length});
                    for (DynamicObject recDraftBill : recDraftBills) {
                        String rectype = recDraftBill.getString("rectype");
                        if ("6".equals(rectype)) continue;
                        recDraftBill.set("rectype", (Object)"");
                        recDraftBill.set("rulename", (Object)"");
                    }
                    SaveServiceHelper.save((DynamicObject[])recDraftBills);
                }
                catch (Exception exception) {
                    tx.markRollback();
                    logger.error("ReceivingDeleteOp.afterExecuteOperationTransaction has Exception:", (Object)e);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])this.hotRecBills)) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"RecBillListener", (String)"cancelRec", (Object[])new Object[]{Collections.singletonList(this.hotRecBills[0].getLong("id"))});
        }
    }

    private void dealChangeHotRecBill(DynamicObject[] recBills) {
        List collectRecBillId = Stream.of(recBills).filter(recBill -> StringUtils.isEmpty((CharSequence)recBill.getString("hotaccount"))).map(recBill -> recBill.getLong("sourcebillid")).collect(Collectors.toList());
        this.hotRecBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,hotaccount,receivingtype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", collectRecBillId), new QFilter("hotaccount", "=", (Object)HotAccountEnum.HOTBILL.getValue())});
        if (CasHelper.isEmpty((DynamicObject[])this.hotRecBills)) {
            return;
        }
        this.deleteRedPunchVouchers(this.hotRecBills);
        List HotedBills = Stream.of(this.hotRecBills).map(hotedBill -> hotedBill.getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObject[] hotedRecBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billstatus,hotaccount,receivingtype,sourcebillid,entry,entry.e_corebilltype,entry.e_corebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", HotedBills), new QFilter("hotaccount", "=", (Object)HotAccountEnum.HOTEDBILL.getValue())});
        List deleteHotBills = Stream.of(this.hotRecBills).map(deleteHotBill -> deleteHotBill.getLong("id")).collect(Collectors.toList());
        for (DynamicObject hotedBill2 : hotedRecBills) {
            DynamicObject[] changeBills;
            for (DynamicObject changeBill : changeBills = BusinessDataServiceHelper.load((String)"cas_recbill_change", (String)"id,billstatus,hotaccount,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)hotedBill2.getLong("id")), new QFilter("hotaccount", "=", (Object)HotAccountEnum.HOTBILL.getValue())})) {
                changeBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                changeBill.set("hotaccount", (Object)" ");
            }
            SaveServiceHelper.save((DynamicObject[])changeBills);
            RecBillOverAmountHelper.getWriteBackVad((DynamicObject)hotedBill2, (WriteBackOperateEnum)WriteBackOperateEnum.RECEIVE, (boolean)false);
            hotedBill2.set("hotaccount", (Object)" ");
            hotedBill2.set("billstatus", (Object)"E");
        }
        SaveServiceHelper.save((DynamicObject[])hotedRecBills);
        for (DynamicObject hotRecBill : this.hotRecBills) {
            this.journalServiceAdapter.validateCancelBook(hotRecBill);
            this.journalServiceAdapter.cancelBook(hotRecBill);
        }
        OperationServiceHelper.executeOperate((String)"deletenotvalidate", (String)"cas_recbill", (Object[])deleteHotBills.toArray(), (OperateOption)OperateOption.create());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] recBills;
        super.endOperationTransaction(e);
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(10);
        for (DynamicObject recBill : recBills = e.getDataEntities()) {
            DynamicObject settleType = recBill.getDynamicObject("settletype");
            String sourcebilltype = recBill.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String txt_description = recBill.getString("txt_description");
            boolean isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"ReceivRecOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]).equals(txt_description);
            if (!typeDraft && !checkDraft || isFromcdm || isAlloc) {
                logger.info("is not draftType or is from cdm" + recBill.getString("billno"));
                continue;
            }
            DynamicObjectCollection draftbillColl = recBill.getDynamicObjectCollection("draftbill");
            DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
            if (draftbillColl.size() <= 0) continue;
            List draftBillIds = draftbillColl.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"amount,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
            HashMap draftIdTranAmountAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            Map draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
            draftLockInfo.setSourceBillType(recBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(recBill.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(recBill.getLong("id")));
            ArrayList<DraftAmountLockSubInfo> subInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : draftBillIds) {
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(lockDraftId);
                BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                BigDecimal transAmount = draftIdTranAmountAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMap.get(lockDraftId);
                draftAmountLockInfo.setDealAmount(transAmount);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockInfo.setBillLogId(draftLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                subInfoList.add(draftAmountLockInfo);
            }
            if (!EmptyUtil.isNoEmpty(subInfoList)) continue;
            draftLockInfo.setLockSubInfoList(subInfoList);
            lockInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(lockInfoList)) {
            logger.info("ReceivingDeleteOp updateBillsByLog is start," + JSON.toJSONString(lockInfoList));
            this.draftLockServiceHelper.releaseOrLockDraft(lockInfoList);
            logger.info("ReceivingDeleteOp updateBillsByLog is end");
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        this.draftLockServiceHelper.rollback();
    }

    private void process_RecBillDeleteImpl(BeginOperationTransactionArgs e) throws KDException {
        DynamicObject[] recBills = e.getDataEntities();
        Map param = this.operateOption.getVariables();
        List orgIds = Arrays.stream(recBills).map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        Map orgParams = SystemParameterHelper.getSystemParamsByOrgIds(orgIds, (String)"cs114");
        Map<Long, Boolean> claimbills = this.getClaimcenterbills(e.getDataEntities());
        ArrayList<Object> ar_Listens = new ArrayList<Object>(16);
        ArrayList<DynamicObject> writeBackObjs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(16);
        for (DynamicObject info : recBills) {
            Object ignoreValidator;
            int cs;
            Long orgid = info.getDynamicObject("org").getLong("id");
            String sourceBillType = info.getString("sourcebilltype");
            String hotAccount = info.getString("hotaccount");
            int n = cs = orgParams.get(orgid + "") == null ? 0 : Integer.parseInt(orgParams.get(orgid + "").toString());
            if (cs == 2 && HotAccountEnum.HOTBILL.getValue().equals(hotAccount)) {
                RecBillHepler.checkJournal((DynamicObject)info);
                return;
            }
            Boolean flag = true;
            if ("cas_claimcenterbill".equals(sourceBillType)) {
                Boolean claimBol = claimbills.get(info.getLong("sourcebillid"));
                if (claimBol != null && claimBol.booleanValue()) {
                    QFilter hotaccountQf = new QFilter("hotaccount", "=", (Object)"1");
                    QFilter actrecamtQf = new QFilter("actrecamt", "<", (Object)BigDecimal.ZERO);
                    QFilter largeQf = new QFilter("actrecamt", ">", (Object)BigDecimal.ZERO);
                    QFilter sourcebillidQf = new QFilter("sourcebillid", "=", info.get("sourcebillid"));
                    DynamicObject[] hotrecBill = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id", (QFilter[])new QFilter[]{hotaccountQf, actrecamtQf, sourcebillidQf});
                    if (hotrecBill.length == 1) {
                        DynamicObject hotBill = BusinessDataServiceHelper.loadSingle((Object)hotrecBill[0].getPkValue(), (String)"cas_recbill");
                        if (RecBillHepler.isNeedBook((DynamicObject)hotBill)) {
                            this.journalServiceAdapter.validateCancelBook(hotBill);
                            this.journalServiceAdapter.cancelBook(hotBill);
                        }
                        OperateServiceHelper.execOperate((String)"deletenotvalidate", (String)"cas_recbill", (Object[])new Object[]{hotBill.getPkValue()}, (OperateOption)OperateOption.create());
                        RecClaimBillHelper.claimCancelAccount((String[])new String[]{info.getString("sourcebillid")}, (String)sourceBillType, (String[])new String[0]);
                        flag = false;
                        hotrecBill = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,settletype,hotaccount,receivingtype", (QFilter[])new QFilter[]{hotaccountQf, largeQf, sourcebillidQf});
                        if (hotrecBill.length == 1) {
                            hotBill = BusinessDataServiceHelper.loadSingle((Object)hotrecBill[0].getPkValue(), (String)"cas_recbill");
                            hotBill.set("hotaccount", (Object)"0");
                            ar_Listens.add(hotBill.getPkValue());
                            saveObjs.add(hotBill);
                        }
                    }
                } else {
                    Object reason = param.get("chargereason");
                    if (CasHelper.isNotEmpty(reason)) {
                        RecClaimBillHelper.claimCancelAccount((String[])new String[]{info.getString("sourcebillid")}, (String)sourceBillType, (String[])new String[]{String.valueOf(reason)});
                    } else {
                        RecClaimBillHelper.claimCancelAccount((String[])new String[]{info.getString("sourcebillid")}, (String)sourceBillType, (String[])new String[0]);
                    }
                }
            } else if ("cdm_drafttradebill".equals(sourceBillType) && (null == (ignoreValidator = param.get("cdm_drafttradebill_ignore")) || !"1".equals(ignoreValidator))) {
                Long draftTradeBillId = info.getLong("sourcebillid");
                HashSet<Long> draftTradeBillIdSet = new HashSet<Long>();
                draftTradeBillIdSet.add(draftTradeBillId);
                PayBillHepler.callCancleDraw(draftTradeBillIdSet, (boolean)false);
            }
            this.save(ar_Listens, saveObjs);
            if (!flag.booleanValue()) continue;
            writeBackObjs.add(info);
        }
        RecClaimBillHelper.writeBackByClaimBatch((DynamicObject[])writeBackObjs.toArray(new DynamicObject[0]), (Boolean)false);
    }

    private void save(List<Object> ar_Listens, List<DynamicObject> saveObjs) {
        if (ar_Listens.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"RecBillListener", (String)"rec", (Object[])ar_Listens.toArray(new Object[0]));
        }
        if (saveObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
        }
    }

    private Map<Long, Boolean> getClaimcenterbills(DynamicObject[] recBills) {
        Set srcBillIds = Arrays.stream(recBills).map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id,isunclaim", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
        return bills.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getBoolean("isunclaim")));
    }

    private void deleteRedPunchVouchers(DynamicObject[] redPunchBills) {
        Set redPunchBillIds = Arrays.stream(redPunchBills).map(redPunchBill -> redPunchBill.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(redPunchBillIds)) {
            return;
        }
        QFilter redPunchVoucherFilter = new QFilter("sourcebillid", "in", redPunchBillIds).and("billtype.number", "=", (Object)"cas_recbill");
        DynamicObjectCollection redPunchVouchers = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])redPunchVoucherFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)redPunchVouchers)) {
            Set redPunchVoucherIds = redPunchVouchers.stream().map(redPunchVoucher -> redPunchVoucher.getLong("voucherid")).collect(Collectors.toSet());
            OperateServiceHelper.execOperate((String)"delete", (String)"gl_voucher", (Object[])redPunchVoucherIds.toArray(), (OperateOption)OperateOption.create());
        }
    }
}

