/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingDeleteWithoutValOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ReceivingDeleteWithoutValOp.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("draftbill");
        lst.add("isunclaim");
        lst.add("hotaccount");
        lst.add("receivingtype");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("settletype");
        lst.add("sourcebilltype");
        lst.add("txt_description");
        lst.add("txt_description_tag");
        lst.add("billno");
        lst.add("cas_draftinfo");
        lst.add("cas_draftinfo.transamount");
        lst.add("cas_draftinfo.draftbilllogid");
        lst.add("cas_draftinfo.draftbillinfo");
        lst.add("draftbillinfo");
        lst.add("draftbilllogid");
        lst.add("transamount");
        lst.add("refunddetailid");
        lst.add("billstatus");
        lst.add("sourcetype");
        lst.add("actrecamt");
        lst.add("isvoucher");
        lst.add("org");
        lst.add("e_receivableamt");
        lst.add("e_actAmt");
        lst.add("e_sourcebillid");
        lst.add("e_sourcebillentryid");
        lst.add("matchflag");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] recBills;
        super.endOperationTransaction(e);
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(10);
        for (DynamicObject recBill : recBills = e.getDataEntities()) {
            DynamicObject settleType = recBill.getDynamicObject("settletype");
            String sourcebilltype = recBill.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String txt_description = recBill.getString("txt_description");
            boolean isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"ReceivRecOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]).equals(txt_description);
            if (!typeDraft && !checkDraft || isFromcdm || isAlloc) {
                logger.info("is not draftType or is from cdm" + recBill.getString("billno"));
                continue;
            }
            DynamicObjectCollection draftbillColl = recBill.getDynamicObjectCollection("draftbill");
            DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
            if (draftbillColl.size() <= 0) continue;
            List draftBillIds = draftbillColl.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"amount,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
            HashMap draftIdTranAmountAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            Map draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
            draftLockInfo.setSourceBillType(recBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(recBill.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(recBill.getLong("id")));
            ArrayList<DraftAmountLockSubInfo> subInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : draftBillIds) {
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(lockDraftId);
                BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                BigDecimal transAmount = draftIdTranAmountAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMap.get(lockDraftId);
                draftAmountLockInfo.setDealAmount(transAmount);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockInfo.setBillLogId(draftLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                subInfoList.add(draftAmountLockInfo);
            }
            if (!EmptyUtil.isNoEmpty(subInfoList)) continue;
            draftLockInfo.setLockSubInfoList(subInfoList);
            lockInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(lockInfoList)) {
            logger.info("ReceivingDeleteOp updateBillsByLog is start," + JSON.toJSONString(lockInfoList));
            this.draftLockServiceHelper.releaseOrLockDraft(lockInfoList);
            logger.info("ReceivingDeleteOp updateBillsByLog is end");
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        this.draftLockServiceHelper.rollback();
    }
}

