/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.cashcount;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.book.cancelbook.CancelBookService;
import kd.fi.cas.business.journal.book.cancelbook.check.CancelBookPluginValidator;
import kd.fi.cas.validator.cashcount.CashVerficationUnauditValidator;

public class CashVerficationUnauditOp
extends AbstractOperationServicePlugIn {
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("billstatus");
        fieldKeys.add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CashVerficationUnauditValidator());
        e.addValidator((AbstractValidator)new CancelBookPluginValidator(this.journalServiceAdapter));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        List billIds = Arrays.stream(e.getDataEntities()).map(o -> o.getLong("id")).collect(Collectors.toList());
        CancelBookService.getInstance().cancelBooks(billIds, this.journalServiceAdapter);
    }
}

