/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.checkAcct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.checkAcct.BalanceadjustValidator;

public class BalanceAdjustOp
extends AbstractOperationServicePlugIn {
    private static final String LOCK_PREFIX = "__CAS_BALANCEADJUST_DLOCK_";
    private static final Log logger = LogFactory.getLog(BalanceAdjustOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BalanceadjustValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        BalanceCountService balanceSerVice = new BalanceCountService();
        ArrayList<Object> successPkIds = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject info : dataEntities) {
            if (!this.isCreateAdjustBalance(info).booleanValue()) continue;
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject accountBank = info.getDynamicObject("accountbank");
            DynamicObject currency = info.getDynamicObject("currency");
            String key = LOCK_PREFIX + org.getPkValue() + "_" + accountBank.getPkValue() + "_" + currency.getPkValue();
            DLock dl = DLock.create((String)key);
            if (!dl.tryLock(3000L)) continue;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    Date endDate = info.getDate("enddate");
                    DynamicObject initObj = SystemStatusCtrolHelper.loadCashMgtInit((long)org.getLong("id"));
                    DynamicObject startperiod = initObj.getDynamicObject("startperiod");
                    DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
                    QFilter filter = new QFilter("org", "=", org.getPkValue());
                    filter.and(new QFilter("bankaccount", "=", accountBank.getPkValue()));
                    filter.and(new QFilter("currency", "=", currency.getPkValue()));
                    filter.and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)startperiod.getDate("begindate"), (boolean)true)).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
                    DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,billstatus,bizdate", (QFilter[])new QFilter[]{filter});
                    if (balances != null && balances.length > 0) {
                        for (DynamicObject balance : balances) {
                            if (!DateUtils.isSameDay((Date)balance.getDate("bizdate"), (Date)endDate) || BillStatusEnum.SAVE.getValue().equals(balance.getString("billstatus"))) continue;
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u8c03\u8282\u8868\u5df2\u5b58\u5728\u975e\u6682\u5b58\u6570\u636e\uff0c\u65e0\u6cd5\u518d\u6b21\u751f\u6210\u3002", (String)"BalanceadjustValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        }
                    }
                    Date date = DateUtils.getBeforeDate((Date)endDate, (Date)new Date());
                    BigDecimal journalbalamt = balanceSerVice.getJournalBalanceByAccount(Long.valueOf(accountBank.getLong("id")), Long.valueOf(currency.getLong("id")), date);
                    BigDecimal statmntbalamt = balanceSerVice.getStatmBalance(Long.valueOf(org.getLong("id")), Long.valueOf(accountBank.getLong("id")), Long.valueOf(currency.getLong("id")), date);
                    QFilter noInitFilter = new QFilter("period", "=", (Object)0);
                    QFilter procFilters = new QFilter("accountbank", "=", accountBank.getPkValue()).and(new QFilter("currency", "=", currency.getPkValue())).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("isvalid", "=", (Object)"1"));
                    QFilter noReachFilter = procFilters.copy().and(noInitFilter);
                    QFilter journalNoReachFilter = procFilters.copy().and(noInitFilter);
                    date = endDate;
                    DynamicObject period = null;
                    if (!this.getOption().getVariables().containsKey("billstatus")) {
                        date = DateUtils.getBeforeDate((Date)endDate, (Date)new Date());
                        if (initObj.getBoolean("isfinishinit")) {
                            Date currentEndDate = currentperiod.getDate("enddate");
                            Date startDate = startperiod.getDate("begindate");
                            if (date.before(startDate)) {
                                String error = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"BalanceAdjustOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), org.getString("name"));
                                throw new KDBizException(error);
                            }
                            period = date.after(currentEndDate) ? currentperiod : PeriodHelper.getPeriodByDate((long)org.getLong("id"), (Date)date);
                            noReachFilter = procFilters.copy().and(new QFilter("bizDate", "<=", (Object)date));
                            journalNoReachFilter = procFilters.copy().and(new QFilter("bookdate", "<=", (Object)date));
                        } else {
                            String error = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u7ed3\u675f\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BalanceAdjustOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), org.getString("name"));
                            throw new KDBizException(error);
                        }
                    }
                    List stateIds = BalanceAdjustHelper.getHasCheckedByDate((Long)org.getLong("id"), (Long)accountBank.getLong("id"), (Long)currency.getLong("id"), (Date)endDate, (String)"cas_bankstatement");
                    List journalIds = BalanceAdjustHelper.getHasCheckedByDate((Long)org.getLong("id"), (Long)accountBank.getLong("id"), (Long)currency.getLong("id"), (Date)endDate, (String)"cas_bankjournal");
                    QFilter noReachFilterOther = null;
                    QFilter journalNoReachFilterOther = null;
                    if (stateIds.size() > 0) {
                        ArrayList stateIdsNew = new ArrayList(stateIds.size());
                        stateIds.forEach(o -> stateIdsNew.add(Long.parseLong(o)));
                        noReachFilterOther = new QFilter("id", "in", stateIdsNew);
                    }
                    if (journalIds.size() > 0) {
                        ArrayList journalIdsNew = new ArrayList(journalIds.size());
                        journalIds.forEach(o -> journalIdsNew.add(Long.parseLong(o)));
                        journalNoReachFilterOther = new QFilter("id", "in", journalIdsNew);
                    }
                    DynamicObject balAdjust = this.CreateBalanceadJust(org, period, accountBank, currency, date);
                    if (this.getOption().getVariables().containsKey("billstatus")) {
                        Map initBalance = new BalanceCountService().getInitBalance(Long.valueOf(org.getLong("id")), Long.valueOf(accountBank.getLong("id")), Long.valueOf(currency.getLong("id")));
                        BigDecimal amountByPeriod = BalanceAdjustHelper.getAmountByPeriod((Long)startperiod.getLong("id"), (Long)accountBank.getLong("id"), (Long)org.getLong("id"), (Long)currency.getLong("id"));
                        journalbalamt = amountByPeriod.add(journalbalamt).add((BigDecimal)initBalance.get("journal"));
                        statmntbalamt = info.getBigDecimal("stmtamt");
                    }
                    balAdjust = BalanceAdjustHelper.adJustAmount((DynamicObject)balAdjust, (BigDecimal)journalbalamt, (String)"cas_bankstatement", (QFilter[])new QFilter[]{noReachFilter, new QFilter("isbank", "=", (Object)"1")}, (boolean)false);
                    if (noReachFilterOther != null) {
                        BalanceAdjustHelper.adJustAmount((DynamicObject)balAdjust, (BigDecimal)journalbalamt, (String)"cas_bankstatement", (QFilter[])new QFilter[]{noReachFilterOther, new QFilter("isbank", "=", (Object)"1")}, (boolean)true);
                    }
                    balAdjust = BalanceAdjustHelper.adJustAmount((DynamicObject)balAdjust, (BigDecimal)statmntbalamt, (String)"cas_bankjournal", (QFilter[])new QFilter[]{journalNoReachFilter}, (boolean)false);
                    if (journalNoReachFilterOther != null) {
                        BalanceAdjustHelper.adJustAmount((DynamicObject)balAdjust, (BigDecimal)statmntbalamt, (String)"cas_bankjournal", (QFilter[])new QFilter[]{journalNoReachFilterOther}, (boolean)true);
                    }
                    if (balances != null && balances.length > 0) {
                        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
                        DeleteServiceHelper.delete((String)"cas_balanceadjust", (QFilter[])new QFilter[]{filter});
                    }
                    BalanceAdjustHelper.setDiffAndBankCg((DynamicObject)balAdjust);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{balAdjust});
                    successPkIds.add(balAdjust.getPkValue());
                }
                catch (KDBizException kdEx) {
                    tx.markRollback();
                    logger.error("Failed to generate the balance reconciliation table kdEx", (Throwable)kdEx);
                    throw kdEx;
                }
                catch (Exception ext) {
                    tx.markRollback();
                    logger.error("Failed to generate the balance reconciliation table", (Throwable)ext);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[traceId:%1$s]\u3002", (String)"BalanceAdjustOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), RequestContext.get().getTraceId()));
                }
            }
            finally {
                dl.unlock();
            }
        }
        this.operationResult.setSuccessPkIds(successPkIds);
    }

    private DynamicObject CreateBalanceadJust(DynamicObject org, DynamicObject period, DynamicObject account, DynamicObject currency, Date date) {
        DynamicObject balAdjust = BusinessDataServiceHelper.newDynamicObject((String)"cas_balanceadjust");
        balAdjust.set("org", org.getPkValue());
        if (period != null) {
            DynamicObject periodByDate = PeriodHelper.getPeriodByDate((long)org.getLong("id"), (Date)date);
            if (periodByDate == null) {
                Date startDate = DateUtils.getDataFormat((Date)date, (boolean)true);
                periodByDate = PeriodHelper.getPeriodByDate((long)org.getLong("id"), (Date)startDate);
            }
            if (periodByDate == null) {
                Date endDate = DateUtils.getDataFormat((Date)date, (boolean)false);
                periodByDate = PeriodHelper.getPeriodByDate((long)org.getLong("id"), (Date)endDate);
            }
            if (periodByDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ed3\u675f\u65e5\u671f\u6240\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"BalanceadjustValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            period = periodByDate;
        }
        balAdjust.set("period", period != null ? period.getPkValue() : Integer.valueOf(0));
        balAdjust.set("bankaccount", account.getPkValue());
        balAdjust.set("currency", currency.getPkValue());
        balAdjust.set("bizdate", (Object)date);
        Map variables = this.getOption().getVariables();
        String billStatus = (String)variables.get("billstatus");
        if (billStatus == null || "".equals(billStatus)) {
            billStatus = BillStatusEnum.SAVE.getValue();
        }
        balAdjust.set("billstatus", (Object)billStatus);
        String userID = RequestContext.get().getUserId();
        balAdjust.set("creator", (Object)Long.valueOf(userID));
        balAdjust.set("createtime", (Object)new Date());
        balAdjust.set("bankaccountnumber", (Object)account.getString("bankaccountnumber"));
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        String number = codeRuleService.getNumber("cas_balanceadjust", balAdjust, null);
        balAdjust.set("billno", (Object)number);
        return balAdjust;
    }

    private Boolean isCreateAdjustBalance(DynamicObject bankVc) {
        boolean checked;
        if (this.getOption().getVariables().containsKey("finishinit")) {
            return true;
        }
        DynamicObject org = bankVc.getDynamicObject("org");
        QFilter filterRecEdc = new QFilter("org", "=", org.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filterRecEdc});
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return false;
        }
        Date dateEnd = bankVc.getDate("bizdateend");
        DynamicObject startPeriod = dynamicObject.getDynamicObject("recperiod");
        Date startPeriodBegin = startPeriod.getDate("begindate");
        if (dateEnd == null) {
            return false;
        }
        if (dateEnd.compareTo(startPeriodBegin) < 0) {
            return false;
        }
        DynamicObject accountBank = bankVc.getDynamicObject("accountbank");
        Date acctOpDate = accountBank.getDate("opendate");
        Date endDate = bankVc.getDate("enddate");
        boolean bl = checked = acctOpDate.getTime() > endDate.getTime();
        if (checked) {
            return false;
        }
        return true;
    }
}

