/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.InitCashHelper;

public class CasRestInitImportDataOp
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(CasRestInitImportDataOp.class);
    private static final Integer INIT_CAPACITY = 4;

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.saveData(rowdatas, logger);
        return super.save(rowdatas, logger);
    }

    public void saveData(List<ImportBillData> rowdatas, ImportLogger logger) {
        List orgIds = InitCashHelper.getOrgIds(rowdatas);
        if (orgIds.size() == 0) {
            LOGGER.warn("CasRestInitImportDataOp\uff1a cannot fetch information of origin");
            return;
        }
        Map periodMap = InitCashHelper.getCashInit((List)orgIds);
        if (periodMap.size() == 0) {
            LOGGER.warn("CasRestInitImportDataOp\uff1a cannot fetch information of cash");
            return;
        }
        for (ImportBillData data : rowdatas) {
            JSONObject jsonData = data.getData();
            Map org = (Map)jsonData.get((Object)"org");
            String orgNum = (String)org.get("number");
            Map period = (Map)periodMap.get(orgNum);
            this.setRestPeriod(period, jsonData);
            this.setCurrentPeriod(period, jsonData);
            this.setStartPeriod(period, jsonData);
            this.setAccountInfo(data, logger);
        }
    }

    private void setAccountInfo(ImportBillData data, ImportLogger logger) {
        DynamicObject[] cashes;
        DynamicObject[] accounts;
        JSONObject jsonData = data.getData();
        JSONArray entryEntities = jsonData.getJSONArray("entryentity");
        HashSet<String> bankNumbers = new HashSet<String>(entryEntities.size());
        HashSet<String> cashNumbers = new HashSet<String>(entryEntities.size());
        HashMap<String, DynamicObject> accountDynamicObjects = new HashMap<String, DynamicObject>(entryEntities.size());
        HashMap<String, DynamicObject> cashDynamicObjects = new HashMap<String, DynamicObject>(entryEntities.size());
        for (int i = 0; i < entryEntities.size(); ++i) {
            DynamicObject[] entryEntity = entryEntities.getJSONObject(i);
            if (entryEntity.containsKey((Object)"bank_accountbank")) {
                JSONObject accountBank = entryEntity.getJSONObject("bank_accountbank");
                String accountBankNum = accountBank.getString("bankaccountnumber");
                bankNumbers.add(accountBankNum);
                continue;
            }
            if (!entryEntity.containsKey((Object)"cash_accountcash")) continue;
            JSONObject cashAccount = entryEntity.getJSONObject("cash_accountcash");
            String cashAccountNum = cashAccount.getString("number");
            cashNumbers.add(cashAccountNum);
        }
        for (DynamicObject account : accounts = AccountBankHelper.getAccountByNumbers(bankNumbers)) {
            String number = account.getString("bankaccountnumber");
            accountDynamicObjects.put(number, account);
        }
        for (DynamicObject cash : cashes = AccountCashHelper.getAcctCashByNumbers(cashNumbers)) {
            String number = cash.getString("number");
            cashDynamicObjects.put(number, cash);
        }
        for (int i = 0; i < entryEntities.size(); ++i) {
            JSONObject entryEntity = entryEntities.getJSONObject(i);
            if (entryEntity.containsKey((Object)"bank_accountbank") && entryEntity.containsKey((Object)"cash_accountcash")) {
                String message = ResManager.loadKDString((String)"\u540c\u4e00\u884c\u4e2d\u3010\u73b0\u91d1\u8d26\u6237/\u94f6\u884c\u8d26\u6237\u3011\u4e24\u4e2a\u5b57\u6bb5\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u6709\u503c", (String)"CasRestInitImportDataOp_01", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                logger.log(Integer.valueOf(data.getDataIndex() + 1), message).fail();
            }
            if (entryEntity.containsKey((Object)"bank_accountbank")) {
                JSONObject accountBank = entryEntity.getJSONObject("bank_accountbank");
                String accountBankNum = accountBank.getString("bankaccountnumber");
                DynamicObject account = (DynamicObject)accountDynamicObjects.get(accountBankNum);
                entryEntity.put("bank_bankaccountnumber", (Object)InitCashHelper.getAccountBankDisplay((DynamicObject)account));
                continue;
            }
            if (!entryEntity.containsKey((Object)"cash_accountcash")) continue;
            JSONObject cashAccount = entryEntity.getJSONObject("cash_accountcash");
            String cashAccountNum = cashAccount.getString("number");
            DynamicObject cash = (DynamicObject)cashDynamicObjects.get(cashAccountNum);
            entryEntity.put("cash_accountcashnumber", (Object)InitCashHelper.getAccountCashDisplay((DynamicObject)cash));
        }
    }

    private void setCurrentPeriod(Map<String, Object> period, JSONObject jsonData) {
        DynamicObject periodCurrent = (DynamicObject)period.get("current");
        if (periodCurrent == null) {
            return;
        }
        HashMap<String, Object> currentPeriodImport = new HashMap<String, Object>(INIT_CAPACITY);
        currentPeriodImport.put("importprop", "id");
        currentPeriodImport.put("id", periodCurrent.getLong("id"));
        jsonData.put("currentperiod", currentPeriodImport);
    }

    private void setStartPeriod(Map<String, Object> period, JSONObject jsonData) {
        DynamicObject periodStart = (DynamicObject)period.get("start");
        if (periodStart == null) {
            return;
        }
        HashMap<String, Object> startPeriodImport = new HashMap<String, Object>(INIT_CAPACITY);
        startPeriodImport.put("importprop", "id");
        startPeriodImport.put("id", periodStart.getLong("id"));
        jsonData.put("startperiod", startPeriodImport);
    }

    private void setRestPeriod(Map<String, Object> period, JSONObject jsonData) {
        DynamicObject periodDynamic = (DynamicObject)period.get("current");
        HashMap<String, Object> newPeriodImport = new HashMap<String, Object>(INIT_CAPACITY);
        newPeriodImport.put("importprop", "id");
        newPeriodImport.put("id", periodDynamic.getLong("id"));
        jsonData.remove((Object)"resetinitbalperiod");
        jsonData.put("resetinitbalperiod", newPeriodImport);
    }
}

