/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.journal;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.consts.BankJournalModel;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.journal.BankJournalDeleteValidate;

public class BankJournalDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("ischeck");
        fieldKeys.add("org");
        fieldKeys.add("accountbank");
        fieldKeys.add("currency");
        fieldKeys.add("bookdate");
        fieldKeys.add("period");
        fieldKeys.add("source");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("debitamount");
        fieldKeys.add("creditamount");
        fieldKeys.add("accountcash");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BankJournalDeleteValidate());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        LinkedList<Object[]> transIds = new LinkedList<Object[]>();
        for (DynamicObject info : e.getDataEntities()) {
            Long source = info.getLong("source");
            if (!EmptyUtil.isNoEmpty((Long)source) || !source.equals(BankJournalModel.SOURCE_TYPE)) continue;
            transIds.add(new Object[]{info.getLong("sourcebillid")});
        }
        if (!transIds.isEmpty()) {
            String sql = "update t_bei_transdetail set fisdownbankjournal=0 where fid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, transIds);
        }
    }
}

