/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.overdraft;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class PaymentPrePayForDraftValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PaymentPrePayForDraftValidator.class);

    public void validate() {
        boolean isfromview = this.getOption().containsVariable("isfromview");
        if (!isfromview) {
            return;
        }
        block10: for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long orgId = dataEntity.getDynamicObject("org").getLong("id");
            boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs122");
            String settleTypeKey = DraftHelper.getKey((Object)dataEntity.get("settletype"));
            logger.info("selectDraftFlag is:" + selectDraftFlag + ",key:" + settleTypeKey);
            boolean isdraft = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"isdraft");
            boolean ischeck = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ischeck");
            boolean ispromissorynote = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ispromissorynote");
            if (CasHelper.isEmpty((Object)settleTypeKey)) continue;
            switch (settleTypeKey) {
                case "isdraft": {
                    if (!isdraft || selectDraftFlag) continue block10;
                    String typeName = ResManager.loadKDString((String)"\u6c47\u7968", (String)"DraftHelper_4", (String)"fi-cas-common", (Object[])new Object[0]);
                    this.cancelAndWarn(extendedDataEntity, dataEntity, typeName);
                    continue block10;
                }
                case "ischeck": {
                    if (!ischeck || selectDraftFlag) continue block10;
                    String typeName = ResManager.loadKDString((String)"\u652f\u7968", (String)"DraftHelper_5", (String)"fi-cas-common", (Object[])new Object[0]);
                    this.cancelAndWarn(extendedDataEntity, dataEntity, typeName);
                    continue block10;
                }
                case "ispromissorynote": {
                    if (!ispromissorynote || selectDraftFlag) continue block10;
                    String typeName = ResManager.loadKDString((String)"\u672c\u7968", (String)"DraftHelper_6", (String)"fi-cas-common", (Object[])new Object[0]);
                    this.cancelAndWarn(extendedDataEntity, dataEntity, typeName);
                    continue block10;
                }
            }
        }
    }

    private void cancelAndWarn(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, String typeName) {
        String msg = String.format(ResManager.loadKDString((String)"%1$s :\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a%2$s\u7684\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u786e\u8ba4\u4ed8\u6b3e", (String)"DraftHelper_7_1", (String)"fi-cas-common", (Object[])new Object[0]), dataEntity.getString("billno"), typeName);
        this.addMessage(extendedDataEntity, msg, ErrorLevel.Error);
    }
}

