/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyDelDraftOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PayApplyDelDraftOp.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_settletnumber"));
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_draftbill"));
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_paystatus"));
        fieldKeys.add(String.join((CharSequence)".", "cas_payinfo", "entry_invalid"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String isDelByPaySche = this.operateOption.getVariables().getOrDefault("isdelbypaysche", "");
        String isdelbydraft = this.operateOption.getVariables().getOrDefault("isdelbydraft", "");
        if (EmptyUtil.isEmpty((String)isDelByPaySche) && EmptyUtil.isEmpty((String)isdelbydraft)) {
            ArrayList<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>();
            for (DynamicObject data : e.getDataEntities()) {
                HashMap draftIdLogIdMap;
                HashMap draftIdDealAmountMap;
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
                List lockDraftIds = PayApplyBillHelper.getDraftBillList((DynamicObjectCollection)data.getDynamicObjectCollection("cas_payinfo"), (boolean)true);
                DraftLockInfo draftLockInfo = this.draftLockServiceHelper.getReleaseLockInfo(data, lockDraftIds, draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new)), draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new)));
                if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
                lockOrReleaseInfoList.add(draftLockInfo);
            }
            if (!CollectionUtils.isEmpty(lockOrReleaseInfoList)) {
                logger.info("PayApplyDelDraftOp updateBillsByLog is start," + JSON.toJSONString(lockOrReleaseInfoList));
                this.draftLockServiceHelper.releaseOrLockDraft(lockOrReleaseInfoList);
                logger.info("PayApplyDelDraftOp updateBillsByLog is end");
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public Set<String> preparePropertys() {
                Set selectors = super.preparePropertys();
                selectors.add(String.join((CharSequence)".", "cas_payinfo", "entry_settletnumber"));
                selectors.add(String.join((CharSequence)".", "cas_payinfo", "entry_draftbill"));
                return selectors;
            }

            public void validate() {
                Map variables = this.getOption().getVariables();
                variables.getOrDefault("isdelbypaysche", "");
            }
        });
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
    }
}

