/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyPayInvalidOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayApplyPayInvalidOp.class);
    private static final String PKVALUE_MAP = "pkValueMap";
    private DraftLockServiceHelper draftLockServiceHelper;
    private Map<Long, List<Long>> payAppIdAndDraftId = new HashMap<Long, List<Long>>(8);

    public PayApplyPayInvalidOp() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("cas_draftinfo");
        fieldKeys.add("billno");
        fieldKeys.add("ispartpayment");
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Map<Long, List<Long>> pkValueMap = this.getPkValueMap();
        Map<Long, DynamicObject> dataEntityFromDBMap = this.getDataEntityFromDBMap(pkValueMap.keySet().toArray(new Long[0]));
        ArrayList<DynamicObject> mPayApplyBillSaveList = new ArrayList<DynamicObject>(pkValueMap.size());
        ArrayList<Long> mPayApplyBillInvalidList = new ArrayList<Long>(pkValueMap.size());
        DynamicObjectCollection payInfos = null;
        for (DynamicObject payApplyBill : dataEntityFromDBMap.values()) {
            List beforedraftIds = new ArrayList(8);
            List afterdraftIds = new ArrayList(8);
            payInfos = payApplyBill.getDynamicObjectCollection("cas_payinfo");
            beforedraftIds = PayApplyBillHelper.getDraftBillList((DynamicObjectCollection)payInfos, (boolean)false);
            List<Long> pkValueList = pkValueMap.get(payApplyBill.getLong("id"));
            payInfos.stream().filter(payInfo -> pkValueList.contains(payInfo.getLong("id"))).forEach(payInfo -> payInfo.set("entry_invalid", (Object)true));
            afterdraftIds = PayApplyBillHelper.getDraftBillList((DynamicObjectCollection)payInfos, (boolean)false);
            beforedraftIds.removeAll(afterdraftIds);
            if (EmptyUtil.isNoEmpty(beforedraftIds)) {
                long applyId = payApplyBill.getLong("id");
                this.payAppIdAndDraftId.put(applyId, beforedraftIds);
            }
            this.partInvalidPay(payApplyBill, pkValueMap, payInfos);
            payApplyBill = PayApplyBillHelper.updateHeaderInfo((DynamicObjectCollection)payInfos, (DynamicObject)payApplyBill);
            this.setPartPayStatus(payApplyBill, payInfos);
            mPayApplyBillSaveList.add(payApplyBill);
            if (!payInfos.stream().filter(o -> !PayStatusEnum.CLANCEL.getValue().equals(o.getString("entry_paystatus"))).allMatch(o -> o.getBoolean("entry_invalid"))) continue;
            mPayApplyBillInvalidList.add(payApplyBill.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])mPayApplyBillSaveList.toArray(new DynamicObject[0]));
        if (!mPayApplyBillInvalidList.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"invalid", (String)"cas_payapplybill", (Object[])mPayApplyBillInvalidList.toArray(), (OperateOption)OperateOption.create());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Map<Long, List<Long>> pkValueMap = this.getPkValueMap();
        Map<Long, DynamicObject> dataEntityFromDBMap = this.getDataEntityFromDBMap(pkValueMap.keySet().toArray(new Long[0]));
        ArrayList<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>();
        for (DynamicObject payApplyBill : dataEntityFromDBMap.values()) {
            HashMap draftIdLogIdMap;
            long applyId = payApplyBill.getLong("id");
            List<Long> beforedraftIds = this.payAppIdAndDraftId.get(applyId);
            if (EmptyUtil.isEmpty(beforedraftIds)) {
                logger.info("need deal lock draft is null" + applyId);
                continue;
            }
            DynamicObjectCollection entrys = payApplyBill.getDynamicObjectCollection("cas_draftinfo");
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            DraftLockInfo draftLockInfo = this.draftLockServiceHelper.getReleaseLockInfo(payApplyBill, beforedraftIds, draftIdDealAmountMap, draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new)));
            if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
            lockOrReleaseInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(lockOrReleaseInfoList)) {
            logger.info("PayApplyPayInvalidOp updateBillsByLog is start," + JSON.toJSONString(lockOrReleaseInfoList));
            this.draftLockServiceHelper.releaseOrLockDraft(lockOrReleaseInfoList);
            logger.info("PayApplyPayInvalidOp updateBillsByLog is end");
        }
    }

    private Map<Long, List<Long>> getPkValueMap() {
        HashMap<Long, List<Long>> pkValueMap = new HashMap<Long, List<Long>>(0);
        if (this.getOption().containsVariable(PKVALUE_MAP)) {
            String pkValueMapStr = this.getOption().getVariableValue(PKVALUE_MAP);
            try {
                pkValueMap.putAll((Map)JSON.parseObject((String)pkValueMapStr, HashMap.class));
            }
            catch (Exception e1) {
                logger.info("pkValueMap\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9\uff01");
                logger.info(e1.getMessage());
            }
        }
        return pkValueMap;
    }

    private Map<Long, DynamicObject> getDataEntityFromDBMap(Object[] ids) {
        DynamicObject[] dataEntityFromDB = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)String.join((CharSequence)",", "paidstatus", "backbillflag", "partpaysche", "partpay", "billno", "cas_draftinfo", "ispartpayment", String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"), String.join((CharSequence)".", "cas_draftinfo", "transamount"), String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"), String.join((CharSequence)".", "cas_payapplyentry", "e_splitid"), String.join((CharSequence)".", "cas_payapplyentry", "e_chgstatus"), String.join((CharSequence)".", "cas_payinfo", "id"), String.join((CharSequence)".", "cas_payinfo", "entry_applyid"), String.join((CharSequence)".", "cas_payinfo", "entry_paystatus"), String.join((CharSequence)".", "cas_payinfo", "entry_invalid"), String.join((CharSequence)".", "cas_payinfo", "entry_draftbill"), String.join((CharSequence)".", "cas_payinfo", "entry_payeeamount"), String.join((CharSequence)".", "cas_payinfo", "entry_settlementtype"), String.join((CharSequence)".", "cas_payinfo", "entry_settletnumber"), String.join((CharSequence)".", "cas_payinfo", "entry_payeraccbank"), String.join((CharSequence)".", "cas_payinfo", "entry_paycurrency"), String.join((CharSequence)".", "cas_payinfo", "entry_isdiffcur"), String.join((CharSequence)".", "cas_payinfo", "entry_exratetable"), String.join((CharSequence)".", "cas_payinfo", "entry_exratedate"), String.join((CharSequence)".", "cas_payinfo", "entry_exchangerate"), String.join((CharSequence)".", "cas_payinfo", "entry_quotation"), String.join((CharSequence)".", "cas_payinfo", "entry_payamount"), String.join((CharSequence)".", "cas_payinfo", "entry_balance"), String.join((CharSequence)".", "cas_payinfo", "entry_payeetype"), String.join((CharSequence)".", "cas_payinfo", "entry_payeeid"), String.join((CharSequence)".", "cas_payinfo", "entry_payeename"), String.join((CharSequence)".", "cas_payinfo", "entry_payeeaccbanknum"), String.join((CharSequence)".", "cas_payinfo", "entry_accountname"), String.join((CharSequence)".", "cas_payinfo", "entry_recbanknumber"), String.join((CharSequence)".", "cas_payinfo", "entry_payeebank"), String.join((CharSequence)".", "cas_payinfo", "entry_paymentchannel"), String.join((CharSequence)".", "cas_payinfo", "entry_paidamount")), (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        return Arrays.stream(dataEntityFromDB).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                Map pkValueMap = PayApplyPayInvalidOp.this.getPkValueMap();
                Map dataEntityFromDBMap = PayApplyPayInvalidOp.this.getDataEntityFromDBMap(pkValueMap.keySet().toArray(new Long[0]));
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject tPayApply = dataEntity.getDataEntity();
                    if (dataEntityFromDBMap.containsKey(tPayApply.getLong("id")) && pkValueMap.containsKey(tPayApply.getLong("id"))) {
                        DynamicObject payApplyBill = (DynamicObject)dataEntityFromDBMap.get(tPayApply.getLong("id"));
                        List pkValueList = (List)pkValueMap.get(tPayApply.getLong("id"));
                        boolean isChkResult = payApplyBill.getDynamicObjectCollection("cas_payinfo").stream().filter(o -> pkValueList.contains(o.getLong("id"))).anyMatch(o -> {
                            if (o.getBoolean("entry_invalid") || Boolean.TRUE.equals(payApplyBill.getBoolean("ispartpayment")) && !Stream.of(PayStatusEnum.NOTPAYING.getValue(), PayStatusEnum.PAYSCHEFUND.getValue(), PayStatusEnum.CLANCEL.getValue(), PayStatusEnum.PAYING.getValue()).collect(Collectors.toSet()).contains(o.getString("entry_paystatus"))) {
                                return true;
                            }
                            return o.getBoolean("entry_invalid") || Boolean.FALSE.equals(payApplyBill.getBoolean("ispartpayment")) && !Arrays.asList(PayStatusEnum.NOTPAYING.getValue(), PayStatusEnum.PAYSCHEFUND.getValue()).contains(o.getString("entry_paystatus"));
                        });
                        Set entryApplyIdList = payApplyBill.getDynamicObjectCollection("cas_payinfo").stream().filter(o -> pkValueList.contains(o.getLong("id"))).map(item -> item.getString("entry_applyid")).distinct().collect(Collectors.toSet());
                        boolean isInChg = payApplyBill.getDynamicObjectCollection("cas_payapplyentry").stream().anyMatch(o -> entryApplyIdList.contains(o.getString("e_splitid")) && PayApplyRecChgStatusEnum.CHGING.getValue().equals(o.getString("e_chgstatus")));
                        if (isChkResult) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62d2\u4ed8\u5931\u8d25\uff0c\u53ea\u6709\u4ed8\u6b3e\u72b6\u6001=\u5df2\u6392\u6b3e/\u672a\u4ed8\u6b3e\u4e14\u672a\u62d2\u4ed8\u7684\u660e\u7ec6\u884c\u5141\u8bb8\u62d2\u4ed8\u3002", (String)"PayApplyEntryEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (!isInChg) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u5bf9\u5e94\u7684\u7533\u8bf7\u660e\u7ec6\u6b63\u5728\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\uff0c\u4e0d\u53ef\u62d2\u4ed8\u3002", (String)"PayApplyEntryEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6240\u9009\u4ed8\u6b3e\u660e\u7ec6\uff0c\u518d\u8fdb\u884c\u62d2\u4ed8\u64cd\u4f5c\u3002", (String)"PayApplyEntryEdit_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private void partInvalidPay(DynamicObject payApplyBill, Map<Long, List<Long>> pkValueMap, DynamicObjectCollection payInfos) {
        if (!this.getOption().containsVariable("payApplyInvalid") || !"true".equals(this.getOption().getVariableValue("payApplyInvalid"))) {
            return;
        }
        BigDecimal invalidAmount = new BigDecimal(this.getOption().getVariableValue("invalidamount"));
        BigDecimal balanceAmount = BigDecimal.ZERO;
        Long payApplyBillId = payApplyBill.getLong("id");
        List<Long> payInfoIds = pkValueMap.get(payApplyBillId);
        if (payInfoIds == null || pkValueMap.isEmpty()) {
            return;
        }
        DynamicObject payInfoEntry = null;
        Long payInfoId = payInfoIds.get(0);
        for (DynamicObject payInfo : payInfos) {
            Long sPayInfoId = payInfo.getLong("id");
            if (!payInfoId.equals(sPayInfoId)) continue;
            payInfoEntry = payInfo;
            BigDecimal recAmount = payInfo.getBigDecimal("entry_payeeamount");
            balanceAmount = recAmount.subtract(invalidAmount);
            payInfo.set("entry_payeeamount", (Object)balanceAmount);
            if (BigDecimal.ZERO.compareTo(balanceAmount) == 0) {
                payInfo.set("entry_invalid", (Object)true);
                payInfo.set("entry_payeeamount", (Object)recAmount);
            } else {
                payInfo.set("entry_invalid", (Object)false);
            }
            BigDecimal paidAmount = payInfo.getBigDecimal("entry_paidamount");
            if (BigDecimal.ZERO.compareTo(paidAmount) == 0 || balanceAmount.compareTo(paidAmount) != 0) break;
            payInfo.set("entry_paystatus", (Object)"A");
            break;
        }
        this.addNewPayInfo(payInfoEntry, payInfos, balanceAmount, invalidAmount);
    }

    private void setPartPayStatus(DynamicObject payApplyBill, DynamicObjectCollection payInfoEntry) {
        if (!this.getOption().containsVariable("payApplyInvalid") || !"true".equals(this.getOption().getVariableValue("payApplyInvalid"))) {
            return;
        }
        boolean isPartPay = false;
        HashSet<String> status = new HashSet<String>(16);
        HashSet<String> paidStatus = new HashSet<String>(16);
        boolean existReject = false;
        for (DynamicObject payInfo : payInfoEntry) {
            boolean isValid;
            BigDecimal entryPaid = payInfo.getBigDecimal("entry_paidamount");
            String entryPayStatus = payInfo.getString("entry_paystatus");
            if (PayStatusEnum.PAYMENTSUCCESS.getValue().equals(entryPayStatus)) {
                entryPayStatus = PayApplyPayStatusEnum.SUCCESS.getValue();
            } else if (PayStatusEnum.NOTPAYING.getValue().equals(entryPayStatus)) {
                entryPayStatus = PayApplyPayStatusEnum.NOTPAYING.getValue();
            }
            if (BigDecimal.ZERO.compareTo(entryPaid) != 0) {
                isPartPay = true;
            }
            if (!(isValid = payInfo.getBoolean("entry_invalid"))) {
                paidStatus.add(entryPayStatus);
            } else {
                existReject = true;
            }
            status.add(entryPayStatus);
        }
        PaymentPayHelper.setPartPay((DynamicObject)payApplyBill, status, (boolean)isPartPay, (boolean)existReject);
        PaymentPayHelper.setPaidStatus((DynamicObject)payApplyBill, paidStatus);
    }

    private void addNewPayInfo(DynamicObject payInfoEntry, DynamicObjectCollection payInfos, BigDecimal balanceAmount, BigDecimal invalidAmount) {
        if (payInfoEntry == null || BigDecimal.ZERO.compareTo(balanceAmount) == 0) {
            return;
        }
        DynamicObject newPayInfoEntryData = payInfos.addNew();
        newPayInfoEntryData.set("id", null);
        newPayInfoEntryData.set("entry_settlementtype", payInfoEntry.get("entry_settlementtype"));
        newPayInfoEntryData.set("entry_payeraccbank", payInfoEntry.get("entry_payeraccbank"));
        newPayInfoEntryData.set("entry_paycurrency", payInfoEntry.get("entry_paycurrency"));
        newPayInfoEntryData.set("entry_isdiffcur", payInfoEntry.get("entry_isdiffcur"));
        newPayInfoEntryData.set("entry_exratetable", payInfoEntry.get("entry_exratetable"));
        newPayInfoEntryData.set("entry_exratedate", payInfoEntry.get("entry_exratedate"));
        newPayInfoEntryData.set("entry_exchangerate", payInfoEntry.get("entry_exchangerate"));
        newPayInfoEntryData.set("entry_quotation", payInfoEntry.get("entry_quotation"));
        newPayInfoEntryData.set("entry_payamount", payInfoEntry.get("entry_payamount"));
        newPayInfoEntryData.set("entry_balance", payInfoEntry.get("entry_balance"));
        newPayInfoEntryData.set("entry_payeeamount", (Object)invalidAmount);
        newPayInfoEntryData.set("entry_payeetype", payInfoEntry.get("entry_payeetype"));
        newPayInfoEntryData.set("entry_payeeid", payInfoEntry.get("entry_payeeid"));
        newPayInfoEntryData.set("entry_payeename", payInfoEntry.get("entry_payeename"));
        newPayInfoEntryData.set("entry_payeeaccbanknum", payInfoEntry.get("entry_payeeaccbanknum"));
        newPayInfoEntryData.set("entry_accountname", payInfoEntry.get("entry_accountname"));
        newPayInfoEntryData.set("entry_recbanknumber", payInfoEntry.get("entry_recbanknumber"));
        newPayInfoEntryData.set("entry_payeebank", payInfoEntry.get("entry_payeebank"));
        newPayInfoEntryData.set("entry_paystatus", (Object)"C");
        newPayInfoEntryData.set("entry_invalid", (Object)true);
        newPayInfoEntryData.set("entry_paymentchannel", payInfoEntry.get("entry_paymentchannel"));
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
    }
}

