/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payment;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PaymentBillIsFreezeValidator;
import kd.fi.cas.validator.paymentbill.PaymentPayPushIfmValidator;

public class PaymentPayPushIfmOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaymentPayPushIfmOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("org");
        fieldKeys.add("id");
        fieldKeys.add("payeename");
        fieldKeys.add("payeracctbank");
        fieldKeys.add("payeebanknum");
        fieldKeys.add("recprovince");
        fieldKeys.add("reccity");
        fieldKeys.add("reccountry");
        fieldKeys.add("recaccbankname");
        fieldKeys.add("iscrosspay");
        fieldKeys.add("iscommitbe");
        fieldKeys.add("bankpaystatus");
        fieldKeys.add("commitbetime");
        fieldKeys.add("cashier");
        fieldKeys.add("usage");
        fieldKeys.add("recbanknumber");
        fieldKeys.add("payeeacctbank");
        fieldKeys.add("isdiffcur");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("paymentidentify");
        fieldKeys.add("settletype");
        fieldKeys.add("inneraccount");
        fieldKeys.add("paymentchannel");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PaymentPayPushIfmValidator());
        e.addValidator((AbstractValidator)new PaymentBillIsFreezeValidator());
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.COMMITBEIFMVALIDATE));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject payBill : dataEntities = e.getDataEntities()) {
            payBill.set("billstatus", (Object)BillStatusEnum.BEING.getValue());
            payBill.set("cashier", (Object)CasHelper.getCurrentUser());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject[] payTanBills = null;
        try {
            payTanBills = CasBotpHelper.pushs((DynamicObject[])dataEntities, (String)"ifm_payacceptancebill");
            this.casToPayTanBotpServiceEC(payTanBills);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(String.valueOf(exception));
        }
    }

    private void casToPayTanBotpServiceEC(DynamicObject[] payTanBills) {
        try (TXHandle tx = TX.required();){
            ECGlobalSession.begin((String)"cas_ToPayTanBotpServiceEC", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            CommonParam param = new CommonParam();
            param.put((Object)"bills", (Object)payTanBills);
            ECGlobalSession.register((String)"fi", (String)"cas", (String)"CasToPayTanBotpServiceEC", (Param)param);
        }
    }
}

