/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recbill;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.log.RefundLogExecutor;
import kd.fi.cas.validator.rec.RecBackstageRefundRenoteValidator;
import org.apache.commons.lang3.StringUtils;

public class RecBackstageRefundRenoteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RecBackstageRefundRenoteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RecBackstageRefundRenoteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperationResult result;
        DynamicObject revBill = e.getDataEntities()[0];
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String billType = (String)variables.get("billType");
        String billId = (String)variables.get("billId");
        String entryIdsStr = (String)variables.get("entryIds");
        List entryIds = null;
        if (StringUtils.isNotBlank((CharSequence)entryIdsStr)) {
            entryIds = JSONObject.parseArray((String)entryIdsStr, Long.class);
        }
        MainEntityType casRefundRenoteType = EntityMetadataCache.getDataEntityType((String)"cas_refund_renote");
        DynamicObject refundObj = new DynamicObject((DynamicObjectType)casRefundRenoteType);
        refundObj.set("relebilltype", (Object)billType);
        refundObj.set("relewithinfo", (Object)true);
        DynamicObjectType revListType = ((DynamicCollectionProperty)casRefundRenoteType.getProperty("revlist")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection revList = new DynamicObjectCollection(revListType, (Object)refundObj);
        DynamicObject revInfo = new DynamicObject(revListType);
        revInfo.set("revid", revBill.get("id"));
        revList.add((Object)revInfo);
        refundObj.set("revlist", (Object)revList);
        DynamicObjectType releBillListType = ((DynamicCollectionProperty)casRefundRenoteType.getProperty("relebilllist")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection releBillList = new DynamicObjectCollection(releBillListType, (Object)refundObj);
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(billId));
        if (CollectionUtils.isNotEmpty((Collection)entryIds)) {
            filter.and("entry.id", "in", (Object)entryIds);
        }
        DynamicObjectCollection refundList = QueryServiceHelper.query((String)billType, (String)"id,isdiffcur,entry.id,entry.e_remainrefundamt", (QFilter[])filter.toArray());
        String operateKey = variables.getOrDefault("operateKey", "refund");
        RefundLogExecutor logExecutor = new RefundLogExecutor(refundObj, operateKey);
        if (CollectionUtils.isNotEmpty((Collection)refundList)) {
            boolean isDiffer = false;
            if ("cas_paybill".equals(billType) && ((DynamicObject)refundList.get(0)).getBoolean("isdiffcur")) {
                refundList = QueryServiceHelper.query((String)billType, (String)"id,dpamt", (QFilter[])filter.toArray());
                isDiffer = true;
            }
            for (DynamicObject refundBill : refundList) {
                DynamicObject releBill = new DynamicObject(releBillListType);
                releBill.set("id", refundBill.get("id"));
                if (isDiffer) {
                    releBill.set("currentrefundamt", refundBill.get("dpamt"));
                } else {
                    releBill.set("entryid", refundBill.get("entry.id"));
                    releBill.set("currentrefundamt", refundBill.get("entry.e_remainrefundamt"));
                }
                releBillList.add((Object)releBill);
            }
            refundObj.set("relebilllist", (Object)releBillList);
            OperateOption refundOption = OperateOption.create();
            refundOption.setVariableValue("operateKey", operateKey);
            try {
                result = OperateServiceHelper.execOperateWithoutThrow((String)"refundrenote", (String)"cas_refund_renote", (DynamicObject[])new DynamicObject[]{refundObj}, (OperateOption)refundOption);
            }
            catch (Exception ex) {
                logger.error("BackstageRefundRenote exec refundrenote error", (Throwable)ex);
                OperationResult errResult = new OperationResult();
                errResult.setSuccess(false);
                errResult.setMessage(ex.getMessage());
                logExecutor.saveLog(errResult);
                throw new KDBizException(ex.getMessage());
            }
            if (!result.isSuccess()) {
                String failResultMsg = CasHelper.getFailResultMsg((OperationResult)result);
                logger.error("BackstageRefundRenote exec refundrenote fail: " + failResultMsg);
                logExecutor.saveLog(result);
                throw new KDBizException(failResultMsg);
            }
        } else {
            logger.error("BackstageRefundRenote exec refundrenote entry is empty");
            OperationResult result2 = new OperationResult();
            result2.setSuccess(false);
            result2.setMessage("entry is empty");
            logExecutor.saveLog(result2);
            throw new KDBizException("entry is empty");
        }
        logExecutor.saveLog(result);
    }
}

