/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.validator.ReceivingRefundValidate;
import kd.fi.cas.validator.receivingbill.ReceivingRefundAndReturnMoneyContainIfmBackValidator;

public class ReceivingBillReturnMoneyIfmBackOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("actrecamt");
        fieldKeys.add("settletype");
        fieldKeys.add("entry");
        fieldKeys.add("entry.e_receivableamt");
        fieldKeys.add("txt_description");
        fieldKeys.add("fee");
        fieldKeys.add("payername");
        fieldKeys.add("receivingtype");
        fieldKeys.add("ispartreceivable");
        fieldKeys.add("receivingtype.ispartreceivable");
        fieldKeys.add("payer");
        fieldKeys.add("currency.id");
        fieldKeys.add("receivingtype.biztype");
        fieldKeys.add("inneraccount.company.id");
        fieldKeys.add("accountbank.id");
        fieldKeys.add("payeracctbanknum");
        fieldKeys.add("org.id");
        fieldKeys.add("refundbatchseqid");
        fieldKeys.add("entry.e_settledamt");
        fieldKeys.add("isrefund");
        fieldKeys.add("isfullrefund");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReceivingRefundAndReturnMoneyContainIfmBackValidator());
        e.addValidator((AbstractValidator)new ReceivingRefundValidate());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map variables = this.getOption().getVariables();
        Long billId = Long.valueOf(variables.get("billid") == null ? "0" : (String)variables.get("billid"));
        DynamicObject recBill = e.getDataEntities()[0];
        DynamicObjectCollection recCol = recBill.getDynamicObjectCollection("entry");
        BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"ifm_transhandlebill", (String)"id,paidstatus,acrefundamt,actpayamt,acrefundreson,recbill", (QFilter[])qFilter.toArray());
        String txtDescription = recBill.getString("txt_description");
        if (txtDescription != null && txtDescription.length() > 256) {
            txtDescription = txtDescription.substring(0, 255);
        }
        bill.set("acrefundreson", (Object)txtDescription);
        bill.set("acrefundamt", (Object)recAmtSum);
        bill.set("paidstatus", (Object)"F");
        bill.set("recbill", (Object)recBill);
        OperationResult operationResult = OperateServiceHelper.execOperate((String)"refundwriteback", (String)"ifm_transhandlebill", (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            throw new KDBizException(operationResult.getMessage());
        }
        this.saveRecBill(recBill, bill.getBigDecimal("actpayamt"));
    }

    private void saveRecBill(DynamicObject recBill, BigDecimal actpayamt) {
        recBill.set("isrefund", (Object)true);
        recBill.set("isfullrefund", (Object)true);
        BigDecimal actrecamt = recBill.getBigDecimal("actrecamt");
        BigDecimal actRecAmtFee = actrecamt.add(recBill.getBigDecimal("fee"));
        if (actRecAmtFee.compareTo(actpayamt) != 0) {
            recBill.set("isfullrefund", (Object)false);
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
        }
    }
}

