/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.util.EmptyUtil;

public class ClaimBillClaimDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ClaimBillClaimDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(EntityPropertyHelper.getPropertys((String)"cas_claimbill"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"entryentity"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        List sourceClaimIdList = Arrays.stream(infos).map(o -> o.getLong("sourceclaimid")).collect(Collectors.toList());
        Map sourceClaimBillMap = null;
        if (sourceClaimIdList.size() > 0) {
            DynamicObject[] sourceClaimBill = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,entryentity.e_corebilltype,entryentity.claimdimension,entryentity.claimcomtrol,entryentity.e_corebillid,entryentity.e_corebillentryid,entryentity.e_receivableamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceClaimIdList)});
            sourceClaimBillMap = Arrays.stream(sourceClaimBill).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        }
        Set claimNoSet = Arrays.stream(infos).map(o -> o.getString("claimno")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("billno", "in", claimNoSet);
        Object[] claimNoticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
        Map<String, DynamicObject> claimNoticeBillMap = null;
        if (EmptyUtil.isNoEmpty((Object[])claimNoticeBills)) {
            claimNoticeBillMap = Arrays.stream(claimNoticeBills).collect(Collectors.toMap(o -> o.getString("billno"), Function.identity()));
        }
        ArrayList claimCoreInfoList = new ArrayList(10);
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject info : infos) {
            Long sourceclaimid;
            String claimStatus = info.getString("claimstatus");
            if (ClaimStatusEnum.CHANGE.getValue().equals(claimStatus)) {
                Set detailSet = CasBotpHelper.getSrcBillByDestBill((Long)((Long)info.getPkValue()), (String)"cas_claimbill", (String)"cas_claimbill");
                DynamicObject[] thisSrcDetails = BusinessDataServiceHelper.load((Object[])detailSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_claimbill"));
                Arrays.stream(thisSrcDetails).forEach(v -> v.set("claimstatus", (Object)ClaimStatusEnum.SURE.getValue()));
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])thisSrcDetails);
                }
            }
            if (EmptyUtil.isNoEmpty((Long)(sourceclaimid = Long.valueOf(info.getLong("sourceclaimid")))) && null != sourceClaimBillMap) {
                DynamicObject sourceclaim = (DynamicObject)sourceClaimBillMap.get(sourceclaimid);
                RecClaimHelper.getClaimCoreInfo((DynamicObject)sourceclaim, (DynamicObject)info, claimCoreInfoList);
                String claimNo = info.getString("claimno");
                paramList.addAll(this.receiptClaimSettleService(claimNo, claimNoticeBillMap));
                continue;
            }
            RecClaimHelper.getDelClaimCoreInfo((DynamicObject)info, claimCoreInfoList);
        }
        RecClaimHelper.writeBackAmt(claimCoreInfoList);
        if (paramList.size() > 0) {
            logger.info("begin ClaimBillClaimDeleteOp ReceiptClaimSetlleService : " + paramList);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ReceiptClaimSetlleService", (String)"settle", (Object[])new Object[]{paramList});
        }
    }

    private List<Map<String, Object>> receiptClaimSettleService(String claimNo, Map<String, DynamicObject> claimNoticeBillMap) {
        Long id;
        Map targetRecBills;
        HashSet targetEntityRecIds;
        DynamicObject claimNoticeBill;
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(10);
        if (EmptyUtil.isNoEmpty((String)claimNo) && EmptyUtil.isNoEmpty((DynamicObject)(claimNoticeBill = claimNoticeBillMap.get(claimNo))) && !CollectionUtils.isEmpty((Collection)(targetEntityRecIds = (HashSet)(targetRecBills = BFTrackerServiceHelper.findTargetBills((String)"cas_claimcenterbill", (Long[])new Long[]{id = Long.valueOf(claimNoticeBill.getLong("id"))})).get("cas_recbill")))) {
            DynamicObject[] recBills;
            for (DynamicObject recBill : recBills = BusinessDataServiceHelper.load((Object[])targetEntityRecIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_recbill"))) {
                String billStatus;
                if ("1".equals(recBill.getString("hotaccount")) || "2".equals(recBill.getString("hotaccount")) || !"D".equals(billStatus = recBill.getString("billstatus"))) continue;
                DynamicObjectCollection recEntryColl = recBill.getDynamicObjectCollection("entry");
                for (DynamicObject recEntry : recEntryColl) {
                    if (!"ar_finarbill".equals(recEntry.get("e_corebilltype")) || !recEntry.getBoolean("claimcomtrol")) continue;
                    HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                    map.put("recbillid", Long.valueOf(recBill.getLong("id")));
                    map.put("recbillentryid", Long.valueOf(recEntry.getLong("id")));
                    map.put("corebillid", Long.valueOf(recEntry.getString("e_corebillid")));
                    map.put("corebillentryid", Long.valueOf(recEntry.getLong("e_corebillentryid")));
                    map.put("receivableamt", recEntry.getBigDecimal("e_receivableamt"));
                    map.put("settleorg", Long.valueOf(recEntry.getDynamicObject("e_settleorg").getLong("id")));
                    map.put("needbuildjournal", Boolean.FALSE);
                    paramList.add(map);
                }
            }
        }
        return paramList;
    }
}

