/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BusinessTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ClaimBillSaveSubmitValidator;
import kd.fi.cas.validator.claimbill.ClaimBillAutoRenoteValidator;
import kd.fi.cas.validator.recclaim.ClaimBillSaveValidator;

public class ClaimBillClaimSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        ClaimBillSaveValidator validator = new ClaimBillSaveValidator();
        validator.setEntityKey("cas_claimbill");
        e.addValidator((AbstractValidator)new ClaimBillSaveSubmitValidator());
        e.addValidator((AbstractValidator)validator);
        e.addValidator((AbstractValidator)new ClaimBillAutoRenoteValidator());
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List lst = args.getFieldKeys();
        lst.addAll(EntityPropertyHelper.getPropertys((String)"cas_claimbill"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"entryentity"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"payentity"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        List sourceClaimIdList = Arrays.stream(infos).map(o -> o.getLong("sourceclaimid")).collect(Collectors.toList());
        List claimIdList = Arrays.stream(infos).map(o -> o.getLong("id")).collect(Collectors.toList());
        claimIdList.addAll(sourceClaimIdList);
        Map sourceClaimBillMap = null;
        if (claimIdList.size() > 0) {
            DynamicObject[] sourceClaimBill = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,entryentity.e_corebilltype,entryentity.e_corebillid,entryentity.claimdimension,entryentity.claimcomtrol,entryentity.e_corebillentryid,entryentity.e_receivableamt", (QFilter[])new QFilter[]{new QFilter("id", "in", claimIdList)});
            sourceClaimBillMap = Arrays.stream(sourceClaimBill).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        }
        ArrayList claimCoreInfoList = new ArrayList(10);
        for (DynamicObject info : infos) {
            DynamicObject dbClaimBill;
            info.set("rejectreason", null);
            info.set("isnoticemerge", (Object)false);
            BigDecimal claimamount = BigDecimal.ZERO;
            BigDecimal payAmount = info.getBigDecimal("payamount");
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObjectCollection payentityColl = info.getDynamicObjectCollection("payentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payentityColl)) {
                    for (DynamicObject dynamicObject : payentityColl) {
                        claimamount = claimamount.add(dynamicObject.getBigDecimal("e_payableamt"));
                    }
                }
            } else {
                DynamicObjectCollection entryentity = info.getDynamicObjectCollection("entryentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryentity)) {
                    for (DynamicObject dynamicObject : entryentity) {
                        claimamount = claimamount.add(dynamicObject.getBigDecimal("e_receivableamt"));
                    }
                }
            }
            info.set("claimamount", null);
            info.set("claimamount", (Object)claimamount);
            if (null == sourceClaimBillMap) {
                RecClaimHelper.getClaimCoreInfo((DynamicObject)info, null, claimCoreInfoList);
                continue;
            }
            Long sourceclaimid = info.getLong("sourceclaimid");
            if (EmptyUtil.isNoEmpty((Long)sourceclaimid)) {
                dbClaimBill = (DynamicObject)sourceClaimBillMap.get(info.getLong("id"));
                if (CasHelper.isNotEmpty((Object)dbClaimBill)) {
                    RecClaimHelper.getClaimCoreInfo((DynamicObject)info, (DynamicObject)dbClaimBill, claimCoreInfoList);
                } else {
                    DynamicObject sourceclaim = (DynamicObject)sourceClaimBillMap.get(sourceclaimid);
                    RecClaimHelper.getClaimCoreInfo((DynamicObject)info, (DynamicObject)sourceclaim, claimCoreInfoList);
                }
            } else {
                dbClaimBill = (DynamicObject)sourceClaimBillMap.get(info.getLong("id"));
                if (CasHelper.isNotEmpty((Object)dbClaimBill)) {
                    RecClaimHelper.getClaimCoreInfo((DynamicObject)info, (DynamicObject)dbClaimBill, claimCoreInfoList);
                } else {
                    RecClaimHelper.getClaimCoreInfo((DynamicObject)info, null, claimCoreInfoList);
                }
            }
            String businessType = info.getString("businesstype");
            if (Arrays.asList(BusinessTypeEnum.PAY.getName(), BusinessTypeEnum.PAY.getValue()).contains(businessType)) {
                this.fillPayType(info);
                continue;
            }
            this.fillRecType(info);
        }
        RecClaimHelper.writeBackAmt(claimCoreInfoList);
    }

    private void fillPayType(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] paymentBillType = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,biztype,ispartpayment", (QFilter[])new QFilter[]{qFilter});
        DynamicObject payType = bill.getDynamicObject("paytype");
        HashSet<DynamicObject> entryPayTypes = new HashSet<DynamicObject>(4);
        DynamicObjectCollection payEntries = bill.getDynamicObjectCollection("payentity");
        boolean isHaveNull = false;
        if (payEntries != null && payEntries.size() > 0) {
            for (DynamicObject entry : payEntries) {
                DynamicObject ePaymentType = entry.getDynamicObject("e_paymenttype");
                if (ePaymentType != null) {
                    entryPayTypes.add(ePaymentType);
                    continue;
                }
                isHaveNull = true;
            }
        }
        if (entryPayTypes != null && entryPayTypes.size() > 0) {
            if (entryPayTypes.size() > 1) {
                bill.set("multipaymenttype", (Object)Boolean.TRUE);
                if (payType == null) {
                    bill.set("paytype", (Object)paymentBillType[0]);
                }
            } else {
                if (isHaveNull) {
                    return;
                }
                DynamicObject ePaymentType = (DynamicObject)entryPayTypes.iterator().next();
                if (payType == null) {
                    bill.set("multipaymenttype", (Object)Boolean.FALSE);
                    bill.set("paytype", (Object)ePaymentType);
                } else {
                    bill.set("multipaymenttype", (Object)Boolean.FALSE);
                }
            }
        } else if (payType != null && payEntries != null && payEntries.size() > 0) {
            bill.set("multipaymenttype", (Object)Boolean.FALSE);
            for (DynamicObject entry : payEntries) {
                entry.set("e_paymenttype", (Object)payType);
            }
        }
    }

    private void fillRecType(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] receivingBillType = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,biztype,ispartreceivable", (QFilter[])new QFilter[]{qFilter});
        DynamicObject recType = bill.getDynamicObject("recpaytype");
        HashSet<DynamicObject> entryRecTypes = new HashSet<DynamicObject>(4);
        DynamicObjectCollection recEntries = bill.getDynamicObjectCollection("entryentity");
        boolean isHaveNull = false;
        if (recEntries != null && recEntries.size() > 0) {
            for (DynamicObject entry : recEntries) {
                DynamicObject eReceivingType = entry.getDynamicObject("e_receivingtype");
                if (eReceivingType != null) {
                    entryRecTypes.add(eReceivingType);
                    continue;
                }
                isHaveNull = true;
            }
        }
        if (entryRecTypes != null && entryRecTypes.size() > 0) {
            if (entryRecTypes.size() > 1) {
                bill.set("multireceivingtype", (Object)Boolean.TRUE);
                if (recType == null) {
                    bill.set("recpaytype", (Object)receivingBillType[0]);
                }
            } else {
                if (isHaveNull) {
                    return;
                }
                DynamicObject eReceivingType = (DynamicObject)entryRecTypes.iterator().next();
                if (recType == null) {
                    bill.set("multireceivingtype", (Object)Boolean.FALSE);
                    bill.set("recpaytype", (Object)eReceivingType);
                } else {
                    bill.set("multireceivingtype", (Object)Boolean.FALSE);
                }
            }
        } else if (recType != null && recEntries != null && recEntries.size() > 0) {
            bill.set("multireceivingtype", (Object)Boolean.FALSE);
            for (DynamicObject entry : recEntries) {
                entry.set("e_receivingtype", (Object)recType);
            }
        }
    }
}

