/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.recclaim.RecClaimCancelAccountValidator;

public class RecClaimCancelAccountOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List lst = args.getFieldKeys();
        lst.add("billno");
        lst.add("claimstatus");
        lst.add("confirmuser");
        lst.add("entryentity");
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"entryentity"));
        lst.add("isunclaim");
        lst.add("payamount");
        lst.add("businesstype");
        lst.add("datasource");
        lst.add("sourceid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new RecClaimCancelAccountValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObject[] payBills;
            BigDecimal payAmount;
            DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billstatus,sourcebilltype,sourcebillid,hotaccount,isunclaim", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", info.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue())});
            boolean isAllunclaim = true;
            if (recBills != null) {
                for (DynamicObject recBill : recBills) {
                    if (!recBill.getBoolean("isunclaim") || !HotAccountEnum.HOTEDBILL.getValue().equals(recBill.getString("hotaccount"))) {
                        isAllunclaim = false;
                        break;
                    }
                    isAllunclaim = true;
                }
            }
            if (recBills != null && !isAllunclaim && recBills.length > 0) {
                for (DynamicObject recBill : recBills) {
                    if (info.getBoolean("isunclaim") && HotAccountEnum.HOTEDBILL.getValue().equals(recBill.getString("hotaccount"))) continue;
                    OperateOption opOption = OperateOption.create();
                    opOption.setVariableValue("byclaim", "true");
                    OperationResult operationResult = OperateServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Object[]{recBill.getPkValue()}, (OperateOption)opOption);
                    if (operationResult.isSuccess() || operationResult.getAllErrorOrValidateInfo().size() <= 0) continue;
                    throw new KDBizException(((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                }
            } else {
                info.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                info.set("confirmuser", null);
                DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
                entrys.forEach(entry -> entry.set("e_handlestatus", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
                QFilter qFilter = new QFilter("claimno", "=", (Object)info.getString("billno"));
                Object[] colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimstatus,handlestatus", (QFilter[])new QFilter[]{qFilter});
                if (EmptyUtil.isNoEmpty((Object[])colls)) {
                    Object[] objectArray = colls;
                    int n = objectArray.length;
                    for (int operationResult = 0; operationResult < n; ++operationResult) {
                        Object coll = objectArray[operationResult];
                        coll.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                        coll.set("handlestatus", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue());
                    }
                    SaveServiceHelper.save((DynamicObject[])colls);
                }
            }
            if ((payAmount = info.getBigDecimal("payamount")).compareTo(BigDecimal.ZERO) == 0) continue;
            for (DynamicObject payBill : payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", info.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())})) {
                OperateOption opOption = OperateOption.create();
                opOption.setVariableValue("byclaim", "true");
                OperationResult operationResult = OperateServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, (OperateOption)opOption);
                if (operationResult.isSuccess() || operationResult.getAllErrorOrValidateInfo().size() <= 0) continue;
                throw new KDBizException(((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            String businessType = info.getString("businesstype");
            String dataSource = info.getString("datasource");
            if (!"elerecticket".equals(dataSource) || !"recticket".equals(businessType)) continue;
            long sourceId = info.getLong("sourceid");
            DynamicObject eleRecBill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"cdm_electronic_sign_deal");
            eleRecBill.set("signopinion", (Object)"");
            eleRecBill.set("username", (Object)"");
            eleRecBill.set("remark", (Object)"");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{eleRecBill});
        }
    }
}

