/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.receipt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;

public class SyncReceiptStatusOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SyncReceiptStatusOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        String entityTypeName = this.billEntityType.getName();
        args.getFieldKeys().add("billno");
        args.getFieldKeys().add("billstatus");
        args.getFieldKeys().add("isgetreceipt");
        if (SourceBillTypeEnum.PAYBILL.getValue().equals(entityTypeName) || SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(entityTypeName)) {
            args.getFieldKeys().add("payeracctbank");
            args.getFieldKeys().add("bankcheckentity.ebankcheckflag");
        } else if (SourceBillTypeEnum.RECBILL.getValue().equals(entityTypeName)) {
            args.getFieldKeys().add("accountbank");
            args.getFieldKeys().add("bankcheckentity.ebankcheckflag");
        } else if (SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(entityTypeName) || SourceBillTypeEnum.TRANSUPBILL.getValue().equals(entityTypeName)) {
            args.getFieldKeys().add("entrys.bankcheckflag");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String entityTypeName = this.billEntityType.getName();
        Set<DynamicObject> bills = Arrays.stream(args.getDataEntities()).collect(Collectors.toSet());
        if ((bills = bills.stream().filter(bill -> {
            String billStatus = bill.getString("billstatus");
            return BillStatusEnum.PAY.getValue().equals(billStatus) || BillStatusEnum.RENOTE.getValue().equals(billStatus) || BillStatusEnum.REFUND.getValue().equals(billStatus);
        }).collect(Collectors.toSet())).isEmpty()) {
            logger.warn("SyncReceiptStatusOp billStatus validate fail.");
            return;
        }
        Set pkSet = bills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        Object result = null;
        try {
            logger.info(entityTypeName + " start beiQueryReceiptService rowCount: " + pkSet.size());
            long startTimeMillis = System.currentTimeMillis();
            result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"findReceiptIdByids", (Object[])new Object[]{entityTypeName, pkSet});
            logger.info("beiQueryReceiptService successful. costTime: " + (System.currentTimeMillis() - startTimeMillis));
        }
        catch (Exception e) {
            logger.error("beiQueryReceiptService Exception: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u7535\u5b50\u56de\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SyncReceiptStatusOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        HashSet<Long> getReceiptSet = new HashSet<Long>(32);
        if (result != null) {
            Map receiptMap = (Map)result;
            for (Long id : pkSet) {
                if (!receiptMap.containsKey(id) || ((Set)receiptMap.get(id)).isEmpty()) continue;
                getReceiptSet.add(id);
            }
        }
        if (!getReceiptSet.isEmpty()) {
            bills = bills.stream().filter(bill -> getReceiptSet.contains(bill.getLong("id"))).collect(Collectors.toSet());
            String billNoString = bills.stream().map(bill -> bill.getString("billno")).collect(Collectors.toSet()).toString();
            logger.info("getReceiptSet: " + billNoString);
            for (DynamicObject bill2 : bills) {
                bill2.set("isgetreceipt", (Object)true);
            }
            SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
        } else {
            logger.warn("SyncReceiptStatusOp getReceiptSet is empty.");
        }
    }
}

