/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recinit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.OrgHelper;

public abstract class AbstractRecIniUnreachableImport
extends BatchImportPlugin {
    protected static final Integer COLLECTION_CAPACITY = 16;

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ArrayList<ImportBillData> data = new ArrayList<ImportBillData>(rowdatas.size());
        data.addAll(rowdatas);
        HashMap<String, Object> unReachData = new HashMap<String, Object>(data.size());
        HashMap<String, Set<Integer>> dataRowIndex = new HashMap<String, Set<Integer>>(COLLECTION_CAPACITY);
        HashSet<String> orgNumbers = new HashSet<String>(COLLECTION_CAPACITY);
        HashMap<String, DynamicObject> numberRelateOrg = new HashMap<String, DynamicObject>(COLLECTION_CAPACITY);
        HashSet<String> bankNumbers = new HashSet<String>(COLLECTION_CAPACITY);
        Map<String, DynamicObject> numberRelateBank = null;
        HashSet<String> currencyNumbers = new HashSet<String>(COLLECTION_CAPACITY);
        Map<String, DynamicObject> numberRelateCurrency = null;
        HashMap<Long, DynamicObject> orgRelateCshInit = new HashMap<Long, DynamicObject>(COLLECTION_CAPACITY);
        HashMap<Long, DynamicObject> orgRelateRecInit = new HashMap<Long, DynamicObject>(COLLECTION_CAPACITY);
        for (ImportBillData billData : data) {
            HashSet<Integer> index;
            JSONObject jsonData = billData.getData();
            Map org = (Map)jsonData.get((Object)"org");
            String orgNum = (String)org.get("number");
            orgNumbers.add(orgNum);
            ArrayList entries = (ArrayList)unReachData.get(orgNum);
            if (entries == null) {
                entries = new ArrayList(COLLECTION_CAPACITY);
                unReachData.put(orgNum, entries);
            }
            if ((index = (HashSet<Integer>)dataRowIndex.get(orgNum)) == null) {
                index = new HashSet<Integer>(COLLECTION_CAPACITY);
                dataRowIndex.put(orgNum, index);
            }
            index.add(billData.getDataIndex() + 1);
            JSONArray entryEntities = jsonData.getJSONArray("entryentity");
            for (int i = 0; i < entryEntities.size(); ++i) {
                BigDecimal creditAmount;
                BigDecimal debitAmount;
                HashMap<String, Object> entryValues = new HashMap<String, Object>(8);
                JSONObject entryEntity = entryEntities.getJSONObject(i);
                Date bizDate = entryEntity.getDate("bizdate");
                entryValues.put("bizdate", bizDate);
                String description = entryEntity.getString("description");
                entryValues.put("description", description);
                JSONObject jsonCurrency = entryEntity.getJSONObject("currency");
                String currencyNumber = jsonCurrency.getString("number");
                entryValues.put("currencyNumber", currencyNumber);
                currencyNumbers.add(currencyNumber);
                if (this.businessType().equals("bank")) {
                    debitAmount = entryEntity.getBigDecimal("debitamount");
                    entryValues.put("debitamount", debitAmount);
                    creditAmount = entryEntity.getBigDecimal("creditamount");
                    entryValues.put("creditamount", creditAmount);
                    Date bookDate = entryEntity.getDate("bookdate");
                    entryValues.put("bookdate", bookDate);
                } else if (this.businessType().equals("company")) {
                    debitAmount = entryEntity.getBigDecimal("conpanydebitamount");
                    entryValues.put("debitamount", debitAmount);
                    creditAmount = entryEntity.getBigDecimal("companycreditamount");
                    entryValues.put("creditamount", creditAmount);
                }
                JSONObject jsonBank = entryEntity.getJSONObject("accountbank");
                String bankNumber = jsonBank.getString("bankaccountnumber");
                entryValues.put("bankNumber", bankNumber);
                bankNumbers.add(bankNumber);
                entries.add(entryValues);
            }
        }
        this.addOrgRelate(orgNumbers, numberRelateOrg, orgRelateCshInit, orgRelateRecInit);
        numberRelateBank = this.addNumberRelateBank(bankNumbers);
        numberRelateCurrency = this.addNumberRelateCurrency(currencyNumbers);
        SaveParameter saveParameter = new SaveParameter();
        saveParameter.setUnReachData(unReachData);
        saveParameter.setNumberRelateOrg(numberRelateOrg);
        saveParameter.setNumberRelateBank(numberRelateBank);
        saveParameter.setNumberRelateCurrency(numberRelateCurrency);
        saveParameter.setOrgRelateRecInit(orgRelateRecInit);
        saveParameter.setDataRowIndex(dataRowIndex);
        saveParameter.setLogger(logger);
        List<String> successOrgNumber = this.saveData(saveParameter);
        return this.resultApi(successOrgNumber);
    }

    private void addOrgRelate(Set<String> orgNumbers, Map<String, DynamicObject> numberRelateOrg, Map<Long, DynamicObject> orgRelateCshInit, Map<Long, DynamicObject> orgRelateRecInit) {
        if (orgNumbers.size() == 0) {
            return;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter numFilter = new QFilter("number", "in", orgNumbers);
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, numFilter});
        for (DynamicObject dynamicObject : orgs.values()) {
            numberRelateOrg.put(dynamicObject.getString("number"), dynamicObject);
        }
        QFilter qOrg = new QFilter("org", "in", orgs.keySet());
        Map cashInit = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])new QFilter[]{qOrg});
        for (DynamicObject dynamicObject : cashInit.values()) {
            orgRelateCshInit.put(dynamicObject.getDynamicObject("org").getLong("id"), dynamicObject);
        }
        QFilter qIsFinish = new QFilter("isfinishinit", "=", (Object)false);
        Map recInit = BusinessDataServiceHelper.loadFromCache((String)"cas_rec_init", (QFilter[])new QFilter[]{qOrg, qIsFinish});
        for (DynamicObject dynamicObject : recInit.values()) {
            orgRelateRecInit.put(dynamicObject.getDynamicObject("org").getLong("id"), dynamicObject);
        }
    }

    private Map<String, DynamicObject> addNumberRelateBank(Set<String> bankNumbers) {
        HashMap<String, DynamicObject> numberRelateBank = new HashMap<String, DynamicObject>(COLLECTION_CAPACITY);
        if (bankNumbers.size() == 0) {
            return numberRelateBank;
        }
        QFilter[] filters = new QFilter[]{new QFilter("bankaccountnumber", "in", bankNumbers)};
        Map accounts = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])filters);
        for (DynamicObject account : accounts.values()) {
            numberRelateBank.put(account.getString("bankaccountnumber"), account);
        }
        return numberRelateBank;
    }

    private Map<String, DynamicObject> addNumberRelateCurrency(Set<String> currencyNumbers) {
        HashMap<String, DynamicObject> numberRelateCurrency = new HashMap<String, DynamicObject>(COLLECTION_CAPACITY);
        if (currencyNumbers.size() == 0) {
            return numberRelateCurrency;
        }
        Map currencies = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "in", currencyNumbers)});
        for (DynamicObject dynamicObject : currencies.values()) {
            numberRelateCurrency.put(dynamicObject.getString("number"), dynamicObject);
        }
        return numberRelateCurrency;
    }

    private ApiResult resultApi(List<String> successOrgNumber) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        ArrayList resultData = new ArrayList(COLLECTION_CAPACITY);
        for (int i = 0; i < successOrgNumber.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>(COLLECTION_CAPACITY);
            map.put("success", true);
            map.put("dindex", 0);
            map.put("number", UUID.randomUUID().toString());
            resultData.add(map);
        }
        result.setData(resultData);
        return result;
    }

    protected BigDecimal getExchangeRate(long orgId, long currencyId, Date date) {
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
        if (baseCurrency == null) {
            return null;
        }
        BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)currencyId, (Long)baseCurrency.getLong("id"), (Long)orgId, (Date)date);
        return exchangeRate;
    }

    protected void addErrMessage(String message) {
        throw new KDBizException(message);
    }

    protected abstract String businessType();

    protected abstract List<String> saveData(SaveParameter var1);

    static class SaveParameter {
        private Map<String, Object> unReachData;
        private Map<String, DynamicObject> numberRelateOrg;
        private Map<String, DynamicObject> numberRelateBank;
        private Map<String, DynamicObject> numberRelateCurrency;
        private Map<Long, DynamicObject> orgRelateRecInit;
        private Map<String, Set<Integer>> dataRowIndex;
        private ImportLogger logger;

        SaveParameter() {
        }

        public Map<String, Object> getUnReachData() {
            return this.unReachData;
        }

        public void setUnReachData(Map<String, Object> unReachData) {
            this.unReachData = unReachData;
        }

        public Map<String, DynamicObject> getNumberRelateOrg() {
            return this.numberRelateOrg;
        }

        public void setNumberRelateOrg(Map<String, DynamicObject> numberRelateOrg) {
            this.numberRelateOrg = numberRelateOrg;
        }

        public Map<String, DynamicObject> getNumberRelateBank() {
            return this.numberRelateBank;
        }

        public void setNumberRelateBank(Map<String, DynamicObject> numberRelateBank) {
            this.numberRelateBank = numberRelateBank;
        }

        public Map<String, DynamicObject> getNumberRelateCurrency() {
            return this.numberRelateCurrency;
        }

        public void setNumberRelateCurrency(Map<String, DynamicObject> numberRelateCurrency) {
            this.numberRelateCurrency = numberRelateCurrency;
        }

        public Map<Long, DynamicObject> getOrgRelateRecInit() {
            return this.orgRelateRecInit;
        }

        public void setOrgRelateRecInit(Map<Long, DynamicObject> orgRelateRecInit) {
            this.orgRelateRecInit = orgRelateRecInit;
        }

        public Map<String, Set<Integer>> getDataRowIndex() {
            return this.dataRowIndex;
        }

        public void setDataRowIndex(Map<String, Set<Integer>> dataRowIndex) {
            this.dataRowIndex = dataRowIndex;
        }

        public ImportLogger getLogger() {
            return this.logger;
        }

        public void setLogger(ImportLogger logger) {
            this.logger = logger;
        }
    }
}

