/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recinit;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.validator.recinit.RecInitAntiInitValidator;

public class RecInitAntiInitOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RecInitAntiInitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("isfinishinit");
        fields.add("initperiod");
        fields.add("entrybank");
        fields.add(String.join((CharSequence)".", "entrybank", "bank_accountbank"));
        fields.add(String.join((CharSequence)".", "entrybank", "bank_currency"));
        fields.add(String.join((CharSequence)".", "entrybank", "bank_statementbalance"));
        fields.add(String.join((CharSequence)".", "entrybank", "bank_statementdebit"));
        fields.add(String.join((CharSequence)".", "entrybank", "bank_statementcredit"));
        fields.add("currentperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        RecInitAntiInitValidator v = new RecInitAntiInitValidator();
        v.setEntityKey("cas_rec_init");
        e.addValidator((AbstractValidator)v);
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] recInits;
        super.beginOperationTransaction(e);
        for (DynamicObject recInit : recInits = e.getDataEntities()) {
            recInit.set("isfinishinit", (Object)"0");
            DynamicObject org = recInit.getDynamicObject("org");
            DynamicObject initPeriod = recInit.getDynamicObject("initperiod");
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            QFilter periodFilter = new QFilter("period", "=", initPeriod.getPkValue());
            QFilter typeFilter = new QFilter("type", "=", (Object)"3");
            DeleteServiceHelper.delete((String)"cas_journalbalance", (QFilter[])new QFilter[]{orgFilter, periodFilter, typeFilter});
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("bizdate", "=", (Object)DateUtils.getLastDay((Date)initPeriod.getDate("begindate"), (int)1))};
            DeleteServiceHelper.delete((String)"cas_balanceadjust", (QFilter[])filters);
            this.updateOutDatas(org.getPkValue(), initPeriod.getPkValue(), "cas_bankstatement");
            this.updateOutDatas(org.getPkValue(), initPeriod.getPkValue(), "cas_bankjournal");
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])e.getDataEntities(), (OperateType)OperateType.DELETE);
    }

    private void updateOutDatas(Object orgId, Object initPeriodId, String outDataEntity) {
        QFilter recperiodFilter;
        QFilter oFilter = new QFilter("org", "=", orgId);
        QFilter pFilter = new QFilter("period", "=", (Object)0L);
        DynamicObject[] outDatas = BusinessDataServiceHelper.load((String)outDataEntity, (String)"id,isvalid", (QFilter[])new QFilter[]{oFilter, pFilter, recperiodFilter = new QFilter("recinitperiod", "=", initPeriodId)});
        if (outDatas != null && outDatas.length > 0) {
            for (DynamicObject outData : outDatas) {
                outData.set("isvalid", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])outDatas);
        }
    }
}

