/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recpayrule;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.recpayrule.IMatchDataTransfer;
import kd.fi.cas.business.recpayrule.IRecPayRuleService;
import kd.fi.cas.business.recpayrule.PersistenceInvocationHandler;
import kd.fi.cas.business.recpayrule.impl.RecPayRuleServiceImpl;
import kd.fi.cas.business.recpayrule.transfer.EnableMatchDataTransfer;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.validator.recpayrule.RecPayRuleEnableValidator;

public class RecPayRuleEnableOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(RecPayRuleEnableOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        RecPayRuleEnableValidator validator = new RecPayRuleEnableValidator();
        validator.setEntityKey("cas_recpayrule");
        e.addValidator((AbstractValidator)validator);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztype");
        fieldKeys.add("enable");
        fieldKeys.add("org_entry");
        fieldKeys.add("e_datafilter_TAG");
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recpayrule", (String)"entryentity"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recpayrule", (String)"org_entry"));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] recPayRules;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject recPayRule : recPayRules = e.getDataEntities()) {
            try {
                ThreadPools.executeOnceIncludeRequestContext((String)"asynRecPayRuleWriteByOrgAndType", () -> {
                    RecPayRuleServiceImpl recPayRuleService = new RecPayRuleServiceImpl((IMatchDataTransfer)new EnableMatchDataTransfer(recPayRule));
                    PersistenceInvocationHandler handler = new PersistenceInvocationHandler((IRecPayRuleService)recPayRuleService);
                    IRecPayRuleService saveServiceProxy = (IRecPayRuleService)Proxy.newProxyInstance(recPayRuleService.getClass().getClassLoader(), recPayRuleService.getClass().getInterfaces(), (InvocationHandler)handler);
                    saveServiceProxy.match();
                });
            }
            catch (Exception e1) {
                LOGGER.info(e1.getMessage());
            }
        }
    }
}

