/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recpayrule;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.business.recpayrule.IMatchDataTransfer;
import kd.fi.cas.business.recpayrule.IRecPayRuleService;
import kd.fi.cas.business.recpayrule.PersistenceInvocationHandler;
import kd.fi.cas.business.recpayrule.impl.RecPayRuleServiceImpl;
import kd.fi.cas.business.recpayrule.transfer.SaveMatchDataTransfer;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.init.MatchingRuleSynDataHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.recpayrule.RecPayRuleSaveValidator;

public class RecPayRuleSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(RecPayRuleSaveOp.class);
    private Map<Object, Set<Object>> idOrgSetMap;
    private Map<Object, Set<String>> oldRuleNameMap;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztype");
        fieldKeys.add("enable");
        fieldKeys.add("org_entry");
        fieldKeys.add("name");
        fieldKeys.add("e_datafilter_TAG");
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recpayrule", (String)"org_entry"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recpayrule", (String)"entryentity"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (EmptyUtil.isNoEmpty((Object[])dataEntities)) {
            List recpayIdList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            Object[] recpayDBList = BusinessDataServiceHelper.load((String)"cas_recpayrule", (String)"id,entryentity.e_rulesname,org_entry.u_org", (QFilter[])new QFilter[]{new QFilter("id", "in", recpayIdList)});
            if (!EmptyUtil.isEmpty((Object[])recpayDBList)) {
                this.idOrgSetMap = Arrays.stream(recpayDBList).filter(v -> RecPayRuleHelper.getEntryOrg((DynamicObject)v) != null).collect(Collectors.toMap(DataEntityBase::getPkValue, RecPayRuleHelper::getEntryOrg, (e1, e2) -> e1));
                this.oldRuleNameMap = Arrays.stream(recpayDBList).filter(v -> RecPayRuleHelper.getEntryRuleName((DynamicObject)v) != null).collect(Collectors.toMap(DataEntityBase::getPkValue, RecPayRuleHelper::getEntryRuleName, (e1, e2) -> e1));
            } else {
                this.idOrgSetMap = Arrays.stream(dataEntities).filter(v -> RecPayRuleHelper.getEntryOrg((DynamicObject)v) != null).collect(Collectors.toMap(DataEntityBase::getPkValue, RecPayRuleHelper::getEntryOrg, (e1, e2) -> e1));
                this.oldRuleNameMap = Arrays.stream(dataEntities).filter(v -> RecPayRuleHelper.getEntryRuleName((DynamicObject)v) != null).collect(Collectors.toMap(DataEntityBase::getPkValue, RecPayRuleHelper::getEntryRuleName, (e1, e2) -> e1));
            }
            for (Object dynamicObject : dataEntities) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectCollection)) continue;
                dynamicObjectCollection.forEach(dy -> {
                    String savenotifi;
                    String notifische = dy.getString("e_notifische");
                    if (EmptyUtil.isNotEmpty((String)notifische)) {
                        dy.set("e_notifische", (Object)(notifische.length() > 1024 ? notifische.substring(0, 1024) : notifische));
                    }
                    if (EmptyUtil.isNotEmpty((String)(savenotifi = dy.getString("e_savenotifi_TAG")))) {
                        dy.set("e_savenotifi", (Object)(savenotifi.length() > 255 ? savenotifi.substring(0, 255) : savenotifi));
                    }
                    this.setPropertyValue((DynamicObject)dy, "e_paymenttypestr", "e_paymenttype", 0);
                    this.setPropertyValue((DynamicObject)dy, "e_payeetypestr", "e_payeetype", "");
                    this.setPropertyValue((DynamicObject)dy, "e_recerstr", "e_recerid", 0);
                    this.setPropertyValue((DynamicObject)dy, "e_recerstr", "e_recer", "");
                    this.setPropertyValue((DynamicObject)dy, "e_receivingtypestr", "e_receivingtype", 0);
                    this.setPropertyValue((DynamicObject)dy, "e_payertypestr", "e_payertype", "");
                    this.setPropertyValue((DynamicObject)dy, "e_payerstr", "e_payerid", 0);
                    this.setPropertyValue((DynamicObject)dy, "e_payerstr", "e_payer", "");
                    this.setPropertyValue((DynamicObject)dy, "e_fundflowitemstr", "e_fundflowitem", 0);
                });
            }
        }
    }

    private void setPropertyValue(DynamicObject entry, String filedStr, String filedDB, Object newValue) {
        if (EmptyUtil.isEmpty((String)entry.getString(filedStr))) {
            entry.set(filedDB, newValue);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        RecPayRuleSaveValidator validator = new RecPayRuleSaveValidator();
        validator.setEntityKey("cas_recpayrule");
        e.addValidator((AbstractValidator)validator);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] recPayRules;
        super.afterExecuteOperationTransaction(e);
        try {
            this.asynMatchingRuleDataUpdate();
        }
        catch (Exception e1) {
            LOGGER.error((Throwable)e1);
        }
        for (DynamicObject recPayRule : recPayRules = e.getDataEntities()) {
            try {
                ThreadPools.executeOnceIncludeRequestContext((String)"asynRecPayRuleWriteByOrgAndType", () -> {
                    Set<Object> oldRuleOrg = null;
                    if (this.idOrgSetMap != null) {
                        oldRuleOrg = this.idOrgSetMap.get(recPayRule.getPkValue());
                    }
                    Set<String> oldRuleName = null;
                    if (this.oldRuleNameMap != null) {
                        oldRuleName = this.oldRuleNameMap.get(recPayRule.getPkValue());
                    }
                    RecPayRuleServiceImpl recPayRuleService = new RecPayRuleServiceImpl((IMatchDataTransfer)new SaveMatchDataTransfer(recPayRule, oldRuleOrg, oldRuleName));
                    PersistenceInvocationHandler handler = new PersistenceInvocationHandler((IRecPayRuleService)recPayRuleService);
                    IRecPayRuleService saveServiceProxy = (IRecPayRuleService)Proxy.newProxyInstance(recPayRuleService.getClass().getClassLoader(), recPayRuleService.getClass().getInterfaces(), (InvocationHandler)handler);
                    saveServiceProxy.match();
                });
            }
            catch (Exception e1) {
                LOGGER.error((Throwable)e1);
            }
        }
    }

    private void asynMatchingRuleDataUpdate() {
        ThreadPools.executeOnceIncludeRequestContext((String)"asynMatchingRuleDataUpdate", MatchingRuleSynDataHelper::syncMatchingRule);
    }
}

