/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.repairdata;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasBotpHelper;

public class RepairBotpRelationOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RepairBotpRelationOp.class);
    private static String[] payBillNos = new String[]{"PV-202008-010285", "PV-202008-009869", "PV-202008-009267", "PV-202009-010558"};
    private static String[] erpBillNos = new String[]{"DG2020085482", "DG2020085207", "DG2020084699", "DG2020095651"};
    private static String[] agentBillNos = new String[]{"PR-202008-003691", "PR-202008-003664", "PR-202008-003930", "PR-202008-003665", "PR-202008-003931", "PR-202008-003633", "PR-202008-003628", "PR-202008-003737", "PR-202008-003925", "PR-202008-003692", "PR-202008-003934", "PR-202008-003663", "PR-202008-003632", "PR-202008-003631", "PR-202008-003675", "PR-202008-003670", "PR-202008-003674", "PR-202008-003669", "PR-202008-003673", "PR-202008-003926", "PR-202008-003928", "PR-202008-003688"};
    private static String[] erBillNos = new String[]{"BX2020082427", "BX2020082299", "BX2020082459", "BX2020082298", "BX2020082613", "BX2020082268", "BX2020082300", "BX2020072198", "BX2020082473", "BX2020082386", "BX2020082444", "BX2020082308", "BX2020082271", "BX2020082270", "BX2020082349", "BX2020082293", "BX2020082311", "BX2020082351", "BX2020082307", "BX2020082482", "BX2020082501", "BX2020082388"};

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)payBillNos)});
        DynamicObject[] erpBills = BusinessDataServiceHelper.load((String)"er_publicreimbursebill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)erpBillNos)});
        Map<String, Object> payBillMap = Stream.of(payBills).collect(Collectors.toMap(o -> o.getString("billno"), DataEntityBase::getPkValue));
        Map<String, Object> erpBillMap = Stream.of(erpBills).collect(Collectors.toMap(o -> o.getString("billno"), DataEntityBase::getPkValue));
        for (int i = 0; i < payBillNos.length; ++i) {
            try {
                Object payBillPk = payBillMap.get(payBillNos[i]);
                Object erBillPk = erpBillMap.get(erpBillNos[i]);
                if (payBillPk == null || erBillPk == null) continue;
                DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBillPk, (String)"cas_paybill");
                DynamicObject erBill = BusinessDataServiceHelper.loadSingle((Object)erBillPk, (String)"er_publicreimbursebill");
                if (payBill == null || erBill == null) continue;
                CasBotpHelper.saveRelation((DynamicObject)erBill, (DynamicObject)payBill);
                continue;
            }
            catch (Exception exc) {
                logger.error("RepairBotpRelationOp relpay error :", (Throwable)exc);
            }
        }
        DynamicObject[] agentBills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)agentBillNos)});
        DynamicObject[] erBills = BusinessDataServiceHelper.load((String)"er_dailyreimbursebill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)erBillNos)});
        Map<String, Object> agentBillMap = Stream.of(agentBills).collect(Collectors.toMap(o -> o.getString("billno"), DataEntityBase::getPkValue));
        Map<String, Object> erBillMap = Stream.of(erBills).collect(Collectors.toMap(o -> o.getString("billno"), DataEntityBase::getPkValue));
        for (int i = 0; i < agentBillNos.length; ++i) {
            try {
                Object agentBillPk = agentBillMap.get(agentBillNos[i]);
                Object erBillPk = erBillMap.get(erBillNos[i]);
                if (agentBillPk == null || erBillPk == null) continue;
                DynamicObject agentBill = BusinessDataServiceHelper.loadSingle((Object)agentBillPk, (String)"cas_agentpaybill");
                DynamicObject erBill = BusinessDataServiceHelper.loadSingle((Object)erBillPk, (String)"er_dailyreimbursebill");
                if (agentBill == null || erBill == null) continue;
                CasBotpHelper.saveRelation((DynamicObject)erBill, (DynamicObject)agentBill);
                continue;
            }
            catch (Exception exc) {
                logger.error("RepairBotpRelationOp relagent error :", (Throwable)exc);
            }
        }
    }
}

