/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.smartmatch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.IOperationService;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.MatchRelEnum;
import kd.fi.cas.enums.ResultSaveAutoMatchStatus;
import kd.fi.cas.param.AutoMatchInfoParam;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.smartmatch.CancelMatchOpValidator;

public class CancelMatchOp
extends AbstractOperationServicePlugIn
implements IOperationService {
    private static final Log LOGGER = LogFactory.getLog(CancelMatchOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        CancelMatchOpValidator validator = new CancelMatchOpValidator();
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (this.getOption().containsVariable("selectedRowsData")) {
            String selectedRowsDatas = this.getOption().getVariableValue("selectedRowsData");
            String[] selectedPkDatas = selectedRowsDatas.split(",");
            this.doCancelMatchOp(selectedPkDatas);
        }
    }

    private void doCancelMatchOp(String[] selectedPkDatas) {
        ArrayList<Long> pkList = new ArrayList<Long>(selectedPkDatas.length);
        for (int i = 0; i < selectedPkDatas.length; ++i) {
            pkList.add(Long.valueOf(selectedPkDatas[i]));
        }
        Object[] resultObjArr = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_autocalresult"));
        if (!EmptyUtil.isEmpty((Object[])resultObjArr) && resultObjArr.length > 0) {
            ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(resultObjArr.length);
            ArrayList<Long> detailIds = new ArrayList<Long>(resultObjArr.length);
            HashMap recedbillMap = new HashMap();
            HashMap srcBills = new HashMap(0);
            String sourceEntityKey = "bei_intelrec";
            String billFlag = "cas_recbill";
            block5: for (Object resultObj : resultObjArr) {
                Long ruleEntryId = resultObj.getLong("ruleentry");
                DynamicObject smartmatchDO = resultObj.getDynamicObject("smartmatch");
                String direction = smartmatchDO.getString("direction");
                sourceEntityKey = direction.equals("rec") ? "bei_intelrec" : "bei_intelpay";
                DynamicObjectCollection smartMatchEntrys = smartmatchDO.getDynamicObjectCollection("entryentity");
                String matchRel = MatchRelEnum.ONE_TO_ONE.getValue();
                for (DynamicObject smartEntry : smartMatchEntrys) {
                    if (smartEntry.getLong("id") != ruleEntryId.longValue()) continue;
                    matchRel = smartEntry.getString("e_matchrel");
                }
                resultObj.set("matchstatus", (Object)ResultSaveAutoMatchStatus.UNMATCH.getValue());
                DynamicObjectCollection entryentity = resultObj.getDynamicObjectCollection("entryentity");
                MatchRelEnum matchRelEnum = MatchRelEnum.getByValue((String)matchRel);
                switch (matchRelEnum) {
                    case ONE_TO_ONE: 
                    case ONE_TO_MANY: {
                        DynamicObject detailEntry = (DynamicObject)entryentity.get(0);
                        Long detailId = detailEntry.getLong("billid");
                        detailIds.add(detailId);
                        for (int i = 1; i < entryentity.size(); ++i) {
                            DynamicObject bizEntry = (DynamicObject)entryentity.get(i);
                            AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByValue((String)bizEntry.getString("record"));
                            billFlag = billTypeEnum.getBillEntity();
                            String traceType = billTypeEnum == AutoMatchBillTypeEnum.EXCHANGEBILL ? ("rec".equals(direction) ? "buy" : "sell") : "";
                            Long bizBillid = bizEntry.getLong("billid");
                            HashSet<Long> recedbillIdSet = new HashSet<Long>();
                            if (recedbillMap.containsKey(billFlag)) {
                                recedbillIdSet.addAll((Collection)recedbillMap.get(billFlag));
                            }
                            recedbillIdSet.add(bizBillid);
                            recedbillMap.put(billFlag, recedbillIdSet);
                            BigDecimal amt = EmptyUtil.isEmpty((BigDecimal)bizEntry.getBigDecimal("payamount")) ? bizEntry.getBigDecimal("amount") : bizEntry.getBigDecimal("payamount");
                            tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntityKey, detailEntry.getString("num"), Long.valueOf(detailEntry.getLong("billid")), billFlag, bizEntry.getString("num"), Long.valueOf(bizEntry.getLong("billid")), Long.valueOf(bizEntry.getLong("billentryid")), Long.valueOf(resultObj.getLong("currency.id")), traceType, amt, null, null, resultObj.getString("number"), direction, "", MatchRelEnum.ONE_TO_MANY.getValue()));
                        }
                        continue block5;
                    }
                    case MANY_TO_ONE: {
                        Long detailId;
                        DynamicObject detailEntry;
                        DynamicObject bizEntry = entryentity.stream().filter(o -> !"0".equals(o.getString("record"))).findFirst().get();
                        AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByValue((String)bizEntry.getString("record"));
                        billFlag = billTypeEnum.getBillEntity();
                        String traceType = billTypeEnum == AutoMatchBillTypeEnum.EXCHANGEBILL ? ("rec".equals(direction) ? "buy" : "sell") : "";
                        Long bizBillid = bizEntry.getLong("billid");
                        HashSet<Long> recedbillIdSet = new HashSet<Long>();
                        if (recedbillMap.containsKey(billFlag)) {
                            recedbillIdSet.addAll((Collection)recedbillMap.get(billFlag));
                        }
                        recedbillIdSet.add(bizBillid);
                        recedbillMap.put(billFlag, recedbillIdSet);
                        for (int i = 0; i < entryentity.size(); ++i) {
                            detailEntry = (DynamicObject)entryentity.get(i);
                            detailId = detailEntry.getLong("billid");
                            detailIds.add(detailId);
                            String record = detailEntry.getString("record");
                            String amountProp = "rec".equals(direction) ? "amount" : "payamount";
                            if (!"0".equals(record)) continue;
                            tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntityKey, detailEntry.getString("num"), Long.valueOf(detailEntry.getLong("billid")), billFlag, bizEntry.getString("num"), Long.valueOf(bizEntry.getLong("billid")), Long.valueOf(bizEntry.getLong("billentryid")), Long.valueOf(resultObj.getLong("currency.id")), traceType, detailEntry.getBigDecimal(amountProp), null, null, resultObj.getString("number"), direction, "", MatchRelEnum.MANY_TO_ONE.getValue()));
                        }
                        continue block5;
                    }
                }
            }
            recedbillMap.entrySet().forEach(entry -> {
                Map result = BFTrackerServiceHelper.findSourceBills((String)((String)entry.getKey()), (Long[])((HashSet)entry.getValue()).toArray(new Long[0]));
                HandLinkBillHelper.mergerMap((Map)srcBills, (Map)result, null);
            });
            Set entitySet = Stream.of("bei_transdetail_cas", "bei_intelpay", "bei_intelrec").collect(Collectors.toSet());
            Set srcBillIds = srcBills.entrySet().stream().filter(o -> entitySet.contains(o.getKey())).map(o -> (HashSet)o.getValue()).flatMap(o -> o.stream()).collect(Collectors.toSet());
            srcBillIds.removeAll(detailIds);
            HashMap<Long, Object> recedbillidMap = new HashMap<Long, Object>();
            if (srcBillIds.size() > 0) {
                String collect = AutoMatchHelper.getMatchFieldKeys().stream().collect(Collectors.joining(","));
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)("id,bizdate," + collect), (QFilter[])new QFilter("id", "in", srcBillIds).and("ishandlink", "=", (Object)"1").toArray());
                if (query.size() > 0) {
                    recedbillidMap.putAll(query.stream().collect(Collectors.groupingBy(k -> k.getLong("recedbillentry.e_recedbillid"), Collectors.mapping(o -> o.getDate("bizdate"), Collectors.reducing(null, (a, b) -> a.compareTo((Date)b) > 0 ? a : b)))));
                }
            }
            DynamicObjectCollection transactionDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,currency,bankcheckflag,bizdate", (QFilter[])new QFilter("id", "in", detailIds).toArray());
            Map<Long, DynamicObject> transactionDetailsMap = transactionDetails.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            tAutoMatchInfoList.forEach(item -> {
                DynamicObject tradeObj = (DynamicObject)transactionDetailsMap.get(item.getTransDetailId());
                item.setCurrency(Long.valueOf(tradeObj.getLong("currency")));
                item.setBankCheckFlag(tradeObj.getString("bankcheckflag"));
                item.setBizDate((Date)recedbillidMap.get(item.getRecedBillId()));
            });
            LOGGER.info("\u904d\u5386\u4ea4\u6613\u660e\u7ec6\u66f4\u65b0\u5bf9\u5e94\u5b57\u6bb5\u503c\u7ed3\u675f");
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, null, null, false, null});
            CasFlowConfirmLogHelper.saveMatchLog(tAutoMatchInfoList, (String)"cancelmatch");
            SaveServiceHelper.save((DynamicObject[])resultObjArr);
        }
    }
}

