/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class AccountFreezeSubmitValidator
extends AbstractValidator {
    public void validate() {
        PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
        Set<Long> bankIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(e -> EmptyUtil.isNoEmpty((Long)e.getDataEntity().getLong("payeracctbank.id"))).map(e -> e.getDataEntity().getLong("payeracctbank.id")).collect(Collectors.toSet());
        Map<Long, String> closedBankAcctMap = this.queryClosedBankAccts(bankIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject org = info.getDynamicObject("org");
            if (CasHelper.isEmpty((Object)org)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivingBillSaveValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            Long cashId = info.getLong("payeracctcash.id");
            Long bankId = info.getLong("payeracctbank.id");
            try {
                String status;
                if (!EmptyUtil.isNoEmpty((Long)bankId) || !EmptyUtil.isNoEmpty((String)(status = closedBankAcctMap.get(bankId)))) continue;
                if (BankAcctStatusEnum.FREEZE.getValue().equals(status)) {
                    throw new KDBizException(paymentErrorCode.ACCOUNT_CANNOT_SUBMIT(), new Object[0]);
                }
                if (!BankAcctStatusEnum.CLOSED.getValue().equals(status)) continue;
                throw new KDBizException(paymentErrorCode.ACCOUNT_CLOSED_SUBMIT(), new Object[0]);
            }
            catch (Exception e2) {
                this.addMessage(dataEntity, e2.getMessage(), ErrorLevel.Error);
                this.getValidateResult().setSuccess(false);
            }
        }
    }

    private Map<Long, String> queryClosedBankAccts(Set<Long> bankIds) {
        if (EmptyUtil.isEmpty(bankIds)) {
            return new HashMap<Long, String>(0);
        }
        List<String> status = Arrays.asList(BankAcctStatusEnum.FREEZE.getValue(), BankAcctStatusEnum.CLOSED.getValue());
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", bankIds), new QFilter("acctstatus", "in", status)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"am_accountbank", (String)"id,acctstatus", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)collection)) {
            return collection.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getString("acctstatus")));
        }
        return new HashMap<Long, String>(0);
    }
}

