/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.business.opservice.factory.AgentPayBillFactory;
import kd.fi.cas.business.opservice.helper.AgentPayServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.ProceedsTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.PaymentQueryHelper;
import kd.fi.cas.util.CheckUtils;

public class AgentPayBillSaveOrSubmitValidator
extends AbstractValidator {
    public void validate() {
        List payerAccIdList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getDynamicObject("payeracctbank")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
        List cashAccIdList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getDynamicObject("accountcash")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
        Map currencyPksMap = AccountBankHelper.getBatchCurrencyPks((String)"bd_accountbanks", payerAccIdList);
        Map cashCurrencyPksMap = AccountBankHelper.getBatchCurrencyPks((String)"cas_accountcash", cashAccIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String message;
            String checkEmpty;
            DynamicObjectCollection entry;
            DynamicObject info = dataEntity.getDataEntity();
            AgentPayBillHelper.decodeAmount((DynamicObject)info);
            if (!info.getString("billstatus").equals(BillStatusEnum.SAVE.getValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"AgentPayErrorCode_0", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if ((entry = info.getDynamicObjectCollection("entry")).isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_0", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            List selector = AgentPayServiceHelper.getSelector();
            if (info.get("delegorg") != null) {
                DynamicObject org = info.getDynamicObject("org");
                if (org != null && info.getDynamicObject("delegorg").getPkValue().equals(org.getPkValue())) {
                    info.set("delegorg", null);
                } else {
                    if (info.getDynamicObject("settletype") != null || info.getDynamicObject("payeracctbank") != null || info.getDynamicObject("accountcash") != null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u59d4\u6258\u5176\u4ed6\u516c\u53f8\u4ed8\u6b3e\uff0c\u4e0d\u9700\u8981\u4ed8\u6b3e\u8d26\u6237\u53ca\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"AgentPaySubmitImpl_7", (String)"fi-cas-business", (Object[])new Object[0]));
                    }
                    selector.remove("payeracctbank");
                    selector.remove("accountcash");
                }
            } else if (BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                selector.remove("payeracctbank");
                CheckUtils.setPropMustInput((DynamicObject)info, (boolean)true, (String[])new String[]{"accountcash"});
                if (!DynamicObjectHelper.isEmpty((DynamicObject)info, (String)"payeracctbank")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u662f\u73b0\u91d1\uff0c\u94f6\u884c\u8d26\u6237\u5e94\u8be5\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
                }
            } else {
                selector.remove("accountcash");
                CheckUtils.setPropMustInput((DynamicObject)info, (boolean)true, (String[])new String[]{"payeracctbank"});
                if (!DynamicObjectHelper.isEmpty((DynamicObject)info, (String)"accountcash")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u975e\u73b0\u91d1\uff0c\u73b0\u91d1\u8d26\u6237\u5e94\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_2", (String)"fi-cas-business", (Object[])new Object[0]));
                }
            }
            boolean isCheckOurAcc = PaymentQueryHelper.isCheckOurAccBySysParam((DynamicObject)info.getDynamicObject("org"), (DynamicObject)info.getDynamicObject("settletype"));
            if (!isCheckOurAcc) {
                selector.remove("payeracctbank");
            }
            if (info.getBoolean("isencryption")) {
                selector.remove("e_localamt");
            }
            if ((checkEmpty = CheckUtils.checkEmpty((DynamicObject)info, (List)selector)).length() > 0) {
                this.addErrorMessage(dataEntity, checkEmpty);
            }
            for (int i = 0; i < entry.size(); ++i) {
                BigDecimal amount = ((DynamicObject)entry.get(i)).getBigDecimal("e_amount");
                if (BigDecimal.ZERO.compareTo(amount) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"AgentPaySubmitImpl_3", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
            }
            if (info.getBigDecimal("exchangerate").doubleValue() <= 0.0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c47\u7387\u4e0d\u80fd\u4e3a0\u6216\u8d1f\u6570\u3002", (String)"AgentPayErrorCode_12", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            Collection supportedCurrencies = null;
            DynamicObject accountCash = info.getDynamicObject("accountcash");
            DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
            if (payerAcctBank != null) {
                supportedCurrencies = (Collection)currencyPksMap.get(payerAcctBank.getPkValue());
            } else if (accountCash != null) {
                supportedCurrencies = (Collection)cashCurrencyPksMap.get(accountCash.getPkValue());
            }
            Long payCurId = info.getLong("currency.id");
            if (info.getBoolean("isdiffcur")) {
                payCurId = info.getLong("dpcurrency.id");
            }
            if (supportedCurrencies != null && !supportedCurrencies.contains(payCurId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u5f53\u524d\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AgentPaySubmitImpl_4", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            AgentPayBillFactory.getSaveService().validate(info);
            DynamicObject pt = info.getDynamicObject("paymenttype");
            String biztype = Optional.ofNullable(pt).map(value -> value.getString("biztype")).orElse(null);
            if (StringUtils.isEmpty((CharSequence)biztype)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CheckUtils_6", (String)"fi-cas-common", (Object[])new Object[0]));
            }
            if (info.getBoolean("isencryption")) {
                message = CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_encryptamount");
                if (null != message) {
                    this.addErrorMessage(dataEntity, message);
                }
            } else {
                message = CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_amount");
                if (null != message) {
                    this.addErrorMessage(dataEntity, message);
                }
            }
            boolean isCrossPay = info.getBoolean("iscrosspay");
            DynamicObject crossTranType = info.getDynamicObject("crosstrantype");
            if (isCrossPay && crossTranType == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8de8\u5883\u652f\u4ed8\u65f6\uff0c\u4ea4\u6613\u7c7b\u578b\u5fc5\u586b\u3002", (String)"AgentPaySubmitImpl_14", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            for (int i = 0; i < entry.size(); ++i) {
                if (!PaymentChannelEnum.BEI.getValue().equals(info.getString("paymentchannel"))) continue;
                if (!isCrossPay || isCrossPay && !crossTranType.getString("number").equals("BOCHK05")) {
                    if (StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeeacctbank")) && !BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    }
                    if (!StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeebankname")) || BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_6", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (!crossTranType.getString("number").equals("BOCHK05")) continue;
                String term = ((DynamicObject)entry.get(i)).getString("paymentterm");
                if (ProceedsTypeEnum.ZERO.getValue().equals(term)) {
                    if (StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeeacctbank")) && !BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    }
                    if (StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeebankname")) && !BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_6", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    }
                } else if (ProceedsTypeEnum.ONE.getValue().equals(term) && CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("paymentfps"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4ebaFPS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_9", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                } else if (ProceedsTypeEnum.TWO.getValue().equals(term)) {
                    if (CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("mobile"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_11", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    } else if (CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("paymentareacode"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4eba\u5730\u533a\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_10", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    }
                } else if (ProceedsTypeEnum.three.getValue().equals(term) && CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("recemail"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u65b9\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_12", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                }
                if (!((DynamicObject)entry.get(i)).getBoolean("inforpayment") || !CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("informrecemail"))) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u8bf7\u586b\u5199\u901a\u77e5\u6536\u6b3e\u4eba\u90ae\u7bb1\uff1b\u5982\u4e0d\u9700\u901a\u77e5\u6536\u6b3e\u4eba\uff0c\u8bf7\u5173\u95ed\u901a\u77e5\u6536\u6b3e\u4eba\u6309\u94ae\u3002", (String)"AgentPaySubmitImpl_13", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

