/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class BankStatementValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!this.verifyOrg(dataEntity, bill) || !this.verifyAccountBank(dataEntity, bill) || !this.verifyCurrency(dataEntity, bill) || !this.verifyAmount(dataEntity, bill)) continue;
            this.verifyBizDate(dataEntity, bill);
        }
    }

    private boolean verifyOrg(ExtendedDataEntity dataEntity, DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (Objects.isNull(org)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"BankStatementValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!SystemStatusCtrolHelper.isFinishInit((long)((Long)org.getPkValue()))) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u7ed3\u675f\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BankStatementValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue()));
            return false;
        }
        return true;
    }

    private boolean verifyAccountBank(ExtendedDataEntity dataEntity, DynamicObject bill) {
        DynamicObject accountBank = bill.getDynamicObject("accountbank");
        if (Objects.isNull(accountBank)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u94f6\u884c\u8d26\u6237\u3002", (String)"BankStatementValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject org = bill.getDynamicObject("org");
        long orgID = org.getLong("id");
        DynamicObject accountBankOrg = accountBank.getDynamicObject("org");
        if (accountBankOrg != null) {
            long accountBankOrgID = accountBankOrg.getLong("id");
            if (!Objects.equals(orgID, accountBankOrgID)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%1s\u201d\u7684\u5f00\u6237\u7ec4\u7ec7\u4e0d\u662f\u201c%2s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BankStatementValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), accountBank.getString("name"), org.getString("name")));
                return false;
            }
        }
        return true;
    }

    private boolean verifyCurrency(ExtendedDataEntity dataEntity, DynamicObject bill) {
        long accountBankID;
        Set currencyIDSet;
        DynamicObject currency = bill.getDynamicObject("currency");
        if (Objects.isNull(currency)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankStatementValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            return false;
        }
        long imptCurrencyID = currency.getLong("id");
        String imptCurrencyName = currency.getString("name");
        DynamicObject accountBank = bill.getDynamicObject("accountbank");
        String accountBankName = accountBank.getString("name");
        boolean isMulCurrency = accountBank.getBoolean("ismulcurrency");
        DynamicObject defaultCurrency = accountBank.getDynamicObject("defaultcurrency");
        if (!isMulCurrency && Objects.nonNull(defaultCurrency)) {
            long defCurrencyID = defaultCurrency.getLong("id");
            if (Objects.equals(imptCurrencyID, defCurrencyID)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%1s\u201d\u53ea\u652f\u6301\u5355\u5e01\u79cd\u201c%2s\u201d\uff0c\u4e0d\u652f\u6301\u5e01\u79cd\u201c%3s\u201d\u3002", (String)"BankStatementValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), accountBankName, defaultCurrency.getString("name"), imptCurrencyName));
                return false;
            }
        }
        if (!(currencyIDSet = AccountBankHelper.getCurrencyPks((long)(accountBankID = accountBank.getLong("id")))).contains(imptCurrencyID)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%1s\u201d\u4e0d\u652f\u6301\u5e01\u79cd\u201c%2s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BankStatementValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]), accountBankName, imptCurrencyName));
            return false;
        }
        return true;
    }

    private boolean verifyAmount(ExtendedDataEntity dataEntity, DynamicObject bill) {
        boolean isDebit = Objects.nonNull(bill.get("debitamount"));
        boolean isCredit = Objects.nonNull(bill.get("creditamount"));
        if (isDebit && isCredit) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u3001\u8d37\u65b9\u91d1\u989d\u53ea\u80fd\u4e00\u4e2a\u4e0d\u4e3a0\u3002", (String)"BankStatementValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (isDebit) {
            bill.set("direction", (Object)"1");
            return true;
        }
        if (isCredit) {
            bill.set("direction", (Object)"2");
            return true;
        }
        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u3001\u8d37\u65b9\u91d1\u989d\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u4e3a0\u3002", (String)"BankStatementValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        return false;
    }

    private boolean verifyBizDate(ExtendedDataEntity dataEntity, DynamicObject bill) {
        Date periodStartDate;
        DynamicObject org = bill.getDynamicObject("org");
        long orgID = org.getLong("id");
        DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)orgID);
        if (Objects.isNull(currentPeriod)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u6ca1\u6709\u8bbe\u7f6e\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BankStatementValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]), org.getString("name")));
            return false;
        }
        Date imptBizDate = bill.getDate("bizdate");
        if (imptBizDate.before(periodStartDate = currentPeriod.getDate("begindate"))) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e3a\u201c%1$s\u201d\uff0c\u5bfc\u5165\u6570\u636e\u65e5\u671f\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"BankStatementValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]), format.format(periodStartDate), format.format(imptBizDate)));
            return false;
        }
        return true;
    }
}

