/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BankVcAdjustValidator
extends AbstractValidator {
    public void validate() {
        String endDateStr = this.getOption().getVariableValue("endDate", null);
        if (!StringUtils.isEmpty((CharSequence)endDateStr)) {
            Date endDate = DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            StringBuilder bStatus = new StringBuilder();
            StringBuilder cStatus = new StringBuilder();
            StringBuilder nopermObj = new StringBuilder();
            String orgBeginDateStr = this.getOption().getVariableValue("orgBeginDate", "{}");
            Map orgBeginDate = (Map)JSON.parseObject((String)orgBeginDateStr, Map.class);
            HashSet<Long> notShowCoverConfirmMsgIdSet = new HashSet<Long>(16);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String balBillStatus;
                DynamicObject bankVc = dataEntity.getDataEntity();
                DynamicObject acctBank = bankVc.getDynamicObject("accountbank");
                String acctStatus = acctBank.getString("acctstatus");
                if (BankAcctStatusEnum.CLOSED.getValue().equals(acctStatus)) {
                    Date closeDate = acctBank.getDate("closedate");
                    Long currTermBeginDate = (Long)orgBeginDate.get(String.valueOf(bankVc.getDynamicObject("org").getLong("id")));
                    if (closeDate == null) {
                        if (this.dataEntities.length == 1) {
                            this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u8be5\u8d26\u6237\u5df2\u9500\u6237\u4f46\u662f\u9500\u6237\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\uff1f", (String)"BankVcAdjustValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), acctBank.getString("number"), bankVc.getDynamicObject("currency").getString("name")));
                        } else {
                            notShowCoverConfirmMsgIdSet.add((Long)bankVc.getPkValue());
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u8be5\u8d26\u6237\u5df2\u9500\u6237\u4e14\u9500\u6237\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u9500\u6237\u65e5\u671f\u3002", (String)"BankVcAdjustValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), acctBank.getString("number"), bankVc.getDynamicObject("currency").getString("name")));
                        }
                    } else {
                        String message;
                        if (currTermBeginDate == null) {
                            message = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u201d%1$s\u201d\u7684\u5f53\u524d\u671f\u95f4\uff0c\u5426\u5219\u65e0\u6cd5\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVcAdjustValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("org").getString("name"));
                            this.addMessage(dataEntity, message);
                            continue;
                        }
                        if (closeDate.getTime() < currTermBeginDate) {
                            message = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u8be5\u8d26\u6237\u5df2\u9500\u6237\uff0c\u4e0d\u53ef\u751f\u6210\u9500\u6237\u65e5\u671f\u6240\u5728\u671f\u95f4\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVcAdjustValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), acctBank.getString("number"), bankVc.getDynamicObject("currency").getString("name"));
                            this.addMessage(dataEntity, message);
                            continue;
                        }
                    }
                }
                if (!AccountBankHelper.isAuthorityAccount((DynamicObject)bankVc.getDynamicObject("accountbank"), (DynamicObject)bankVc.getDynamicObject("org"))) {
                    String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u662f\u8d26\u6237\u201c%2$s\u201d\u7684\u7ba1\u7406\u6743\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8d26\u6237\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BankVcAdjustValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("org").getString("name"), bankVc.getDynamicObject("accountbank").getString("bankaccountnumber"));
                    this.addMessage(dataEntity, message);
                }
                if (null == (balBillStatus = this.getBalanceBillStatus(dataEntity, bankVc, endDate))) continue;
                if (balBillStatus.length() > 1 && !notShowCoverConfirmMsgIdSet.contains((Long)bankVc.getPkValue())) {
                    this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a\u672c\u6b21\u64cd\u4f5c\u4f1a\u8986\u76d6%3$s\u751f\u6210\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BankVcAdjustValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("accountbank").getString("number"), bankVc.getDynamicObject("currency").getString("name"), balBillStatus));
                    continue;
                }
                if ("B".equals(balBillStatus)) {
                    bStatus.append(bankVc.getString("id")).append(',');
                }
                if (!"C".equals(balBillStatus)) continue;
                cStatus.append(bankVc.getString("id")).append(',');
            }
            this.getOption().setVariableValue("bStatus", bStatus.toString());
            this.getOption().setVariableValue("cStatus", cStatus.toString());
            this.getOption().setVariableValue("nopermObj", nopermObj.toString());
        }
    }

    public String getBalanceBillStatus(ExtendedDataEntity dataEntity, DynamicObject bankVc, Date endDate) {
        DynamicObject org = bankVc.getDynamicObject("org");
        DynamicObject initObj = PeriodHelper.getCasInitInfo((long)org.getLong("id"));
        boolean isFinished = initObj.getBoolean("isfinishinit");
        DynamicObject startperiod = initObj.getDynamicObject("startperiod");
        if (!isFinished && (startperiod == null || EmptyUtil.isEmpty((DynamicObject)startperiod))) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u3002", (String)"BankVcAdjustValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankVc.getDynamicObject("org").getString("name")));
            return null;
        }
        QFilter filter = this.getBaseQfilter(bankVc).and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)startperiod.getDate("begindate"), (boolean)true)).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,billstatus,bizdate", (QFilter[])new QFilter[]{filter});
        if (balances == null || balances.length == 0) {
            return "";
        }
        if (endDate.after(DateUtils.getCurrentDate())) {
            endDate = DateUtils.getCurrentDate();
        }
        for (DynamicObject balance : balances) {
            if ("A".equals(balance.getString("billstatus"))) {
                return DateUtils.formatString((Date)balance.getDate("bizdate"), (String)"yyyy-MM-dd");
            }
            if (!DateUtils.isSameDay((Date)balance.getDate("bizdate"), (Date)endDate)) continue;
            return balance.getString("billstatus");
        }
        DateUtils.getLastDay((Date)new Date(), (int)1);
        return "";
    }

    private QFilter getBaseQfilter(DynamicObject bankVc) {
        DynamicObject org = bankVc.getDynamicObject("org");
        DynamicObject accountBank = bankVc.getDynamicObject("accountbank");
        DynamicObject currency = bankVc.getDynamicObject("currency");
        QFilter filter = new QFilter("bankaccount", "=", (Object)accountBank.getLong("id"));
        filter = filter.and("org", "=", org.getPkValue()).and("currency", "=", (Object)currency.getLong("id"));
        return filter;
    }
}

