/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.cas.business.ca.VerifySignHelper;
import kd.fi.cas.business.errorcode.BillErrorCode;

public class CaValidator
extends AbstractValidator {
    public void validate() {
        BillErrorCode billErrorCode = new BillErrorCode();
        HashSet<Long> orgIds = new HashSet<Long>(this.dataEntities.length);
        String entityKey = "";
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            entityKey = info.getDataEntityType().getName();
            long orgId = info.getDynamicObject("org").getLong("id");
            orgIds.add(orgId);
        }
        for (Long orgId : orgIds) {
            if (!VerifySignHelper.isConfigCA((String)entityKey, (Long)orgId)) {
                throw new KDBizException(billErrorCode.NO_SIGN_CONFIG(), new Object[0]);
            }
            if (VerifySignHelper.isVerifySignOpreate((String)entityKey, (String)"commitbe", (Long)orgId)) continue;
            throw new KDBizException(billErrorCode.COMMITBE_MUSTBE_VERIFYSIGN_OP(), new Object[0]);
        }
    }
}

