/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class CashMgtInitSaveValidator
extends AbstractValidator {
    public void validate() {
        Set cashMgtInitIds = Arrays.stream(this.dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(cashMgtInitIds)) {
            return;
        }
        DynamicObjectCollection cashMgtInits = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id, isfinishinit", (QFilter[])new QFilter("id", "in", cashMgtInitIds).toArray());
        Map<Long, Boolean> cashMgtInitMap = cashMgtInits.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getBoolean("isfinishinit")));
        for (ExtendedDataEntity dataEntity2 : this.dataEntities) {
            long cashMgtInitId = dataEntity2.getDataEntity().getLong("id");
            if (!cashMgtInitMap.containsKey(cashMgtInitId) || !cashMgtInitMap.get(cashMgtInitId).booleanValue()) continue;
            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u51fa\u7eb3\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"CashMgtInitSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

