/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class CrossBorderPayLicenseValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(CrossBorderPayLicenseValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("iscrosspay");
        preparePropertys.add("paymentchannel");
        preparePropertys.add("paymentidentify");
        return preparePropertys;
    }

    public void validate() {
        logger.info("CrossBorderPayLicenseValidator validate start");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            if (!info.getBoolean("iscrosspay") || !"bei".equals(info.getString("paymentchannel"))) continue;
            Boolean isUserInGroup = LicenseServiceHelper.checkPerformGroup((String)"PRO_MAP").getHasLicense();
            if ("cas_agentpaybill".equals(info.getDynamicObjectType().getName())) {
                if (isUserInGroup.booleanValue()) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u83b7\u53d6\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u7684\u4ea7\u54c1\u8bb8\u53ef\u3002", (String)"PaymentDynamicValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject paymentIdentify = info.getDynamicObject("paymentidentify");
            if (!EmptyUtil.isNoEmpty((DynamicObject)paymentIdentify) || !"0".equals(paymentIdentify.getString("type")) || isUserInGroup.booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u83b7\u53d6\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u7684\u4ea7\u54c1\u8bb8\u53ef\u3002", (String)"PaymentDynamicValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        logger.info("CrossBorderPayLicenseValidator validate end");
    }
}

