/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import kd.sdk.fi.cas.extpoint.closeperiod.ICheckArchiveBillTypeInterface;

public class FinalCheckOutAntiCheckValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(FinalCheckOutAntiCheckValidator.class);

    public void validate() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject prevPeriod;
            DynamicObject finalcheckout = this.dataEntities[i].getDataEntity();
            int checkoutStatus = finalcheckout.getInt("checkoutstatus");
            if (checkoutStatus == 2) {
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"{0}\u6b63\u5728\u7ed3\u8d26\uff0c\u8bf7\u7b49\u5f85\u7ed3\u8d26\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"FinalCheckOutAntiCheckValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{finalcheckout.getDynamicObject("org").getString("name")});
                this.addMessage(this.dataEntities[i], msg, ErrorLevel.FatalError);
                this.getValidateResult().setSuccess(false);
                continue;
            }
            if (checkoutStatus == 3) {
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"{0}{1}\u4e0d\u662f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26\u3002", (String)"FinalCheckOutAntiCheckValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{finalcheckout.getDynamicObject("org").getString("name"), finalcheckout.getDynamicObject("period").getString("name")});
                this.addMessage(this.dataEntities[i], msg, ErrorLevel.FatalError);
                this.getValidateResult().setSuccess(false);
                continue;
            }
            long orgId = finalcheckout.getDynamicObject("org").getLong("id");
            String orgName = finalcheckout.getDynamicObject("org").getString("name");
            DynamicObject cashMgtInit = SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
            long startPeriodId = cashMgtInit.getDynamicObject("startperiod").getLong("id");
            DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
            long currentPeriodId = currentPeriod.getLong("id");
            if (currentPeriodId == startPeriodId) {
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"{0}\u5f53\u524d\u671f\u95f4\u548c\u542f\u7528\u671f\u95f4\u4e00\u81f4\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26\u3002", (String)"FinalCheckOutAntiCheckValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{finalcheckout.getDynamicObject("org").getString("name")});
                this.addMessage(this.dataEntities[i], msg, ErrorLevel.FatalError);
                this.getValidateResult().setSuccess(false);
            }
            if (null == (prevPeriod = PeriodHelper.getPrevPeriodNotAdjustPeriod((long)currentPeriod.getLong("id")))) continue;
            Date date = prevPeriod.getDate("enddate");
            boolean exsitLargerDateBalance = QueryServiceHelper.exists((String)"cas_balanceadjust", (QFilter[])new QFilter[]{new QFilter("org", "=", cashMgtInit.getDynamicObject("org").getPkValue()), new QFilter("bizdate", ">", (Object)DateUtils.getDataFormat((Date)date, (boolean)false))});
            if (!exsitLargerDateBalance) continue;
            String dateStr = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
            String error = String.format(ResManager.loadKDString((String)"%1$s\u53cd\u7ed3\u8d26\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728%2$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u5c06%3$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FinalCheckOutAntiCheckValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgName, dateStr, dateStr);
            this.addMessage(this.dataEntities[i], error, ErrorLevel.FatalError);
            this.getValidateResult().setSuccess(false);
        }
        this.checkArchive(this.dataEntities);
    }

    private void checkArchive(ExtendedDataEntity[] dataEntities) {
        HashMap<String, String> billTypeMap = new HashMap<String, String>(16);
        billTypeMap.put("cas_bankjournalformrpt", ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26", (String)"FinalCheckOutAntiCheckValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        billTypeMap.put("cas_cashjournalformrpt", ResManager.loadKDString((String)"\u73b0\u91d1\u65e5\u8bb0\u8d26", (String)"FinalCheckOutAntiCheckValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        try {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject finalCheckOut = dataEntity.getDataEntity();
                JSONObject data = new JSONObject();
                JSONArray orgArr = new JSONArray();
                orgArr.add((Object)finalCheckOut.getDynamicObject("org").getString("number"));
                JSONArray periodIdArr = new JSONArray();
                DynamicObject prevPeriod = PeriodHelper.getPrevPeriodNotAdjustPeriod((long)finalCheckOut.getDynamicObject("period").getLong("id"));
                if (EmptyUtil.isEmpty((DynamicObject)prevPeriod)) continue;
                periodIdArr.add((Object)prevPeriod.getString("number"));
                JSONArray billtypeNumberArr = new JSONArray();
                billtypeNumberArr.add((Object)"cas_bankjournalformrpt");
                billtypeNumberArr.add((Object)"cas_cashjournalformrpt");
                billtypeNumberArr.addAll(this.getExtBillTypes());
                data.put("org_number", (Object)orgArr);
                data.put("filingperiod_number", (Object)periodIdArr);
                data.put("billtype_number", (Object)billtypeNumberArr);
                data.put("type", (Object)"1");
                HashMap<String, Object> requestData = new HashMap<String, Object>();
                requestData.put("data", data);
                requestData.put("pageSize", 100);
                requestData.put("pageNo", 1);
                logger.info("\u65e5\u8bb0\u8d26\u5f52\u6863\u67e5\u8be2request\uff1a{}", requestData);
                OpenApiResult result = OpenApiSdkUtil.invoke((String)"/v2/aef/aef_acelre/getList", requestData);
                if (result.isStatus()) {
                    ApiQueryResult queryResult = (ApiQueryResult)result.getData();
                    List rows = queryResult.getRows();
                    HashSet<String> billNos = new HashSet<String>(rows.size());
                    for (Map row : rows) {
                        String billNo = (String)row.get("billtype_number");
                        String billTypeNo = (String)billTypeMap.get(billNo);
                        if (EmptyUtil.isEmpty((String)billTypeNo)) {
                            billTypeNo = FinalCheckOutAntiCheckValidator.getDesignFormName(billNo);
                        }
                        billNos.add(billTypeNo);
                    }
                    if (billNos.isEmpty()) continue;
                    String billTypesStr = String.join((CharSequence)ResManager.loadKDString((String)"\u3001", (String)"FinalCheckOutAntiCheckValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]), billNos);
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s%2$s\u7684%3$s\u5df2\u5f52\u6863\uff0c\u8bf7\u5b8c\u6210\u53cd\u5f52\u6863\u540e\u518d\u8fdb\u884c\u53cd\u7ed3\u8d26\u64cd\u4f5c\u3002", (String)"FinalCheckOutAntiCheckValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), finalCheckOut.getString("org.name"), prevPeriod.getString("name"), billTypesStr), ErrorLevel.FatalError);
                    continue;
                }
                String msg = result.getMessage();
                if (msg.contains(ResManager.loadKDString((String)"\u65e0\u67e5\u8be2\u6743\u9650", (String)"FinalCheckOutAntiCheckValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]))) {
                    logger.info("\u65e0\u5f52\u6863\u8bb0\u5f55\u67e5\u8be2\u6743\u9650...");
                    return;
                }
                this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
            }
        }
        catch (Exception e) {
            logger.error("\u53cd\u7ed3\u8d26\u6821\u9a8c\u65e5\u8bb0\u8d26\u5f52\u6863\u8c03\u7528openAPI\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private static String getDesignFormName(String formId) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        return formMeta.getName().getLocaleValue();
    }

    private List<String> getExtBillTypes() {
        PluginProxy pluginProxy = PluginProxy.create(ICheckArchiveBillTypeInterface.class, (String)"kd.sdk.fi.cas.extpoint.closeperiod.ICheckArchiveBillTypeInterface");
        List resultList = pluginProxy.callReplace(p -> p.getOtherBillTypes());
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("\u671f\u672b\u7ed3\u8d26\u53cd\u5ba1\u6838\u6821\u9a8c\u65e5\u8bb0\u8d26\u5f52\u6863\uff0c\u6269\u5c55\u5355\u636e\u7c7b\u578b:" + resultList.get(0));
            return (List)resultList.get(0);
        }
        return Collections.EMPTY_LIST;
    }
}

