/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public class PayPushIfmCancelValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PayPushIfmCancelValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            String payStates;
            Object[] recBills;
            DynamicObject info = data.getDataEntity();
            DynamicObject paymentType = info.getDynamicObject("paymenttype");
            DynamicObject innerAcct = info.getDynamicObject("inneraccount");
            String sourceBillType = info.getString("sourcebilltype");
            if ("fca_transupbill".equals(sourceBillType)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6e90\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u4e0a\u5212\u5904\u7406\u3002", (String)"PayPushIfmCancelValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.FUNDS_UP.getValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8d44\u91d1\u4e0a\u5212\u4e14\u5185\u90e8\u8d26\u6237\u8981\u6709\u503c\u3002", (String)"PayPushIfmCancelValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObject)innerAcct)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8d44\u91d1\u4e0a\u5212\u4e14\u5185\u90e8\u8d26\u6237\u8981\u6709\u503c\u3002", (String)"PayPushIfmCancelValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((Object[])(recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id ", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)info.getLong("id"))})))) {
                DynamicObject[] rec;
                List ids = Arrays.stream(recBills).map(e -> e.getLong("id")).collect(Collectors.toList());
                for (DynamicObject dynamicObject : rec = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"))) {
                    DynamicObject recType = dynamicObject.getDynamicObject("receivingtype");
                    if (recType != null && !"108".equals(recType.getString("biztype"))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u6536\u6b3e\u5355\u6536\u6b3e\u7c7b\u578b\u4e0d\u4e3a\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PayPushIfmCancelValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                    if ("A".equals(dynamicObject.getString("billstatus"))) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u6536\u6b3e\u5355\u5355\u636e\u72b6\u6001\u975e\u6682\u5b58\u3002", (String)"PayPushIfmCancelValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
            if ("bei".equals(info.getString("paymentchannel")) || !"D".equals(payStates = info.getString("billstatus"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u72b6\u6001\u5df2\u4ed8\u6b3e\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"PayPushInnerRecValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

