/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBillDeleteValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billno");
        preparePropertys.add("billstatus");
        preparePropertys.add("sourcetype");
        preparePropertys.add("sourcebilltype");
        preparePropertys.add("sourcebillid");
        preparePropertys.add("actpayamt");
        preparePropertys.add("draftbill");
        preparePropertys.add("applyorg");
        preparePropertys.add("hotaccount");
        preparePropertys.add("paymenttype");
        preparePropertys.add("paymentchannel");
        preparePropertys.add("bankpaystatus");
        preparePropertys.add("isvoucher");
        preparePropertys.add("e_payableAmt");
        preparePropertys.add("e_actAmt");
        preparePropertys.add("e_sourcebillid");
        preparePropertys.add("e_sourcebillentryid");
        preparePropertys.add("settletype");
        preparePropertys.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        preparePropertys.add("settletnumber");
        preparePropertys.add("feepay");
        preparePropertys.add("sourcebillnumber");
        preparePropertys.add("matchflag");
        preparePropertys.add("entry.e_corebilltype");
        preparePropertys.add("entry.e_corebillno");
        return preparePropertys;
    }

    public void validate() {
        Map param = this.getOption().getVariables();
        HashMap<String, ExtendedDataEntity> billNoMap = new HashMap<String, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object tmcValidator;
            String billStatus;
            DynamicObject info = dataEntity.getDataEntity();
            billNoMap.put(info.getString("billno"), dataEntity);
            String sourceBillType = info.getString("sourcebilltype");
            String hotAccount = info.getString("hotaccount");
            String matchFlag = info.getString("matchflag");
            if (!(AutoMatchFlagEnum.NONE.getValue().equals(matchFlag) || AutoMatchFlagEnum.NONEED.getValue().equals(matchFlag) || "true".equals(param.get("byclaim")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5339\u914d\u8fc7\u7684\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PaymentBillDeleteValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (HotAccountEnum.HOTBILL.getValue().equals(hotAccount) && info.getBoolean("isvoucher")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u3002", (String)"PaymentBillDeleteValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!("true".equals(param.get("byfca")) && ("fca_transupbill".equals(sourceBillType) || "fca_transdownbill".equals(sourceBillType)) || (billStatus = info.getString("billstatus")).equals(BillStatusEnum.SAVE.getValue()))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u5220\u9664\u3002", (String)"PaymentBillDeleteValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!CasHelper.isEmpty((Object)info.get("applyorg")) && "cas_paybill".equals(info.get("sourcebilltype"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7531\u59d4\u6258\u4ed8\u6b3e\u5355\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\uff0c\u7531\u59d4\u6258\u4ed8\u6b3e\u5355\u53d6\u6d88\u59d4\u6258\u4ed8\u6b3e\u5220\u9664\u3002", (String)"PaymentBillDeleteValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if ("cas_recbill".equals(sourceBillType) && !"1".equals(param.get("delrecpay"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7531\u6536\u6b3e\u5355\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"PaymentBillDeleteValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if ((tmcValidator = param.get("tmc_tm")) == null && ("tm_businessbill".equals(sourceBillType) || "tm_structdeposit".equals(sourceBillType) || "tm_rateswap".equals(sourceBillType) || "tm_bond_fix".equals(sourceBillType) || "tm_bond_float".equals(sourceBillType) || "tm_forex_options".equals(sourceBillType))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\u3002", (String)"PaymentBillDeleteValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            Object feepaydelete = param.get("feepaydelete");
            if (!info.getBoolean("feepay") || "1".equals(feepaydelete)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u662f\u4e1a\u52a1\u5355\u636e(\u5355\u636e\u7f16\u53f7%s)\u5173\u8054\u751f\u6210\u7684\u624b\u7eed\u8d39\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664\uff0c\u5982\u9700\u5220\u9664\u8bf7\u5728\u539f\u4e1a\u52a1\u5355\u636e\u4e0a\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u5904\u7406\u3002", (String)"PaymentBillDeleteValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), info.getString("sourcebillnumber")));
        }
        QFilter qFilter = new QFilter("entry.e_corebilltype", "=", (Object)"cas_paybill").and("entry.e_corebillno", "in", billNoMap.keySet()).and("billstatus", "=", (Object)"D");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryRecBill", (String)"cas_recbill", (String)"billno,entry.e_corebilltype,entry.e_corebillno", (QFilter[])new QFilter[]{qFilter}, null);){
            HashMap<String, HashSet<String>> billNoTag = new HashMap<String, HashSet<String>>(this.dataEntities.length);
            for (Row row : ds) {
                String key = row.getString("entry.e_corebillno");
                HashSet<String> tag = (HashSet<String>)billNoTag.get(key);
                if (EmptyUtil.isNoEmpty((Object)tag)) {
                    tag.add(row.getString("billno"));
                    continue;
                }
                tag = new HashSet<String>(4);
                tag.add(row.getString("billno"));
                billNoTag.put(key, tag);
            }
            for (Map.Entry one : billNoTag.entrySet()) {
                String payBillNo = (String)one.getKey();
                StringBuilder sb = new StringBuilder();
                for (String recBillNo : (Set)one.getValue()) {
                    sb.append(recBillNo).append("\u3001");
                }
                sb.deleteCharAt(sb.lastIndexOf("\u3001"));
                if (!EmptyUtil.isNoEmpty(billNoMap.get(payBillNo))) continue;
                this.addErrorMessage((ExtendedDataEntity)billNoMap.get(payBillNo), String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355%1$s\u5df2\u88ab\u6536\u6b3e\u5355%2$s\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8be5\u5355\u636e\uff0c\u5982\u6709\u9700\u6c42\u8bf7\u53d6\u6d88\u6536\u6b3e\u3002", (String)"PaymentBillDeleteValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBillNo, sb));
            }
        }
    }
}

