/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.consts.Constants;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class PaymentBillEndorseSaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PaymentBillEndorseSaveValidator.class);
    private static final List<String> SRCBILL_TYPES = Arrays.asList("cdm_drafttradebill", "cas_payapplybill");
    private static final List<String> TRADE_TYPES = Arrays.asList("payoff", "refund");

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("isbilldibs");
        preparePropertys.add("cas_draftinfo");
        preparePropertys.add("draftbillinfo");
        preparePropertys.add("transamount");
        return preparePropertys;
    }

    public void validate() {
        logger.info("PaymentBillEndorseSaveValidator validate start that");
        String isPushAndSave = this.getOption().getVariables().getOrDefault("ispushandsave", null);
        boolean endorseRecBill = this.getOption().containsVariable("endorseRecBill");
        String recBillId = endorseRecBill ? this.getOption().getVariableValue("endorseRecBill") : "";
        boolean ifBatchInput = this.getOption().containsVariable("batchinput");
        String sourceoperation = ifBatchInput ? this.getOption().getVariableValue("batchinput") : "";
        ArrayList<Long> draftIds = new ArrayList<Long>();
        List list = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObjectCollection)d.getDataEntity().getDynamicObjectCollection("draftbill"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(list)) {
            return;
        }
        HashMap<String, BigDecimal> paybillTrans = new HashMap<String, BigDecimal>();
        for (ExtendedDataEntity dataEntity : list) {
            DynamicObject casPayBill = dataEntity.getDataEntity();
            long casPayId = casPayBill.getLong("id");
            DynamicObjectCollection draftinfos = casPayBill.getDynamicObjectCollection("cas_draftinfo");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftinfos) || draftinfos.size() <= 0) continue;
            for (DynamicObject draftinfo : draftinfos) {
                DynamicObject draft = draftinfo.getDynamicObject("draftbillinfo");
                if (EmptyUtil.isEmpty((DynamicObject)draft)) continue;
                long id = draft.getLong("id");
                BigDecimal transamount = draftinfo.getBigDecimal("transamount");
                String keyStr = casPayId + "_" + id;
                paybillTrans.put(keyStr, transamount);
            }
        }
        Set ids = list.parallelStream().map(d -> d.getDataEntity().getPkValue()).collect(Collectors.toSet());
        DynamicObject[] dbPaybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        Map<Long, DynamicObjectCollection> dbBillMap = ((Stream)Arrays.stream(dbPaybills).parallel()).collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getDynamicObjectCollection("draftbill")));
        Set sourceIds = list.parallelStream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getDataEntity().getLong("sourcebillid"))).map(d -> d.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObjectCollection tradeList = null;
        if (CasHelper.isNotEmpty(sourceIds)) {
            tradeList = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id,tradetype,deposit", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceIds)});
        }
        HashMap tradeMap = null == tradeList ? new HashMap() : tradeList.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        for (ExtendedDataEntity dataEntity : list) {
            long sourceBillId;
            DynamicObject trade;
            Iterator draf2;
            DynamicObjectCollection drafs;
            BigDecimal draftAmt = Constants.ZERO;
            DynamicObject payBill = dataEntity.getDataEntity();
            Long id = payBill.getLong("id");
            DynamicObjectCollection draftbillColl = payBill.getDynamicObjectCollection("draftbill");
            if (!draftbillColl.isEmpty() && EmptyUtil.isNoEmpty(dbBillMap) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(drafs = dbBillMap.get(id)))) {
                for (Iterator draf2 : drafs) {
                    DynamicObject basedata = (DynamicObject)draf2.get("fbasedataid");
                    if (basedata == null) continue;
                    draftIds.add(basedata.getLong("id"));
                }
            }
            String sBillType = payBill.getString("sourcebilltype");
            boolean hasDraf = false;
            draf2 = draftbillColl.iterator();
            while (draf2.hasNext()) {
                DynamicObject draftbill = (DynamicObject)draf2.next();
                DynamicObject basedata = (DynamicObject)draftbill.get("fbasedataid");
                if (basedata == null) continue;
                boolean isendorsepay = basedata.getBoolean("isendorsepay");
                if (!EmptyUtil.isEmpty((String)isPushAndSave) || SRCBILL_TYPES.contains(sBillType) || !isendorsepay || !draftIds.contains(((DynamicObject)draftbill.get("fbasedataid")).getLong("id"))) {
                    // empty if block
                }
                long draftId = draftbill.getDynamicObject("fbasedataid").getLong("id");
                String keyStr = id + "_" + draftId;
                draftAmt = !paybillTrans.containsKey(keyStr) ? draftAmt.add(((DynamicObject)draftbill.get("fbasedataid")).getBigDecimal("amount")) : draftAmt.add((BigDecimal)paybillTrans.get(keyStr));
                hasDraf = true;
            }
            if (ifBatchInput && sourceoperation.equals("batchpaybill")) {
                hasDraf = false;
            }
            draftIds.clear();
            BigDecimal actPayAmt = payBill.getBigDecimal("actpayamt");
            if (actPayAmt.compareTo(draftAmt) != 0) {
                if (endorseRecBill) {
                    if (StringUtils.isNotEmpty((String)recBillId)) {
                        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill", (String)"id, actrecamt");
                        draftAmt = draftAmt.subtract(recBill.getBigDecimal("actrecamt"));
                    }
                } else {
                    Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"cas_paybill", (Long[])new Long[]{id});
                    if (targetBills != null && targetBills.size() > 0 && targetBills.containsKey("cas_recbill") && targetBills.get("cas_recbill") != null) {
                        DynamicObject recBillSel = BusinessDataServiceHelper.loadSingle(((HashSet)targetBills.get("cas_recbill")).iterator().next(), (String)"cas_recbill", (String)"id, actrecamt");
                        draftAmt = draftAmt.subtract(recBillSel.getBigDecimal("actrecamt"));
                    }
                }
            }
            if (draftbillColl.isEmpty() || !hasDraf) continue;
            if (payBill.getDynamicObject("entrustorg") != null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u4e3a\u627f\u5151\u6c47\u7968\u3001\u652f\u7968\u6216\u672c\u7968\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301\u59d4\u6258\u4ed8\u6b3e\u3001\u4ee3\u7406\u4ed8\u6b3e\u4e1a\u52a1\u3002", (String)"PayEndorseSaveValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            String tradeType = EmptyUtil.isEmpty((DynamicObject)(trade = (DynamicObject)tradeMap.get(sourceBillId = payBill.getLong("sourcebillid")))) ? "" : trade.getString("tradetype");
            boolean deposit = EmptyUtil.isEmpty((DynamicObject)trade) ? false : trade.getBoolean("deposit");
            Boolean isBillBids = payBill.getBoolean("isbilldibs");
            String operateKey = this.getOperateKey();
            logger.info("PaymentBillEndorseSaveValidator operateKey is that :" + operateKey);
            if (!deposit && actPayAmt.compareTo(draftAmt) > 0 && "submit".equals(operateKey)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u5355\u5b9e\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6240\u9009\u7968\u636e\u7684\u7968\u9762\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7968\u636e\u6216\u4fee\u6539\u5b9e\u4ed8\u91d1\u989d\u3002", (String)"PayEndorseSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (isBillBids.booleanValue() || TRADE_TYPES.contains(tradeType) || actPayAmt.compareTo(draftAmt) >= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"BillEndorse:\u672c\u5355\u5b9e\u4ed8\u91d1\u989d\u5c0f\u4e8e\u6240\u9009\u7968\u636e\u7684\u7968\u9762\u91d1\u989d\uff0c\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u65b9\u8865\u5dee\u989d\u7684\u6536\u6b3e\u5355\u3002", (String)"PayEndorseSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        logger.info("PaymentBillEndorseSaveValidator validate end");
    }
}

