/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.util.EmptyUtil;

public class PaymentCashSubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billtype");
        preparePropertys.add("businesstype");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            DynamicObject billType = info.getDynamicObject("billtype");
            String businessType = info.getString("businesstype");
            if (!EmptyUtil.isNoEmpty((DynamicObject)billType) || !BillTypeConstants.PAYBILL_CASH.equals(billType.getPkValue()) || !EmptyUtil.isEmpty((String)businessType)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentCashSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

