/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentDynamicValidator
extends AbstractValidator {
    public void validate() {
        Map<String, String> allProps = null;
        Boolean isUserInGroup = LicenseServiceHelper.checkPerformGroup((String)"PRO_MAP").getHasLicense();
        HashMap<Long, Map<String, CRCondition>> mustConditionFilterMap = new HashMap<Long, Map<String, CRCondition>>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject ctt;
            DynamicObject info = dataEntity.getDataEntity();
            if (null == allProps) {
                allProps = this.getAllProps(info);
            }
            if (!info.getBoolean("iscrosspay") || !"bei".equals(info.getString("paymentchannel"))) continue;
            if ("cas_agentpaybill".equals(info.getDynamicObjectType().getName())) {
                if (!isUserInGroup.booleanValue()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u83b7\u53d6\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u7684\u4ea7\u54c1\u8bb8\u53ef\u3002", (String)"PaymentDynamicValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue;
                }
            } else {
                DynamicObject paymentIdentify = info.getDynamicObject("paymentidentify");
                if (EmptyUtil.isNoEmpty((DynamicObject)paymentIdentify) && "0".equals(paymentIdentify.getString("type"))) {
                    boolean flag = false;
                    if (!isUserInGroup.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u83b7\u53d6\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u7684\u4ea7\u54c1\u8bb8\u53ef\u3002", (String)"PaymentDynamicValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        flag = true;
                    }
                    if (info.getDate("expectdate") == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u5f55\u5165\u671f\u671b\u4ed8\u6b3e\u65e5\u671f\u3002", (String)"PaymentDynamicValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        flag = true;
                    }
                    if (flag) continue;
                }
            }
            if ((ctt = info.getDynamicObject("crosstrantype")) == null) continue;
            DynamicObjectCollection entries = this.getFinallyMustField((Long)ctt.getPkValue(), mustConditionFilterMap, info.getDynamicObjectType().getName(), info);
            for (DynamicObject entry : entries) {
                String feildName = entry.getString("fieldkey");
                String feildArea = allProps.get(feildName);
                if (StringUtils.isEmpty((CharSequence)feildArea)) continue;
                boolean isEntryField = "entry".equals(feildArea);
                if (isEntryField) {
                    DynamicObjectCollection dataEntrys = info.getDynamicObjectCollection("entry");
                    if (CollectionUtils.isEmpty((Collection)dataEntrys)) continue;
                    int len = dataEntrys.size();
                    for (int i = 0; i < len; ++i) {
                        DynamicObject dataEntry = (DynamicObject)dataEntrys.get(i);
                        Object obj = dataEntry.get(feildName);
                        this.verify(dataEntity, obj, isEntryField, entry, i);
                    }
                    continue;
                }
                this.verify(dataEntity, info.get(feildName), isEntryField, entry, 0);
            }
        }
    }

    private void verify(ExtendedDataEntity dataEntity, Object value, boolean isEntryField, DynamicObject entry, int rowIndex) {
        this.verifyMustInput(dataEntity, value, isEntryField, entry, rowIndex);
        String fieldType = entry.getString("fieldtype");
        boolean isLimitLen = entry.getBoolean("islimitlength");
        if (isLimitLen && fieldType.endsWith("text") && null != value) {
            this.verifyLen(dataEntity, isEntryField, value, entry, rowIndex);
        }
    }

    private void verifyMustInput(ExtendedDataEntity dataEntity, Object value, boolean isEntryField, DynamicObject entry, int rowIndex) {
        boolean isMustInput = entry.getBoolean("isnotnull");
        String msg = "";
        if (isMustInput && CasHelper.isEmpty((Object)value)) {
            msg = isEntryField ? String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7b2c%1$s\u884c%2$s\u3002", (String)"PaymentDynamicValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), rowIndex + 1, entry.getString("fieldname")) : String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"PaymentDynamicValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), entry.getString("fieldname"));
        }
        if (msg.length() > 0) {
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private void verifyLen(ExtendedDataEntity dataEntity, boolean isEntryField, Object value, DynamicObject entry, int rowIndex) {
        String msg = "";
        int len = entry.getInt("maxlength");
        if (((String)value).length() > len) {
            msg = isEntryField ? String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c%s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\u3002", (String)"PaymentDynamicValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), rowIndex + 1, entry.getString("fieldname"), len) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u201c%2$s\u201d\u3002", (String)"PaymentDynamicValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), entry.getString("fieldname"), len);
        }
        if (msg.length() > 0) {
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private Map<String, String> getAllProps(DynamicObject info) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        DataEntityPropertyCollection properties = info.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                DataEntityPropertyCollection entryProps = p.getDynamicCollectionItemPropertyType().getProperties();
                entryProps.forEach(prop -> fieldMap.put(prop.getName(), "entry"));
                continue;
            }
            fieldMap.put(property.getName(), "head");
        }
        return fieldMap;
    }

    private DynamicObjectCollection getFinallyMustField(Long crossTranTypeId, Map<Long, Map<String, CRCondition>> mustConditionFilterMap, String formId, DynamicObject info) {
        DynamicObject crossTranType = BusinessDataServiceHelper.loadSingle((Object)crossTranTypeId, (String)"bei_crosstrantype");
        DynamicObjectCollection entries = crossTranType.getDynamicObjectCollection("entry");
        entries.removeIf(v -> !v.getBoolean("issee"));
        if ("cas_paybill".equals(formId)) {
            Map<String, CRCondition> filterMap = mustConditionFilterMap.get(crossTranTypeId);
            if (filterMap == null) {
                filterMap = new HashMap<String, CRCondition>(16);
                mustConditionFilterMap.put(crossTranTypeId, filterMap);
                List conditionMustFieldList = entries.stream().filter(e -> e.getBoolean("isnotnull") && StringUtils.isNotBlank((CharSequence)e.getString("mustfillcondition_tag"))).collect(Collectors.toList());
                for (DynamicObject field : conditionMustFieldList) {
                    String mustFillConditionTag = field.getString("mustfillcondition_tag");
                    CRCondition condition = (CRCondition)JSON.parseObject((String)mustFillConditionTag, CRCondition.class);
                    filterMap.put(field.getString("fieldkey"), condition);
                }
            }
            for (Map.Entry<String, CRCondition> mustFieldFilter : filterMap.entrySet()) {
                CRCondition condition = mustFieldFilter.getValue();
                boolean match = CasHelper.isMatchCondition((CRCondition)condition, (DynamicObject)info);
                if (match) continue;
                String mustField = mustFieldFilter.getKey();
                entries.removeIf(f -> mustField.equals(f.getString("fieldkey")));
            }
        }
        return entries;
    }
}

