/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.BillStatusHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecBillCancelRecValidator
extends AbstractValidator {
    public static final String PARA_VOUCHERIDS = "voucherIds:";
    private static final Log logger = LogFactory.getLog(RecBillCancelRecValidator.class);
    private JournalServiceAdapter journalServiceAdapter = null;

    public RecBillCancelRecValidator(JournalServiceAdapter journalServiceAdapter) {
        this.journalServiceAdapter = journalServiceAdapter;
    }

    public void validate() {
        LinkedList<Long> recBillPks = new LinkedList<Long>();
        Map param = this.getOption().getVariables();
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        List lockedIds = TxCheckUtil.getLocked(ids);
        String isLock = "false";
        if (this.getOption().containsVariable("isLock")) {
            isLock = this.getOption().getVariableValue("isLock");
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            if (!"true".equals(isLock) && lockedIds.contains(data.getDataEntity().getString("id"))) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, error, ErrorLevel.Error);
            }
            recBillPks.add((Long)data.getBillPkId());
            DynamicObject accountbank = data.getDataEntity().getDynamicObject("accountbank");
            if (!CasHelper.isNotEmpty((Object)accountbank) || !"closed".equals(accountbank.getString("acctstatus"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u72b6\u6001\u662f\u5df2\u9500\u6237\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        HashSet recPksWithSettleRecordsVouchered = new HashSet();
        QFilter otherFilter = new QFilter("isvoucher", "=", (Object)"1");
        List mainBillIds = SettleRecordQueryHelperForCas.getBillIdsByMain((String)"ar_settlerecord", (String)"cas_recbill", (Object[])recBillPks.toArray(), (QFilter)otherFilter);
        List asstBillIds = SettleRecordQueryHelperForCas.getBillIdsByAsst((String)"ar_settlerecord", (String)"cas_recbill", (Object[])recBillPks.toArray(), (QFilter)otherFilter);
        recPksWithSettleRecordsVouchered.addAll(mainBillIds);
        recPksWithSettleRecordsVouchered.addAll(asstBillIds);
        Set<Object> recIdSet = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection infoDts = QueryServiceHelper.query((String)"cas_recbill", (String)"id,isrefund,hotaccount,org,confirmlogo,sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", recIdSet)});
        Map infoMap = infoDts.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        Map<Long, DynamicObject> recIdMap = Arrays.stream(this.dataEntities).collect(Collectors.toMap(o -> o.getDataEntity().getLong("id"), ExtendedDataEntity::getDataEntity));
        List rightStatusBatch = BillStatusHelper.isRightStatusBatch((String)"cas_recbill", recIdSet, (BillStatusEnum)BillStatusEnum.PAY);
        HashMap errorResult = new HashMap();
        this.journalServiceAdapter.validateCancelBooks(recIdMap, errorResult, new HashMap(), true);
        ArrayList<Long> voucherList = new ArrayList<Long>();
        Long[] recBillIds = (Long[])Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("id")).distinct().toArray(Long[]::new);
        Set hasNextCdmRecBillIdSet = CasBotpHelper.getDestCdmRecBillSet((Long[])recBillIds);
        for (ExtendedDataEntity data : this.dataEntities) {
            Exception exception;
            DynamicObjectCollection recEntryCol;
            boolean matchBoolean;
            DynamicObject info;
            Long billPkId;
            long recBillId;
            boolean isUsed;
            DynamicObject recBill = data.getDataEntity();
            if (!rightStatusBatch.contains(recBill.getPkValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u6536\u6b3e\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"ReceivErrorCode_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (isUsed = recBill.getBoolean("isused")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u53d6\u6d88\u6536\u6b3e\u3002", (String)"ReceivErrorCode_1_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (hasNextCdmRecBillIdSet.contains(recBillId = recBill.getLong("id"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u636e\u5b58\u5728\u5173\u8054\u5355\u636e\u4e0d\u80fd\u53d6\u6d88\u6536\u6b3e\u3002", (String)"ReceivErrorCode_1_2", (String)"fi-cas-business", (Object[])new Object[0]));
                break;
            }
            if (!"true".equals(param.get("byfca")) && "fca_transdownbill".equals(recBill.getString("sourcebilltype"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u62e8\u5355\u751f\u6210\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_0", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (!"true".equals(param.get("byfca")) && "fca_transupbill".equals(recBill.getString("sourcebilltype"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0a\u5212\u5355\u751f\u6210\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_5", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            DynamicObject org = recBill.getDynamicObject("org");
            DynamicObjectCollection draftbillColl = recBill.getDynamicObjectCollection("draftbill");
            if (draftbillColl.size() > 0) {
                List draftBillIds = draftbillColl.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter tQFilter = new QFilter("id", "in", draftBillIds);
                QFilter casSource = new QFilter("source", "=", (Object)"cas");
                QFilter orCasSource = new QFilter("source", "!=", (Object)"cas");
                orCasSource.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                String noticeClaimAllowStatus = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"noticeclaimallowstatus");
                List<String> allowStatusList = Arrays.asList(noticeClaimAllowStatus.split(","));
                ArrayList<String> draftBillStatusList = new ArrayList<String>();
                for (String allowStatus : allowStatusList) {
                    if (EmptyUtil.isEmpty((String)allowStatus)) continue;
                    draftBillStatusList.add(allowStatus);
                }
                orCasSource.and("draftbillstatus", "in", draftBillStatusList);
                orCasSource.and("draftbilltranstatus", "=", (Object)"success");
                tQFilter.and(casSource.or(orCasSource));
                DynamicObjectCollection draftDataArr = QueryServiceHelper.query((String)"cdm_payandrecdraft_f7", (String)"id", (QFilter[])new QFilter[]{tQFilter});
                if (draftDataArr == null || draftBillIds.size() != draftDataArr.size()) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u4e0d\u5728\u5141\u8bb8\u6536\u6b3e\u5173\u8054\u7684\u7968\u636e\u72b6\u6001\u8303\u56f4\u5185\uff0c\u6682\u4e0d\u652f\u6301\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_6", (String)"fi-cas-business", (Object[])new Object[0]), String.join((CharSequence)recBill.getString("billno"), "\u3010", "\u3011")));
                }
            }
            Set srcBill = CasBotpHelper.getSrcBillByDestBill((Long)recBill.getLong("id"), (String)recBill.getDataEntityType().getName(), (String)"cas_paybill");
            if (CasHelper.isEmpty((Object)recBill.getString("sourcebilltype")) && !CasHelper.isEmpty((Object)srcBill)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            this.settleValidate(data);
            boolean validataVoucher = this.validataVoucher(recBill, voucherList);
            if (validataVoucher) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u6b3e\u5931\u8d25\uff0c\u56e0\u4e3a\u53d6\u6d88\u6536\u6b3e\u65f6\u51b2\u9500\u51ed\u8bc1\u5931\u8d25\uff1a\u51ed\u8bc1\u4e0d\u662f\u5df2\u8fc7\u8d26\u72b6\u6001\u3002", (String)"RecBillCancelRecImpl_4", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (recPksWithSettleRecordsVouchered.contains(billPkId = (Long)data.getBillPkId())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (CasHelper.isEmpty((Object)(info = (DynamicObject)infoMap.get(billPkId)))) continue;
            boolean isrefund = info.getBoolean("isrefund");
            if (isrefund) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u9000\u7968\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (HotAccountEnum.HOTEDBILL.getValue().equals(info.getString("hotaccount")) || HotAccountEnum.HOTBILL.getValue().equals(info.getString("hotaccount"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u53d1\u751f\u7ea2\u51b2\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (matchBoolean = (recEntryCol = data.getDataEntity().getDynamicObjectCollection("entry")).stream().anyMatch(recEntry -> recEntry.getBoolean("e_matchselltag"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u672c\u7b14\u6536\u6b3e\u5df2\u5b8c\u6210\u4e0e\u9500\u552e\u8ba2\u5355/\u9500\u552e\u5408\u540c\u7684\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\uff0c\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5148\u524d\u5f80\u201c\u9500\u552e\u7ba1\u7406\u201d/\u201c\u5408\u540c\u7ba1\u7406\u201d\u53d6\u6d88\u5339\u914d\u3002", (String)"RecBillCancelRecValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (null == (exception = (Exception)errorResult.get(billPkId))) continue;
            this.addErrorMessage(data, exception.getMessage());
        }
        this.getOption().setVariableValue(PARA_VOUCHERIDS, SerializationUtils.toJsonString(voucherList));
        this.billReverseOpValidate(recIdSet, recIdMap);
    }

    public void billReverseOpValidate(Set<Object> recIdSet, Map<Long, DynamicObject> recIdMap) {
        List<String> targetStrings = Arrays.asList("cas_recbill", "cas_paybill", "ap_finapbill");
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"cas_recbill", (Long[])recIdSet.toArray(new Long[0]));
        if (CasHelper.isNotEmpty((Object)targetBills)) {
            for (Map.Entry entry : targetBills.entrySet()) {
                DynamicObject[] destBills;
                String targetKey = (String)entry.getKey();
                HashSet sourcePks = (HashSet)entry.getValue();
                if (!targetStrings.contains(targetKey)) continue;
                for (DynamicObject destBill : destBills = BusinessDataServiceHelper.load((Object[])sourcePks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)targetKey))) {
                    boolean temp = false;
                    if ("cdm_receivablebill".equals(targetKey)) {
                        if (!"A".equals(destBill.getString("billstatus")) && "cas".equals(destBill.getString("source"))) {
                            temp = true;
                        }
                    } else if (!"A".equals(destBill.getString("billstatus"))) {
                        temp = true;
                    }
                    if (!temp) continue;
                    Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)targetKey, (Long[])new Long[]{destBill.getLong("id")});
                    HashSet recId = (HashSet)sourceBills.get("cas_recbill");
                    String infoBillName = "";
                    String infoBillNumber = "";
                    Iterator iterator = recId.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject infoBill = recIdMap.get(iterator.next());
                        infoBillName = infoBill.getDataEntityType().getDisplayName().getLocaleValue();
                        infoBillNumber = infoBill.getString("billno");
                    }
                    String billno = destBill.getString("billno");
                    throw new KDBizException(ResManager.loadKDString((String)String.format(ResManager.loadKDString((String)"%1$s%2$s\u751f\u6210\u4e86%3$s\u516c\u53f8\u7684%4$s%5$s\uff0c\u76ee\u524d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u53cd\u5411\u64cd\u4f5c%6$s%7$s\u3002", (String)"ValidateReclateOperation_1", (String)"fi-cas-business", (Object[])new Object[0]), infoBillNumber, infoBillName, destBill.getString("org.name"), billno, destBill.getDataEntityType().getDisplayName(), billno, destBill.getDataEntityType().getDisplayName()), (String)"ValidateReclateOperation_0", (String)"fi-cas-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private void settleValidate(ExtendedDataEntity dataEntity) {
        Object result;
        DynamicObject recBill = dataEntity.getDataEntity();
        boolean exists = SettleRecordQueryHelperForCas.isExistsSettlesByMain((String)"ar_settlerecord", (String)"cas_recbill", (Object[])new Object[]{recBill.getPkValue()}, null);
        boolean exists2 = SettleRecordQueryHelperForCas.isExistsSettlesByAsst((String)"ar_settlerecord", (String)"cas_recbill", (Object[])new Object[]{recBill.getPkValue()}, null);
        if ((exists || exists2) && (result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"AutoUnSettleValidate", (String)"unSettleValidate", (Object[])new Object[]{recBill})) != null) {
            String messages = ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u53cd\u5199\u6821\u9a8c\u5f02\u5e38\u3002", (String)"WriteBackTaskHelper_0", (String)"fi-cas-business", (Object[])new Object[0]);
            OperationResult operationResult = null;
            try {
                if (result instanceof OperationResult) {
                    operationResult = (OperationResult)result;
                }
                if (operationResult == null) {
                    return;
                }
                ValidateResultCollection validateResults = operationResult.getValidateResult();
                List validateErrors = validateResults.getValidateErrors("");
                if (!operationResult.isSuccess()) {
                    logger.info("\u6821\u9a8c\u7ed3\u679c\u96c6\uff1a" + validateErrors.size());
                    if (validateErrors.size() > 0) {
                        List allErrorInfo = ((ValidateResult)validateErrors.get(0)).getAllErrorInfo();
                        messages = ((ValidateResult)validateErrors.get(0)).getMessage();
                        if (allErrorInfo != null && allErrorInfo.size() > 0) {
                            logger.info("\u7ed3\u679c\u96c6" + ((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
                            messages = ((OperateErrorInfo)allErrorInfo.get(0)).getMessage();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.info("WriteBackResultDeal" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            if (operationResult != null && !operationResult.isSuccess()) {
                this.addErrorMessage(dataEntity, messages);
            }
        }
    }

    private boolean validataVoucher(DynamicObject recBill, List<Long> voucherList) {
        String orgId;
        Set recOrgIdSet = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map systemParamsMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(recOrgIdSet));
        String CS114 = (String)((Map)systemParamsMap.get(orgId = recBill.getDynamicObject("org").getString("id"))).get("cs114");
        if ("1".equals(CS114)) {
            Set vouchers = DapVoucherUtil.getBuildVch(Collections.singleton(recBill.getPkValue()), (String)"cas_recbill");
            if (vouchers == null || vouchers.size() == 0) {
                return Boolean.FALSE;
            }
            voucherList.addAll(vouchers);
            return VoucherBookHelper.checkVoucherIsPost((Set)vouchers);
        }
        return Boolean.FALSE;
    }
}

